/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode.mindmapmode;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.LoadAcceleratorPresetsAction;

class SaveAcceleratorPresetsAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public SaveAcceleratorPresetsAction() {
        super("SaveAcceleratorPresetsAction");
    }

    public void actionPerformed(ActionEvent e) {
        int confirm;
        String keyset = JOptionPane.showInputDialog(TextUtils.getText((String)"enter_keyset_name"));
        if (keyset == null || keyset.equals("")) {
            return;
        }
        File acceleratorsUserDirectory = LoadAcceleratorPresetsAction.getAcceleratorsUserDirectory();
        File keysetFile = new File(acceleratorsUserDirectory, keyset + ".properties");
        if (keysetFile.exists() && (confirm = JOptionPane.showConfirmDialog(UITools.getMenuComponent(), TextUtils.getText((String)"overwrite_keyset_question"), "Freeplane", 0)) != 0) {
            return;
        }
        try {
            acceleratorsUserDirectory.mkdirs();
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(keysetFile));
            IUserInputListenerFactory userInputListenerFactory = Controller.getCurrentModeController().getUserInputListenerFactory();
            ResourceController.getResourceController().getAcceleratorManager().storeAcceleratorPreset((OutputStream)output);
            ((OutputStream)output).close();
            userInputListenerFactory.rebuildMenus("load_accelerator_presets");
        }
        catch (IOException e1) {
            UITools.errorMessage((Object)TextUtils.getText((String)"can_not_save_key_set"));
        }
    }
}

