/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation.mindmapmode;

import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodelocation.LocationModel;

final class ChangeShiftXActor
implements IActor {
    private final Quantity<LengthUnits> shiftX;
    private final NodeModel node;
    private final Quantity<LengthUnits> oldShiftX;

    ChangeShiftXActor(NodeModel node, Quantity<LengthUnits> shiftX) {
        LocationModel locationModel = LocationModel.getModel((NodeModel)node);
        this.oldShiftX = locationModel.getHGap();
        this.node = node;
        this.shiftX = shiftX;
    }

    public void act() {
        this.setShiftX(this.node, this.shiftX);
    }

    public String getDescription() {
        return "moveNodePosition";
    }

    private void setShiftX(NodeModel node, Quantity<LengthUnits> hGap) {
        LocationModel locationModel = LocationModel.createLocationModel((NodeModel)node);
        locationModel.setHGap(hGap);
        Controller.getCurrentModeController().getMapController().nodeChanged(node);
    }

    public void undo() {
        this.setShiftX(this.node, this.oldShiftX);
    }
}

