/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation.mindmapmode;

import java.util.ArrayList;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodelocation.mindmapmode.ChangeShiftXActor;
import org.freeplane.features.nodelocation.mindmapmode.ChangeShiftYActor;
import org.freeplane.features.nodelocation.mindmapmode.ChangeVGapActor;
import org.freeplane.features.nodelocation.mindmapmode.ResetNodeLocationAction;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MLocationController
extends LocationController {
    public MLocationController() {
        ModeController modeController = Controller.getCurrentModeController();
        this.createActions(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new StyleCopier());
    }

    private void createActions(ModeController modeController) {
        modeController.addAction((AFreeplaneAction)new ResetNodeLocationAction());
    }

    public void moveNodePosition(NodeModel node, Quantity<LengthUnits> hGap, Quantity<LengthUnits> shiftY) {
        ModeController currentModeController = Controller.getCurrentModeController();
        MapModel map = node.getMap();
        ArrayList<Object> actors = new ArrayList<Object>(3);
        actors.add(new ChangeShiftXActor(node, hGap));
        actors.add(new ChangeShiftYActor(node, shiftY));
        for (IActor iActor : actors) {
            currentModeController.execute(iActor, map);
        }
    }

    public void setHorizontalShift(NodeModel node, Quantity<LengthUnits> horizontalShift) {
        ChangeShiftXActor actor = new ChangeShiftXActor(node, horizontalShift);
        Controller.getCurrentModeController().execute((IActor)actor, node.getMap());
    }

    public void setVerticalShift(NodeModel node, Quantity<LengthUnits> verticalShift) {
        ChangeShiftYActor actor = new ChangeShiftYActor(node, verticalShift);
        Controller.getCurrentModeController().execute((IActor)actor, node.getMap());
    }

    public void setMinimalDistanceBetweenChildren(NodeModel node, Quantity<LengthUnits> minimalDistanceBetweenChildren) {
        if (node != null) {
            Quantity.assertNonNegativeOrNull(minimalDistanceBetweenChildren);
            ChangeVGapActor actor = new ChangeVGapActor(node, minimalDistanceBetweenChildren);
            Controller.getCurrentModeController().execute((IActor)actor, node.getMap());
        }
    }

    private static class StyleCopier
    implements IExtensionCopier {
        private StyleCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            LocationModel source = (LocationModel)from.getExtension(LocationModel.class);
            if (source != null) {
                LocationModel.createLocationModel((NodeModel)to).setVGap(source.getVGap());
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            LocationModel target = (LocationModel)from.getExtension(LocationModel.class);
            if (target != null) {
                target.setVGap(LocationModel.DEFAULT_VGAP);
            }
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            LocationModel model = (LocationModel)which.getExtension(LocationModel.class);
            if (model != null && model.getVGap() != LocationModel.DEFAULT_VGAP) {
                this.remove(key, from);
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
        }
    }
}

