/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle.mindmapmode;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.Quantity;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.features.nodestyle.mindmapmode.BoldAction;
import org.freeplane.features.nodestyle.mindmapmode.CopyFormat;
import org.freeplane.features.nodestyle.mindmapmode.ItalicAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeBackgroundColorAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeColorAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeColorBlendAction;
import org.freeplane.features.nodestyle.mindmapmode.NodeShapeAction;
import org.freeplane.features.nodestyle.mindmapmode.PasteFormat;
import org.freeplane.features.nodestyle.mindmapmode.RemoveFormatAction;
import org.freeplane.features.nodestyle.mindmapmode.TextAlignAction;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MNodeStyleController
extends NodeStyleController {
    public MNodeStyleController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new StyleCopier(modeController));
        modeController.addAction((AFreeplaneAction)new BoldAction());
        modeController.addAction((AFreeplaneAction)new ItalicAction());
        modeController.addAction((AFreeplaneAction)new CopyFormat());
        modeController.addAction((AFreeplaneAction)new PasteFormat());
        modeController.addAction((AFreeplaneAction)new RemoveFormatAction());
        modeController.addAction((AFreeplaneAction)new TextAlignAction(NodeStyleModel.TextAlign.LEFT));
        modeController.addAction((AFreeplaneAction)new TextAlignAction(NodeStyleModel.TextAlign.CENTER));
        modeController.addAction((AFreeplaneAction)new TextAlignAction(NodeStyleModel.TextAlign.RIGHT));
        AMultipleNodeAction increaseNodeFont = new AMultipleNodeAction("IncreaseNodeFontAction"){
            private static final long serialVersionUID = 1L;

            protected void actionPerformed(ActionEvent e, NodeModel node) {
                MNodeStyleController.this.increaseFontSize(node, 1);
            }
        };
        modeController.addAction((AFreeplaneAction)increaseNodeFont);
        AMultipleNodeAction decreaseNodeFont = new AMultipleNodeAction("DecreaseNodeFontAction"){
            private static final long serialVersionUID = 1L;

            protected void actionPerformed(ActionEvent e, NodeModel node) {
                MNodeStyleController.this.increaseFontSize(node, -1);
            }
        };
        modeController.addAction((AFreeplaneAction)decreaseNodeFont);
        modeController.addAction((AFreeplaneAction)new NodeColorAction());
        modeController.addAction((AFreeplaneAction)new NodeColorBlendAction());
        modeController.addAction((AFreeplaneAction)new NodeBackgroundColorAction());
        for (NodeStyleModel.Shape shape : NodeStyleModel.Shape.values()) {
            if (shape.equals((Object)NodeStyleModel.Shape.as_parent)) break;
            modeController.addAction((AFreeplaneAction)new NodeShapeAction(shape));
        }
    }

    public void copyStyle(NodeModel source, NodeModel target) {
        this.copyStyleModel(source, target);
        this.copySizeModel(source, target);
    }

    protected void copyStyleModel(NodeModel source, NodeModel target) {
        NodeStyleModel sourceStyleModel = NodeStyleModel.getModel((NodeModel)source);
        if (sourceStyleModel != null) {
            this.setColor(target, sourceStyleModel.getColor());
            this.setBackgroundColor(target, sourceStyleModel.getBackgroundColor());
            this.setShapeConfiguration(target, sourceStyleModel.getShapeConfiguration());
            this.setFontFamily(target, sourceStyleModel.getFontFamilyName());
            this.setFontSize(target, sourceStyleModel.getFontSize());
            this.setBold(target, sourceStyleModel.isBold());
            this.setItalic(target, sourceStyleModel.isItalic());
            this.setNodeFormat(target, sourceStyleModel.getNodeFormat());
            this.setNodeNumbering(target, sourceStyleModel.getNodeNumbering());
            this.setTextAlign(target, sourceStyleModel.getTextAlign());
        }
    }

    protected void copySizeModel(NodeModel source, NodeModel target) {
        NodeSizeModel sourceSizeModel = NodeSizeModel.getModel((NodeModel)source);
        if (sourceSizeModel != null) {
            this.setMaxNodeWidth(target, (Quantity<LengthUnits>)sourceSizeModel.getMaxNodeWidth());
            this.setMinNodeWidth(target, (Quantity<LengthUnits>)sourceSizeModel.getMinNodeWidth());
        }
    }

    private NodeStyleModel createOwnStyleModel(final NodeModel node) {
        NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
        if (styleModel != null) {
            return styleModel;
        }
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                node.addExtension((IExtension)new NodeStyleModel());
            }

            public String getDescription() {
                return null;
            }

            public void undo() {
                node.removeExtension(NodeStyleModel.class);
            }
        };
        modeController.execute(actor, node.getMap());
        return NodeStyleModel.getModel((NodeModel)node);
    }

    private NodeSizeModel createOwnSizeModel(final NodeModel node) {
        NodeSizeModel sizeModel = NodeSizeModel.getModel((NodeModel)node);
        if (sizeModel != null) {
            return sizeModel;
        }
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                node.addExtension((IExtension)new NodeSizeModel());
            }

            public String getDescription() {
                return null;
            }

            public void undo() {
                node.removeExtension(NodeSizeModel.class);
            }
        };
        modeController.execute(actor, node.getMap());
        return NodeSizeModel.getModel((NodeModel)node);
    }

    public void increaseFontSize(NodeModel node, int increment) {
        int newSize = this.getFontSize(node) + increment;
        if (newSize > 0) {
            this.setFontSize(node, newSize);
        }
    }

    public void setBackgroundColor(final NodeModel node, final Color color) {
        ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = NodeStyleModel.getBackgroundColor((NodeModel)node);
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setBackgroundColor((NodeModel)node, (Color)color);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setBackgroundColor";
            }

            public void undo() {
                NodeStyleModel.setBackgroundColor((NodeModel)node, (Color)oldColor);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setBold(final NodeModel node, final Boolean bold) {
        final Boolean oldBold = NodeStyleModel.isBold((NodeModel)node);
        if (oldBold == bold || oldBold != null && oldBold.equals(bold)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setBold(bold);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setBold";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setBold(oldBold);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setColor(final NodeModel node, final Color color) {
        ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = NodeStyleModel.getColor((NodeModel)node);
        if (oldColor == color || oldColor != null && oldColor.equals(color)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setColor((NodeModel)node, (Color)color);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setColor";
            }

            public void undo() {
                NodeStyleModel.setColor((NodeModel)node, (Color)oldColor);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setFontFamily(final NodeModel node, final String fontFamily) {
        final String oldFontFamily = NodeStyleModel.getFontFamilyName((NodeModel)node);
        if (oldFontFamily == fontFamily || oldFontFamily != null && oldFontFamily.equals(fontFamily)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontFamilyName(fontFamily);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFontFamily";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontFamilyName(oldFontFamily);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setFontFamily(String fontFamily) {
        for (NodeModel selected : Controller.getCurrentModeController().getMapController().getSelectedNodes()) {
            this.setFontFamily(selected, fontFamily);
        }
    }

    public void setFontSize(int size) {
        Collection selectedNodes = Controller.getCurrentModeController().getMapController().getSelectedNodes();
        for (NodeModel selected : selectedNodes) {
            this.setFontSize(selected, size);
        }
    }

    public void setFontSize(final NodeModel node, final Integer fontSize) {
        final Integer oldFontSize = NodeStyleModel.getFontSize((NodeModel)node);
        if (oldFontSize == fontSize || oldFontSize != null && oldFontSize.equals(fontSize)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontSize(fontSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setFontSize";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setFontSize(oldFontSize);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setItalic(final NodeModel node, final Boolean italic) {
        final Boolean oldItalic = NodeStyleModel.isItalic((NodeModel)node);
        if (oldItalic == italic || oldItalic != null && oldItalic.equals(italic)) {
            return;
        }
        this.createOwnStyleModel(node);
        ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setItalic(italic);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setItalic";
            }

            public void undo() {
                NodeStyleModel styleModel = NodeStyleModel.getModel((NodeModel)node);
                styleModel.setItalic(oldItalic);
                Controller.getCurrentModeController().getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setNodeNumbering(final NodeModel node, final Boolean enableNodeNumbering) {
        final ModeController modeController = Controller.getCurrentModeController();
        final Boolean oldValue = NodeStyleModel.getNodeNumbering((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setNodeNumbering((NodeModel)node, (Boolean)enableNodeNumbering);
                MapController mapController = modeController.getMapController();
                mapController.setSaved(node.getMap(), false);
                mapController.delayedNodeRefresh(node, (Object)"NodeNumbering", (Object)oldValue, (Object)enableNodeNumbering);
            }

            public String getDescription() {
                return "setNodeNumbering";
            }

            public void undo() {
                NodeStyleModel.setNodeNumbering((NodeModel)node, (Boolean)oldValue);
                MapController mapController = modeController.getMapController();
                mapController.setSaved(node.getMap(), false);
                modeController.getMapController().delayedNodeRefresh(node, (Object)"NodeNumbering", (Object)enableNodeNumbering, (Object)oldValue);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setNodeFormat(final NodeModel node, final String format) {
        final ModeController modeController = Controller.getCurrentModeController();
        final String oldFormat = NodeStyleModel.getNodeFormat((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setNodeFormat((NodeModel)node, (String)format);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setNodeFormat";
            }

            public void undo() {
                NodeStyleModel.setNodeFormat((NodeModel)node, (String)oldFormat);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setShape(NodeModel node, String shape) {
        this.setShape(node, shape == null ? null : NodeStyleModel.Shape.valueOf((String)shape));
    }

    public void setShape(NodeModel node, NodeStyleModel.Shape shape) {
        ShapeConfigurationModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withShape(shape));
    }

    public void setShapeHorizontalMargin(NodeModel node, Quantity<LengthUnits> margin) {
        ShapeConfigurationModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withHorizontalMargin(margin));
    }

    public void setShapeVerticalMargin(NodeModel node, Quantity<LengthUnits> margin) {
        ShapeConfigurationModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withVerticalMargin(margin));
    }

    public void setUniformShape(NodeModel node, boolean uniform) {
        ShapeConfigurationModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        this.setShapeConfiguration(node, oldShape.withUniform(uniform));
    }

    public void setShapeConfiguration(final NodeModel node, final ShapeConfigurationModel shape) {
        final ModeController modeController = Controller.getCurrentModeController();
        final ShapeConfigurationModel oldShape = NodeStyleModel.getShapeConfiguration((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setShapeConfiguration((NodeModel)node, (ShapeConfigurationModel)shape);
                modeController.getMapController().nodeChanged(node);
                this.childShapeRefresh(node);
            }

            public String getDescription() {
                return "setShape";
            }

            private void childShapeRefresh(NodeModel node2) {
                for (NodeModel child : modeController.getMapController().childrenUnfolded(node2)) {
                    NodeStyleModel.Shape childShape;
                    if (child.getViewers().isEmpty() || (childShape = NodeStyleModel.getShape((NodeModel)child)) != null && !NodeStyleModel.Shape.as_parent.equals((Object)childShape)) continue;
                    modeController.getMapController().nodeRefresh(child);
                    this.childShapeRefresh(child);
                }
            }

            public void undo() {
                NodeStyleModel.setShapeConfiguration((NodeModel)node, (ShapeConfigurationModel)oldShape);
                modeController.getMapController().nodeChanged(node);
                this.childShapeRefresh(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setMinNodeWidth(final NodeModel node, final Quantity<LengthUnits> minNodeWidth) {
        Quantity.assertNonNegativeOrNull(minNodeWidth);
        final NodeSizeModel sizeModel = this.createOwnSizeModel(node);
        final Quantity oldValue = NodeSizeModel.getMinNodeWidth((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                sizeModel.setMinNodeWidth(minNodeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setMinNodeWidth";
            }

            public void undo() {
                sizeModel.setMinNodeWidth(oldValue);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
        Quantity maxNodeWidth = this.getMaxWidth(node);
        if (maxNodeWidth != null && minNodeWidth != null && maxNodeWidth.toBaseUnits() < minNodeWidth.toBaseUnits()) {
            this.setMaxNodeWidth(node, minNodeWidth);
        }
    }

    public void setMaxNodeWidth(final NodeModel node, final Quantity<LengthUnits> maxNodeWidth) {
        Quantity.assertNonNegativeOrNull(maxNodeWidth);
        final NodeSizeModel sizeModel = this.createOwnSizeModel(node);
        final Quantity oldValue = NodeSizeModel.getMaxNodeWidth((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                sizeModel.setMaxNodeWidth(maxNodeWidth);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setMaxNodeWidth";
            }

            public void undo() {
                sizeModel.setMaxNodeWidth(oldValue);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
        Quantity minNodeWidth = this.getMinWidth(node);
        if (maxNodeWidth != null && minNodeWidth != null && maxNodeWidth.toBaseUnitsRounded() < minNodeWidth.toBaseUnitsRounded()) {
            this.setMinNodeWidth(node, maxNodeWidth);
        }
    }

    public void setTextAlign(final NodeModel node, final NodeStyleModel.TextAlign textAlign) {
        final NodeStyleModel.TextAlign oldTextAlign = NodeStyleModel.getTextAlign((NodeModel)node);
        IActor actor = new IActor(){

            public void act() {
                NodeStyleModel.setTextAlign((NodeModel)node, (NodeStyleModel.TextAlign)textAlign);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setMaxNodeWidth";
            }

            public void undo() {
                NodeStyleModel.setTextAlign((NodeModel)node, (NodeStyleModel.TextAlign)oldTextAlign);
                MapController mapController = MNodeStyleController.this.getModeController().getMapController();
                mapController.nodeChanged(node);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    private static class StyleCopier
    implements IExtensionCopier {
        private final ModeController modeController;

        public StyleCopier(ModeController modeController) {
            this.modeController = modeController;
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            NodeSizeModel fromSize;
            NodeStyleModel fromStyle = (NodeStyleModel)from.getExtension(NodeStyleModel.class);
            if (fromStyle != null) {
                fromStyle.copyTo(NodeStyleModel.createNodeStyleModel((NodeModel)to));
            }
            if ((fromSize = (NodeSizeModel)from.getExtension(NodeSizeModel.class)) != null) {
                fromSize.copyTo(NodeSizeModel.createNodeSizeModel((NodeModel)to));
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            from.removeExtension(NodeStyleModel.class);
            from.removeExtension(NodeSizeModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            this.removeStyleData(key, from, which);
            this.removeSizeData(key, from, which);
        }

        private void removeSizeData(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NodeSizeModel whichData = (NodeSizeModel)which.getExtension(NodeSizeModel.class);
            if (whichData == null) {
                return;
            }
            NodeSizeModel fromData = (NodeSizeModel)from.getExtension(NodeSizeModel.class);
            if (fromData == null) {
                return;
            }
            if (null != whichData.getMaxNodeWidth()) {
                fromData.setMaxNodeWidth(null);
            }
            if (null != whichData.getMinNodeWidth()) {
                fromData.setMinNodeWidth(null);
            }
        }

        private void removeStyleData(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NodeStyleModel whichStyle = (NodeStyleModel)which.getExtension(NodeStyleModel.class);
            if (whichStyle == null) {
                return;
            }
            NodeStyleModel fromStyle = (NodeStyleModel)from.getExtension(NodeStyleModel.class);
            if (fromStyle == null) {
                return;
            }
            if (null != whichStyle.isBold()) {
                fromStyle.setBold(null);
            }
            if (null != whichStyle.isItalic()) {
                fromStyle.setItalic(null);
            }
            if (null != whichStyle.getFontFamilyName()) {
                fromStyle.setFontFamilyName(null);
            }
            if (null != whichStyle.getFontSize()) {
                fromStyle.setFontSize(null);
            }
            if (null != whichStyle.getShape()) {
                fromStyle.setShapeConfiguration(ShapeConfigurationModel.NULL_SHAPE);
            }
            if (null != whichStyle.getColor()) {
                fromStyle.setColor(null);
            }
            if (null != whichStyle.getBackgroundColor()) {
                fromStyle.setBackgroundColor(null);
            }
            if (null != whichStyle.getNodeFormat()) {
                fromStyle.setNodeFormat(null);
            }
            if (null != whichStyle.getNodeNumbering()) {
                fromStyle.setNodeNumbering(null);
            }
            if (null != whichStyle.getTextAlign()) {
                fromStyle.setTextAlign(null);
            }
        }

        public void resolveParentExtensions(Object key, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.resolveShape(to);
        }

        private void resolveShape(NodeModel to) {
            if (this.hasOwnShape(to)) {
                return;
            }
            for (NodeModel source = to.getParentNode(); source != null; source = source.getParentNode()) {
                if (!this.hasOwnShape(source)) continue;
                NodeStyleModel.Shape shape = this.getShape(source);
                NodeStyleModel.createNodeStyleModel((NodeModel)to).setShape(shape);
                return;
            }
        }

        private boolean hasOwnShape(NodeModel to) {
            return !NodeStyleModel.Shape.as_parent.equals((Object)this.getShape(to));
        }

        private NodeStyleModel.Shape getShape(NodeModel node) {
            return ((NodeStyleController)this.modeController.getExtension(NodeStyleController.class)).getShape(node);
        }
    }
}

