/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.FixedBasicComboBoxEditor;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.ComboBoxRendererWithTooltip;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;

public class MUIFactory
implements INodeSelectionListener,
INodeChangeListener,
IMapChangeListener,
IMapSelectionListener,
IExtension {
    private boolean ignoreChangeEvent = false;
    private final DefaultComboBoxModel fonts;
    private final DefaultComboBoxModel size = new DefaultComboBoxModel<String>(FONT_SIZES);
    private final DefaultComboBoxModel styles = new DefaultComboBoxModel();
    public static final String[] FONT_SIZES = new String[]{"2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "30", "36", "48", "72"};

    public DefaultComboBoxModel getStyles() {
        return this.styles;
    }

    public MUIFactory() {
        final ModeController modeController = Controller.getCurrentModeController();
        final MNodeStyleController styleController = (MNodeStyleController)modeController.getExtension(NodeStyleController.class);
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] envFonts = gEnv.getAvailableFontFamilyNames();
        this.fonts = new DefaultComboBoxModel<String>(envFonts);
        ListDataListener fontsListener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -1) {
                    return;
                }
                if (MUIFactory.this.ignoreChangeEvent) {
                    return;
                }
                MUIFactory.this.ignoreChangeEvent = true;
                DefaultComboBoxModel source = (DefaultComboBoxModel)e.getSource();
                styleController.setFontFamily((String)source.getSelectedItem());
                MUIFactory.this.ignoreChangeEvent = false;
            }
        };
        this.fonts.addListDataListener(fontsListener);
        ListDataListener sizeListener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -1) {
                    return;
                }
                if (MUIFactory.this.ignoreChangeEvent) {
                    return;
                }
                try {
                    DefaultComboBoxModel source = (DefaultComboBoxModel)e.getSource();
                    int intSize = Integer.parseInt((String)source.getSelectedItem());
                    styleController.setFontSize(intSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.size.addListDataListener(sizeListener);
        ListDataListener styleListener = new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -1) {
                    return;
                }
                if (MUIFactory.this.ignoreChangeEvent) {
                    return;
                }
                DefaultComboBoxModel source = (DefaultComboBoxModel)e.getSource();
                IStyle style = (IStyle)source.getSelectedItem();
                MLogicalStyleController controller = (MLogicalStyleController)modeController.getExtension(LogicalStyleController.class);
                controller.setStyle(style);
            }
        };
        this.styles.addListDataListener(styleListener);
    }

    private void changeToolbar(NodeModel node) {
        Controller controller = Controller.getCurrentController();
        MNodeStyleController styleController = (MNodeStyleController)controller.getModeController().getExtension(NodeStyleController.class);
        this.selectFontSize(Integer.toString(styleController.getFontSize(node)));
        this.selectFontName(styleController.getFontFamilyName(node));
        LogicalStyleController logicalStyleController = LogicalStyleController.getController();
        this.ignoreChangeEvent = true;
        this.styles.setSelectedItem(logicalStyleController.getFirstStyle(node));
        this.ignoreChangeEvent = false;
    }

    public void nodeChanged(NodeChangeEvent event) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null && event.getNode() != selection.getSelected()) {
            return;
        }
        this.changeToolbar(event.getNode());
    }

    public void onDeselect(NodeModel node) {
    }

    public void onSelect(NodeModel node) {
        this.changeToolbar(node);
    }

    private void selectFontName(String fontName) {
        if (this.ignoreChangeEvent) {
            return;
        }
        this.ignoreChangeEvent = true;
        this.fonts.setSelectedItem(fontName);
        this.ignoreChangeEvent = false;
    }

    private void selectFontSize(String fontSize) {
        this.ignoreChangeEvent = true;
        this.size.setSelectedItem(fontSize);
        this.ignoreChangeEvent = false;
    }

    public Container createStyleBox() {
        JComboBoxWithBorder stylesBox = new JComboBoxWithBorder((ComboBoxModel)this.styles);
        stylesBox.setRenderer(new ComboBoxRendererWithTooltip((JComboBox)stylesBox));
        return stylesBox;
    }

    public Container createSizeBox() {
        JComboBoxWithBorder sizeBox = new JComboBoxWithBorder((ComboBoxModel)this.size);
        Dimension preferredSize = sizeBox.getPreferredSize();
        sizeBox.setPreferredSize(new Dimension(50, preferredSize.height));
        sizeBox.setEditor((ComboBoxEditor)new FixedBasicComboBoxEditor());
        sizeBox.setEditable(true);
        return sizeBox;
    }

    public Container createFontBox() {
        JComboBoxWithBorder fontsBox = new JComboBoxWithBorder((ComboBoxModel)this.fonts);
        fontsBox.setMaximumRowCount(9);
        fontsBox.setRenderer(new ComboBoxRendererWithTooltip((JComboBox)fontsBox));
        return fontsBox;
    }

    public void mapChanged(MapChangeEvent event) {
        Object property = event.getProperty();
        if (property.equals("MAP_STYLES")) {
            this.updateMapStyles(event.getMap());
            Controller controller = Controller.getCurrentController();
            this.changeToolbar(controller.getSelection().getSelected());
            return;
        }
    }

    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
    }

    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
    }

    public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
    }

    public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
    }

    public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
    }

    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        this.updateMapStyles(newMap);
    }

    private void updateMapStyles(MapModel newMap) {
        this.ignoreChangeEvent = true;
        this.styles.removeAllElements();
        if (newMap == null) {
            return;
        }
        Set styleObjects = MapStyleModel.getExtension((MapModel)newMap).getStyles();
        for (IStyle style : styleObjects) {
            this.styles.addElement(style);
        }
        this.ignoreChangeEvent = false;
    }

    public void beforeMapChange(MapModel oldMap, MapModel newMap) {
    }
}

