/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AMultipleNodeAction;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.TransformationException;
import org.freeplane.features.text.mindmapmode.MTextController;

public class SplitToWordsAction
extends AMultipleNodeAction {
    private final int nodeNumberInLine;
    private static String charactersAcceptedInWord;
    private static String numberRegularExpression;
    private static String wordRegularExpression;
    private static String wordOrNumberRegularExpression;
    private static Pattern compiledWordPattern;
    private Collection<String> auxiliaryWords = Collections.emptySet();
    private boolean leaveOriginalNodeEmpty;
    private boolean saveOriginalTextAsDetails;

    public SplitToWordsAction(int nodeNumberInLine) {
        super(SplitToWordsAction.createActionKey(nodeNumberInLine), SplitToWordsAction.createActionText(nodeNumberInLine), null);
        this.nodeNumberInLine = nodeNumberInLine;
    }

    public static String createActionText(int nodeNumberInLine) {
        String key = SplitToWordsAction.class.getSimpleName() + ".text";
        return TextUtils.format((String)key, (Object[])new Object[]{nodeNumberInLine});
    }

    public static String createActionKey(int nodeNumberInLine) {
        return SplitToWordsAction.class.getSimpleName() + "." + nodeNumberInLine;
    }

    public void actionPerformed(ActionEvent e) {
        this.compileWordPattern();
        String auxiliaryWordList = ResourceController.getResourceController().getProperty("SplitToWordsAction.auxiliaryWordList").toLowerCase();
        this.auxiliaryWords = Arrays.asList(auxiliaryWordList.split("\\s*,\\s*"));
        this.leaveOriginalNodeEmpty = ResourceController.getResourceController().getBooleanProperty("SplitToWordsAction.leaveOriginalNodeEmpty");
        this.saveOriginalTextAsDetails = ResourceController.getResourceController().getBooleanProperty("SplitToWordsAction.saveOriginalTextAsDetails");
        super.actionPerformed(e);
    }

    void compileWordPattern() {
        charactersAcceptedInWord = this.charactersAcceptedInWords();
        wordRegularExpression = "[\\p{L}\\d" + charactersAcceptedInWord + "]+";
        numberRegularExpression = "-?\\d+(?:[,.]\\d+)*";
        String newRegularExpression = numberRegularExpression + "|" + wordRegularExpression;
        if (!newRegularExpression.equals(wordOrNumberRegularExpression)) {
            wordOrNumberRegularExpression = newRegularExpression;
            compiledWordPattern = Pattern.compile(wordOrNumberRegularExpression);
        }
    }

    private String charactersAcceptedInWords() {
        String characters = ResourceController.getResourceController().getProperty("SplitToWordsAction.charactersAcceptedInWord");
        return PatternMaker.escape(characters);
    }

    protected void actionPerformed(ActionEvent e, NodeModel node) {
        boolean newNode;
        int nodeCountInLine;
        String details;
        ModeController modeController = Controller.getCurrentModeController();
        MTextController textController = (MTextController)modeController.getExtension(TextController.class);
        MMapController mapController = (MMapController)modeController.getMapController();
        try {
            details = textController.getTransformedObject(node).toString();
        }
        catch (TransformationException e1) {
            return;
        }
        String plainText = HtmlUtils.htmlToPlain((String)details).trim();
        if (this.leaveOriginalNodeEmpty) {
            nodeCountInLine = 0;
            newNode = true;
            textController.setNodeText(node, "");
        } else {
            nodeCountInLine = -1;
            newNode = false;
        }
        NodeModel currentNode = node;
        Matcher matcher = compiledWordPattern.matcher(plainText);
        while (matcher.find()) {
            String currentText;
            String word = matcher.group();
            if (newNode) {
                if (nodeCountInLine == this.nodeNumberInLine) {
                    nodeCountInLine = 0;
                    currentNode = node;
                }
                currentNode = mapController.addNewNode(currentNode, currentNode.getChildCount(), currentNode.isLeft());
                ++nodeCountInLine;
                currentText = "";
            } else if (nodeCountInLine == -1) {
                nodeCountInLine = 0;
                currentNode = node;
                currentText = "";
            } else {
                currentText = currentNode.getText() + ' ';
            }
            boolean auxiliaryWord = this.auxiliaryWords.contains(word.toLowerCase());
            if (!auxiliaryWord) {
                textController.setNodeText(currentNode, currentText + this.capitalize(word));
                newNode = true;
                continue;
            }
            textController.setNodeText(currentNode, currentText + word);
            newNode = false;
        }
        if (this.saveOriginalTextAsDetails) {
            textController.setDetails(currentNode, HtmlUtils.isHtmlNode((String)details) ? details : HtmlUtils.plainToHTML((String)details));
            textController.setIsMinimized(currentNode, true);
        }
    }

    private String capitalize(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    static {
        ResourceController.getResourceController().setDefaultProperty("SplitToWordsAction.auxiliaryWordList", TextUtils.getText((String)"defaultAuxiliaryWordList"));
    }

    static class PatternMaker {
        static final Pattern ESCAPED_CHARACTERS = Pattern.compile("[\\[\\]\\-\\&\\\\\\^]");
        static final Pattern WHITE_SPACE = Pattern.compile("\\s+");

        PatternMaker() {
        }

        static String escape(String characters) {
            String withoutWhiteSpace = WHITE_SPACE.matcher(characters).replaceAll("");
            return ESCAPED_CHARACTERS.matcher(withoutWhiteSpace).replaceAll("\\\\$0");
        }
    }
}

