/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.mindmapmode.DocuMapAttribute;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.application.OpenLastOpenedAction;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class LastOpenedList
implements IMapViewChangeListener,
IMapChangeListener {
    private static final String LAST_OPENED_LIST_LENGTH = "last_opened_list_length";
    private static final String LAST_OPENED = "lastOpened_1.0.20";
    private static final String LAST_LOCATIONS = "lastLocations";
    private static boolean PORTABLE_APP = System.getProperty("portableapp", "false").equals("true");
    private static String USER_DRIVE = System.getProperty("user.home", "").substring(0, 2);
    private final List<RecentFile> lastOpenedList = new LinkedList<RecentFile>();
    private RecentFile mapSelectedOnStart;

    LastOpenedList() {
        this.restore();
    }

    public void registerMenuContributor(final ModeController modeController) {
        modeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "lastOpenedMaps", new EntryVisitor(){

            public void visit(Entry target) {
                LastOpenedList.this.updateMenus(modeController, target);
            }

            public boolean shouldSkipChildren(Entry entry) {
                return true;
            }
        }, (EntryVisitor)new ChildActionEntryRemover((FreeplaneActions)modeController));
    }

    public void afterViewChange(Component oldView, Component newView) {
        if (newView == null) {
            this.updateMenus();
            return;
        }
        MapModel map = this.getMapModel(newView);
        String restoreString = this.getRestoreable(map);
        this.updateList(map, restoreString);
    }

    public void afterViewClose(Component oldView) {
        this.updateLastVisitedNodeId(oldView);
    }

    private boolean selectLastVisitedNode(RecentFile recentFile) {
        MapModel map;
        NodeModel node;
        if (recentFile != null && recentFile.lastVisitedNodeId != null && (node = (map = Controller.getCurrentController().getMap()).getNodeForID(recentFile.lastVisitedNodeId)) != null && node.hasVisibleContent()) {
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (selection.isSelected(map.getRootNode())) {
                selection.selectAsTheOnlyOneSelected(node);
            }
            return true;
        }
        return false;
    }

    private boolean saveLastPositionInMapEnabled() {
        return ResourceController.getResourceController().getBooleanProperty("save_last_position_in_map");
    }

    public void afterViewCreated(Component mapView) {
        MapModel map = this.getMapModel(mapView);
        RecentFile recentFile = this.findRecentFileByMapModel(map);
        if (this.saveLastPositionInMapEnabled() && !this.selectLastVisitedNode(recentFile)) {
            this.ensureSelectLastVisitedNodeOnOpen(map, recentFile);
        }
    }

    private void ensureSelectLastVisitedNodeOnOpen(final MapModel map, final RecentFile recentFile) {
        final MapController mapController = Controller.getCurrentModeController().getMapController();
        if (recentFile != null && recentFile.lastVisitedNodeId != null) {
            mapController.addNodeSelectionListener(new INodeSelectionListener(){

                public void onSelect(NodeModel node) {
                    if (node.getMap() == map) {
                        mapController.removeNodeSelectionListener((INodeSelectionListener)this);
                        NodeModel toSelect = map.getNodeForID(recentFile.lastVisitedNodeId);
                        if (toSelect != null && node.isRoot()) {
                            Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(toSelect);
                        }
                    }
                }

                public void onDeselect(NodeModel node) {
                }
            });
        }
    }

    private MapModel getMapModel(Component mapView) {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        return mapViewManager.getModel(mapView);
    }

    public void beforeViewChange(Component oldView, Component newView) {
    }

    private int getMaxMenuEntries() {
        return ResourceController.getResourceController().getIntProperty(LAST_OPENED_LIST_LENGTH, 25);
    }

    private String getRestorable(final File file) {
        if (file == null || !AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        }).booleanValue()) {
            return null;
        }
        String absolutePath = file.getAbsolutePath();
        if (!PORTABLE_APP || !USER_DRIVE.endsWith(":")) {
            return "MindMap:" + absolutePath;
        }
        String diskName = absolutePath.substring(0, 2);
        if (!diskName.equals(USER_DRIVE)) {
            return "MindMap:" + absolutePath;
        }
        return "MindMap::" + absolutePath.substring(2);
    }

    public String getRestoreable(MapModel map) {
        if (map == null) {
            return null;
        }
        if (map.containsExtension(DocuMapAttribute.class)) {
            return null;
        }
        ModeController modeController = Controller.getCurrentModeController();
        if (!modeController.getModeName().equals("MindMap")) {
            return null;
        }
        File file = map.getFile();
        return this.getRestorable(file);
    }

    public void mapChanged(MapChangeEvent event) {
        String fileAfter;
        if (!event.getProperty().equals("map_url")) {
            return;
        }
        URL after = (URL)event.getNewValue();
        if (after != null && (fileAfter = after.getFile()) != null) {
            String restorable = this.getRestorable(new File(fileAfter));
            this.updateList(event.getMap(), restorable);
        }
    }

    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
    }

    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
    }

    public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
    }

    public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
    }

    public void open(RecentFile recentFile) throws FileNotFoundException, MalformedURLException, IOException, URISyntaxException, XMLException {
        if (recentFile == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(recentFile.restorable, ":");
        if (!tokens.hasMoreTokens()) {
            return;
        }
        boolean changedToMapView = this.tryToChangeToMapView(recentFile);
        if (changedToMapView) {
            return;
        }
        String mode = tokens.nextToken();
        Controller.getCurrentController().selectMode(mode);
        File file = this.createFileFromRestorable(tokens);
        if (!changedToMapView) {
            Controller.getCurrentModeController().getMapController().newMap(Compat.fileToUrl((File)file));
        } else {
            MapModel map = Controller.getCurrentController().getMap();
            Controller.getCurrentModeController().getMapController().newMapView(map);
        }
    }

    public File createFileFromRestorable(StringTokenizer tokens) {
        String fileName = tokens.nextToken(";").substring(1);
        if (PORTABLE_APP && fileName.startsWith(":") && USER_DRIVE.endsWith(":")) {
            fileName = USER_DRIVE + fileName.substring(1);
        }
        File file = new File(fileName);
        return file;
    }

    void openLastMapOnStart() {
        if (this.mapSelectedOnStart != null && !this.tryToChangeToMapView(this.mapSelectedOnStart)) {
            this.safeOpen(this.mapSelectedOnStart);
        }
    }

    private void restore() {
        List<String> lastOpened = this.getListPropertyNotNull(LAST_OPENED);
        List<String> lastLocation = this.getListPropertyNotNull(LAST_LOCATIONS);
        for (int i = 0; i < lastOpened.size(); ++i) {
            RecentFile recentFile = new RecentFile(lastOpened.get(i));
            if (lastLocation.size() == lastOpened.size()) {
                recentFile.lastVisitedNodeId = lastLocation.get(i);
            }
            this.lastOpenedList.add(recentFile);
        }
        if (!this.lastOpenedList.isEmpty()) {
            this.mapSelectedOnStart = this.lastOpenedList.get(0);
        }
    }

    private List<String> getListPropertyNotNull(String key) {
        String lastOpened = ResourceController.getResourceController().getProperty(key, "");
        return ConfigurationUtils.decodeListValue((String)lastOpened, (boolean)true);
    }

    public void safeOpen(RecentFile recentFile) {
        block2: {
            try {
                this.open(recentFile);
            }
            catch (Exception ex) {
                LogUtils.warn((Throwable)ex);
                String message = TextUtils.format((String)"remove_file_from_list_on_error", (Object[])new Object[]{recentFile.restorable});
                UITools.showFrame();
                Component frame = UITools.getMenuComponent();
                int remove = JOptionPane.showConfirmDialog(frame, message, "Freeplane", 0);
                if (remove != 0) break block2;
                this.lastOpenedList.remove(recentFile);
                this.updateMenus();
            }
        }
    }

    public void saveProperties() {
        this.updateLastVisitedNodeIds();
        ResourceController.getResourceController().setProperty(LAST_OPENED, ConfigurationUtils.encodeListValue(this.getRestoreables(), (boolean)true));
        ResourceController.getResourceController().setProperty(LAST_LOCATIONS, ConfigurationUtils.encodeListValue(this.getLastVisitedNodeIds(), (boolean)true));
    }

    private void updateLastVisitedNodeIds() {
        List mapViews = Controller.getCurrentController().getMapViewManager().getMapViewVector();
        for (Component component : mapViews) {
            this.updateLastVisitedNodeId(component);
        }
    }

    private void updateLastVisitedNodeId(Component mapView) {
        NodeModel selectedNode;
        if (!(mapView instanceof MapView)) {
            return;
        }
        NodeView selected = ((MapView)mapView).getSelected();
        RecentFile recentFile = this.findRecentFileByMapModel(this.getMapModel(mapView));
        if (selected != null && recentFile != null && !(selectedNode = selected.getModel()).isRoot()) {
            recentFile.lastVisitedNodeId = selectedNode.getID();
        }
    }

    private RecentFile findRecentFileByRestorable(String restorable) {
        for (RecentFile recentFile : this.lastOpenedList) {
            if (!recentFile.restorable.equals(restorable)) continue;
            return recentFile;
        }
        return null;
    }

    private RecentFile findRecentFileByMapModel(MapModel map) {
        return this.findRecentFileByRestorable(this.getRestoreable(map));
    }

    private List<String> getRestoreables() {
        ArrayList<String> result = new ArrayList<String>(this.lastOpenedList.size());
        for (RecentFile recentFile : this.lastOpenedList) {
            result.add(recentFile.restorable);
        }
        return result;
    }

    private List<String> getLastVisitedNodeIds() {
        ArrayList<String> result = new ArrayList<String>(this.lastOpenedList.size());
        for (RecentFile recentFile : this.lastOpenedList) {
            result.add(recentFile.lastVisitedNodeId);
        }
        return result;
    }

    private boolean tryToChangeToMapView(RecentFile mapSelectedOnStart) {
        return Controller.getCurrentController().getMapViewManager().tryToChangeToMapView(mapSelectedOnStart.mapName);
    }

    private void updateList(MapModel map, String restoreString) {
        if (map.containsExtension(DocuMapAttribute.class)) {
            return;
        }
        if (restoreString != null) {
            RecentFile recentFile = this.findRecentFileByRestorable(restoreString);
            if (recentFile != null) {
                this.lastOpenedList.remove(recentFile);
                recentFile.mapName = map.getTitle();
                this.lastOpenedList.add(0, recentFile);
            } else {
                this.lastOpenedList.add(0, new RecentFile(restoreString, map.getTitle()));
            }
        }
        this.updateMenus();
    }

    private void updateMenus() {
        IUserInputListenerFactory userInputListenerFactory = Controller.getCurrentModeController().getUserInputListenerFactory();
        userInputListenerFactory.rebuildMenus("lastOpenedMaps");
    }

    private void updateMenus(ModeController modeController, Entry target) {
        List<AFreeplaneAction> openMapActions = this.createOpenLastMapActionList();
        for (AFreeplaneAction openMapAction : openMapActions) {
            modeController.addActionIfNotAlreadySet(openMapAction);
            new EntryAccessor().addChildAction(target, openMapAction);
        }
    }

    public List<AFreeplaneAction> createOpenLastMapActionList() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        int i = 0;
        int maxEntries = this.getMaxMenuEntries();
        ArrayList<AFreeplaneAction> openMapActions = new ArrayList<AFreeplaneAction>(maxEntries);
        for (RecentFile recentFile : this.lastOpenedList) {
            if (!(i != 0 || modeController.getModeName().equals("MindMap") && controller.getMap() != null && controller.getMap().getURL() != null)) {
                ++i;
                ++maxEntries;
            }
            if (i == maxEntries) break;
            OpenLastOpenedAction openMapAction = new OpenLastOpenedAction(i++, this, recentFile);
            this.createOpenMapItemName(openMapAction, recentFile.restorable);
            openMapActions.add(openMapAction);
        }
        return openMapActions;
    }

    private void createOpenMapItemName(AFreeplaneAction openMapAction, String restorable) {
        int separatorIndex = restorable.indexOf(58);
        if (separatorIndex == -1) {
            openMapAction.putValue("Name", (Object)restorable);
        }
        String key = restorable.substring(0, separatorIndex);
        String fileName = restorable.substring(separatorIndex);
        String keyName = TextUtils.getText((String)("open_as" + key), (String)key);
        openMapAction.putValue("ShortDescription", (Object)keyName);
        openMapAction.putValue("Default", (Object)fileName);
        fileName = fileName.startsWith("::") ? fileName.substring(2) : fileName.substring(1);
        openMapAction.putValue("Name", (Object)(keyName + " " + fileName));
    }

    public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
    }

    static class RecentFile {
        String restorable;
        String mapName;
        String lastVisitedNodeId;

        public RecentFile(String restorable, String mapName) {
            this.restorable = restorable;
            this.mapName = mapName;
        }

        public RecentFile(String restorable) {
            this(restorable, null);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.restorable == null ? 0 : this.restorable.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RecentFile other = (RecentFile)obj;
            return !(this.restorable == null ? other.restorable != null : !this.restorable.equals(other.restorable));
        }

        public String toString() {
            return "RecentFileL(" + this.restorable + "@" + this.lastVisitedNodeId + ")";
        }
    }
}

