/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.main.application.CommandLineParser;
import org.freeplane.main.application.FreeplaneStarter;

public class SingleInstanceManager {
    private File lockFile = new File(Compat.getApplicationUserDirectory(), "single_instance.lock");
    private boolean isSingleInstanceMode;
    private boolean isSingleInstanceForceMode;
    private Integer port;
    private boolean isSlave;
    private boolean isMasterPresent;
    private final FreeplaneStarter starter;

    public SingleInstanceManager(FreeplaneStarter starter) {
        this.starter = starter;
        ResourceController resourceController = starter.getResourceController();
        this.isSingleInstanceMode = resourceController.getBooleanProperty("single_instance");
        this.isSingleInstanceForceMode = resourceController.getBooleanProperty("single_instance_force");
    }

    public void start(String[] args) {
        CommandLineParser.Options options = CommandLineParser.parse(args, false);
        String[] filesToLoad = options.getFilesToOpenAsArray();
        if (this.isSingleInstanceMode && !options.hasMenuItemsToExecute()) {
            this.initLockFile();
            if (filesToLoad.length == 0 && !this.isSingleInstanceForceMode && this.checkIsMasterPresent()) {
                this.isMasterPresent = true;
                this.startStandAlone(filesToLoad);
            } else if (!this.startAsSlave(filesToLoad) && !this.startAsMaster(filesToLoad)) {
                this.startStandAlone(filesToLoad);
            }
        } else {
            this.startStandAlone(filesToLoad);
        }
    }

    private boolean checkIsMasterPresent() {
        if (this.port == null) {
            return false;
        }
        try {
            Socket clientSocket = new Socket("localhost", (int)this.port);
            clientSocket.close();
            LogUtils.info((String)"master is present.");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public boolean isMasterPresent() {
        return this.isSlave || this.isMasterPresent;
    }

    private boolean startAsSlave(String[] filesToLoad) {
        if (this.port != null) {
            this.isSlave = this.openFilesInMaster(filesToLoad);
            return this.isSlave;
        }
        return false;
    }

    private boolean openFilesInMaster(String[] filesToLoad) {
        if (this.port == null) {
            throw new IllegalArgumentException("port may not be null");
        }
        try {
            Socket clientSocket = new Socket("localhost", (int)this.port);
            OutputStream out = clientSocket.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(filesToLoad);
            oos.close();
            clientSocket.close();
            LogUtils.info((String)"Successfully notified first instance.");
            return true;
        }
        catch (UnknownHostException e) {
            LogUtils.severe((String)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LogUtils.warn((String)"Error connecting to existing instance (stale lockfiles may cause this).", (Throwable)e);
            return false;
        }
    }

    private boolean startAsMaster(String[] filesToLoad) {
        try {
            final ServerSocket socket = new ServerSocket(0, 10);
            this.port = socket.getLocalPort();
            LogUtils.info((String)("Listening for application instances on socket " + this.port));
            this.createLockFile();
            Thread filesToOpenListenerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean socketClosed = false;
                    while (!socketClosed) {
                        if (socket.isClosed()) {
                            socketClosed = true;
                            continue;
                        }
                        try {
                            Socket client = socket.accept();
                            ObjectInputStream in = new ObjectInputStream(client.getInputStream());
                            Object[] filesToLoadForClient = (String[])in.readObject();
                            LogUtils.info((String)("opening '" + StringUtils.join((Object[])filesToLoadForClient, (String)"', '") + "' for client"));
                            in.close();
                            client.close();
                            SingleInstanceManager.this.starter.loadMapsLater((String[])filesToLoadForClient);
                        }
                        catch (SecurityException e) {
                            LogUtils.warn((String)"master is currently not accepting new files. Try again later", (Throwable)e);
                        }
                        catch (IOException e) {
                            socketClosed = true;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("implementation error", e);
                        }
                    }
                }
            });
            filesToOpenListenerThread.start();
            return true;
        }
        catch (UnknownHostException e) {
            LogUtils.severe((String)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LogUtils.severe((String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void createLockFile() throws IOException {
        RandomAccessFile randomAccessLockFile = new RandomAccessFile(this.lockFile, "rwd");
        randomAccessLockFile.writeBytes(this.port.toString());
        randomAccessLockFile.close();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    SingleInstanceManager.this.lockFile.delete();
                }
                catch (Exception e) {
                    SingleInstanceManager.this.error("Unable to remove lock file: " + SingleInstanceManager.this.lockFile, e);
                }
            }
        });
    }

    private void startStandAlone(String[] filesToLoad) {
    }

    private boolean initLockFile() {
        try {
            if (this.lockFile.exists()) {
                RandomAccessFile randomAccessLockFile = new RandomAccessFile(this.lockFile, "r");
                String portAsString = randomAccessLockFile.readLine().trim();
                randomAccessLockFile.close();
                this.port = Integer.parseInt(portAsString);
            }
        }
        catch (Exception e) {
            this.error("Unable to create and/or lock file: " + this.lockFile, e);
        }
        return false;
    }

    private void error(String message, Exception e) {
        LogUtils.severe((String)message, (Throwable)e);
    }
}

