/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderExtension;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderHook;

class TimerBlinkTask
extends TimerTask {
    private final ReminderHook reminderController;
    private final ReminderExtension reminderExtension;
    private boolean stateAdded = false;
    private boolean runScript;
    private boolean alreadyExecuted;

    public TimerBlinkTask(ReminderHook reminderController, ReminderExtension reminderExtension, boolean stateAdded, boolean runScript) {
        this.reminderController = reminderController;
        this.reminderExtension = reminderExtension;
        this.stateAdded = stateAdded;
        this.runScript = runScript;
        this.alreadyExecuted = false;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TimerBlinkTask.this.runScript) {
                    TimerBlinkTask.this.runScript = false;
                    TimerBlinkTask.this.reminderController.runScript(TimerBlinkTask.this.reminderExtension);
                }
                if (!TimerBlinkTask.this.alreadyExecuted) {
                    if (ResourceController.getResourceController().getBooleanProperty("remindersShowNotifications")) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TimerBlinkTask.this.reminderController.showNotificationPopup(TimerBlinkTask.this.reminderExtension);
                            }
                        });
                    }
                    TimerBlinkTask.this.alreadyExecuted = true;
                }
                TimerBlinkTask.this.stateAdded = !TimerBlinkTask.this.stateAdded;
                TimerBlinkTask.this.reminderController.blink(TimerBlinkTask.this.reminderExtension, TimerBlinkTask.this.stateAdded);
            }
        });
    }

    public boolean alreadyExecuted() {
        return this.alreadyExecuted;
    }
}

