/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.mindmapmode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EditNodeWYSIWYG;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.mindmapmode.EditNodeExternalApplication;
import org.freeplane.view.swing.map.mindmapmode.EditNodeTextField;

public class MMapViewController
extends MapViewController
implements IEditBaseCreator {
    @Override
    public EditNodeBase createEditor(NodeModel node, EditNodeBase.IEditControl editControl, String text, boolean editLong) {
        boolean editExternal;
        String htmlEditingOption = ResourceController.getResourceController().getProperty("html_editing_option");
        boolean editInternalWysiwyg = editLong && StringUtils.equals((String)htmlEditingOption, (String)"internal-wysiwyg");
        boolean bl = editExternal = editLong && StringUtils.equals((String)htmlEditingOption, (String)"external");
        if (!HtmlUtils.isHtmlNode((String)text)) {
            text = HtmlUtils.plainToHTML((String)text);
        }
        if (editInternalWysiwyg) {
            MapView map;
            EditNodeWYSIWYG editNodeWYSIWYG = new EditNodeWYSIWYG(node, text, editControl, true);
            ViewController viewController = Controller.getCurrentModeController().getController().getViewController();
            if (EditNodeBase.EditedComponent.TEXT.equals((Object)editControl.getEditType())) {
                int preferredHeight = (int)((double)this.getComponent(node).getHeight() * 1.2);
                preferredHeight = Math.max(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_height")));
                preferredHeight = Math.min(preferredHeight, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_height")));
                int preferredWidth = (int)((double)this.getComponent(node).getWidth() * 1.2);
                preferredWidth = Math.max(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__min_default_window_width")));
                preferredWidth = Math.min(preferredWidth, Integer.parseInt(ResourceController.getResourceController().getProperty("el__max_default_window_width")));
                Dimension preferredSize = new Dimension(preferredWidth, preferredHeight);
                editNodeWYSIWYG.setPreferredSize(preferredSize);
            }
            MainView mainView = (MainView)this.getComponent(node);
            NodeView nodeView = mainView.getNodeView();
            if (EditNodeBase.EditedComponent.TEXT.equals((Object)editControl.getEditType())) {
                Font font = this.getFont(node);
                editNodeWYSIWYG.setTitle("edit_long_node");
                editNodeWYSIWYG.setFont(font);
                Color nodeTextColor = this.getTextColor(node);
                editNodeWYSIWYG.setTextColor(nodeTextColor);
                editNodeWYSIWYG.setBackground(nodeView.getTextBackground());
                editNodeWYSIWYG.setTextAlignment(mainView.getHorizontalAlignment());
            } else if (EditNodeBase.EditedComponent.DETAIL.equals((Object)editControl.getEditType())) {
                map = nodeView.getMap();
                editNodeWYSIWYG.setTitle("edit_details");
                editNodeWYSIWYG.setFont(map.getDetailFont());
                editNodeWYSIWYG.setTextColor(map.getDetailForeground());
                editNodeWYSIWYG.setBackground(map.getDetailBackground());
                editNodeWYSIWYG.setTextAlignment(map.getDetailHorizontalAlignment());
            } else if (EditNodeBase.EditedComponent.NOTE.equals((Object)editControl.getEditType())) {
                map = nodeView.getMap();
                editNodeWYSIWYG.setTitle("edit_note");
                editNodeWYSIWYG.setFont(map.getNoteFont());
                editNodeWYSIWYG.setTextColor(map.getNoteForeground());
                editNodeWYSIWYG.setBackground(map.getNoteBackground());
                editNodeWYSIWYG.setTextAlignment(map.getNoteHorizontalAlignment());
            }
            return editNodeWYSIWYG;
        }
        if (editExternal) {
            return new EditNodeExternalApplication(node, text, editControl);
        }
        EditNodeBase textfield = this.createEditor(node, editControl.getEditType(), text, editControl);
        if (textfield != null) {
            return textfield;
        }
        return this.createEditor(node, editControl, text, true);
    }

    private EditNodeBase createEditor(NodeModel node, EditNodeBase.EditedComponent parent, String text, EditNodeBase.IEditControl editControl) {
        JComponent component;
        MainView mainView = (MainView)this.getComponent(node);
        NodeView nodeView = mainView.getNodeView();
        Object parentComponent = EditNodeBase.EditedComponent.TEXT.equals((Object)parent) ? mainView : (EditNodeBase.EditedComponent.DETAIL.equals((Object)parent) ? ((component = nodeView.getContent(2)) instanceof ZoomableLabel ? (ZoomableLabel)component : null) : null);
        if (parentComponent == null || !parentComponent.isVisible()) {
            return null;
        }
        EditNodeTextField textField = new EditNodeTextField(node, (ZoomableLabel)parentComponent, text, editControl);
        if (EditNodeBase.EditedComponent.TEXT.equals((Object)parent)) {
            textField.setBackground(nodeView.getTextBackground());
        } else if (EditNodeBase.EditedComponent.DETAIL.equals((Object)parent)) {
            textField.setBackground(nodeView.getMap().getDetailBackground());
        }
        return textField;
    }

    public MMapViewController(Controller controller) {
        super(controller);
        new EditNodeTextField(null, null, null, null);
    }
}

