/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.mindmapmode.INodeSelector;

class GlassPaneNodeSelector
extends MouseAdapter
implements IMouseListener {
    private final INodeSelector nodeSelector;
    private Component activeComponent;

    GlassPaneNodeSelector(INodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Component component = this.findMapComponent(e);
        if (this.canRedispatchEventFor(component)) {
            this.redispatchMouseEvent(e, component);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Component component = this.findMapComponent(e);
        if (!(component instanceof MainView)) {
            return;
        }
        MainView mainView = (MainView)component;
        NodeView nodeView = mainView.getNodeView();
        NodeModel model = nodeView.getModel();
        switch (e.getClickCount()) {
            case 1: {
                MapController mapController = Controller.getCurrentModeController().getMapController();
                mapController.setFolded(model, !nodeView.isFolded());
                break;
            }
            case 2: {
                this.nodeSelector.nodeSelected(model);
            }
        }
    }

    public boolean canRedispatchEventFor(Component component) {
        if (component instanceof MapView) {
            return true;
        }
        return component instanceof JScrollBar || SwingUtilities.getAncestorOfClass(JScrollBar.class, component) != null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        Component component = this.findMapComponent(e);
        if (this.canRedispatchEventFor(component)) {
            this.redispatchMouseEvent(e, component);
            this.activeComponent = component;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        if (this.activeComponent != null) {
            this.redispatchMouseEvent(e, this.activeComponent);
            this.activeComponent = null;
        }
    }

    private Component findMapComponent(MouseEvent e) {
        Component glassPane = e.getComponent();
        Point glassPanePoint = e.getPoint();
        Container container = SwingUtilities.getRootPane(glassPane).getContentPane();
        Point containerPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, container);
        Component component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
        if (component instanceof MainView || component instanceof MapView || component instanceof JScrollBar) {
            return component;
        }
        return SwingUtilities.getAncestorOfClass(MapView.class, component);
    }

    public void redispatchMouseEvent(MouseEvent e, Component component) {
        Component glassPane = e.getComponent();
        Point glassPanePoint = e.getPoint();
        Point componentPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, component);
        component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
    }
}

