/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.InflaterInputStream;

class DictionaryFactory {
    private final Node root = new Node();
    private int size;
    private char[] tree;

    public void add(String word) {
        Node node = this.root;
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            NodeEntry entry = node.searchCharOrAdd(c);
            if (i == word.length() - 1) {
                entry.isWord = true;
                return;
            }
            Node nextNode = entry.nextNode;
            node = nextNode == null ? entry.createNewNode() : nextNode;
        }
    }

    final void checkSize(int newSize) {
        if (newSize > this.tree.length) {
            char[] puffer = new char[Math.max(newSize, 2 * this.tree.length)];
            System.arraycopy(this.tree, 0, puffer, 0, this.size);
            this.tree = puffer;
        }
    }

    public Dictionary create() {
        this.tree = new char[10000];
        this.root.save(this);
        char[] temp = new char[this.size];
        System.arraycopy(this.tree, 0, temp, 0, this.size);
        this.tree = temp;
        return new Dictionary(this.tree);
    }

    public void loadPlainWordList(InputStream stream, String charsetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream, charsetName);
        this.loadPlainWordList(reader);
    }

    public void loadPlainWordList(Reader reader) throws IOException {
        BufferedReader input = new BufferedReader(reader);
        String word = input.readLine();
        while (word != null) {
            if (word.length() > 1) {
                this.add(word);
            }
            word = input.readLine();
        }
    }

    public void loadWordList(URL filename) throws IOException {
        URLConnection conn = filename.openConnection();
        conn.setReadTimeout(5000);
        InputStream input = conn.getInputStream();
        input = new InflaterInputStream(input);
        input = new BufferedInputStream(input);
        this.loadPlainWordList(input, "UTF8");
    }

    private static final class NodeEntry {
        final char c;
        boolean isWord;
        Node nextNode;

        NodeEntry(char c) {
            this.c = c;
        }

        Node createNewNode() {
            this.nextNode = new Node();
            return this.nextNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node
    extends ArrayList<NodeEntry> {
        private static final long serialVersionUID = 1L;

        Node() {
            super(1);
        }

        int save(DictionaryFactory factory) {
            int idx;
            int start = idx = factory.size;
            int newSize = factory.size + this.size() * 3 + 1;
            factory.checkSize(newSize);
            factory.size = newSize;
            for (int i = 0; i < this.size(); ++i) {
                NodeEntry entry = (NodeEntry)this.get(i);
                ((DictionaryFactory)factory).tree[idx++] = entry.c;
                Node nextNode = entry.nextNode;
                int offset = 0;
                if (nextNode != null) {
                    offset = nextNode.save(factory);
                }
                if (entry.isWord) {
                    offset |= Integer.MIN_VALUE;
                }
                ((DictionaryFactory)factory).tree[idx++] = (char)(offset >> 16);
                ((DictionaryFactory)factory).tree[idx++] = (char)offset;
            }
            ((DictionaryFactory)factory).tree[idx] = 65535;
            return start;
        }

        NodeEntry searchCharOrAdd(char c) {
            for (int i = 0; i < this.size(); ++i) {
                NodeEntry entry = (NodeEntry)this.get(i);
                if (entry.c < c) continue;
                if (entry.c == c) {
                    return entry;
                }
                entry = new NodeEntry(c);
                this.add(i, entry);
                this.trimToSize();
                return entry;
            }
            NodeEntry entry = new NodeEntry(c);
            this.add(entry);
            this.trimToSize();
            return entry;
        }
    }
}

