/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleReferenceImpl;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.knopflerfish.framework.BundleWiringImpl;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleRevisionImpl
extends BundleReferenceImpl
implements BundleRevision {
    static final int NS_BUNDLE = 1;
    static final int NS_HOST = 2;
    static final int NS_IDENTITY = 4;
    static final int NS_PACKAGE = 8;
    static final int NS_OTHER = 16;
    final BundleGeneration gen;
    private BundleWiring bundleWiring = null;

    BundleRevisionImpl(BundleGeneration gen) {
        super(gen.bundle);
        this.gen = gen;
    }

    @Override
    public String getSymbolicName() {
        return this.gen.symbolicName;
    }

    @Override
    public Version getVersion() {
        return this.gen.version;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        BundleCapability bc;
        ArrayList<BundleCapability> res = new ArrayList<BundleCapability>();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        if ((ns & 1) != 0 && (bc = this.gen.getBundleCapability()) != null) {
            res.add(bc);
        }
        if ((ns & 2) != 0 && (bc = this.gen.getHostCapability()) != null) {
            res.add(bc);
        }
        if ((ns & 4) != 0 && (bc = this.gen.getIdentityCapability()) != null) {
            res.add(bc);
        }
        if ((ns & 8) != 0) {
            res.addAll(this.gen.bpkgs.getDeclaredPackageCapabilities());
        }
        if ((ns & 0x10) != 0) {
            Map<String, List<BundleCapabilityImpl>> caps = this.gen.getDeclaredCapabilities();
            if (null != namespace) {
                List<BundleCapabilityImpl> lcap = caps.get(namespace);
                if (lcap != null) {
                    res.addAll(lcap);
                }
            } else {
                for (List<BundleCapabilityImpl> lcap : caps.values()) {
                    res.addAll(lcap);
                }
            }
        }
        return res;
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        ArrayList<BundleRequirement> res = new ArrayList<BundleRequirement>();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        if ((ns & 1) != 0) {
            res.addAll(this.gen.bpkgs.getDeclaredBundleRequirements());
        }
        if ((ns & 2) != 0 && this.gen.isFragment()) {
            res.add(this.gen.fragment);
        }
        if ((ns & 8) != 0) {
            res.addAll(this.gen.bpkgs.getDeclaredPackageRequirements());
        }
        if ((ns & 0x14) != 0) {
            Map<String, List<BundleRequirementImpl>> reqs = this.gen.getDeclaredRequirements();
            if (null != namespace) {
                List<BundleRequirementImpl> lbr = reqs.get(namespace);
                if (lbr != null) {
                    res.addAll(lbr);
                }
            } else {
                for (List<BundleRequirementImpl> lbr : reqs.values()) {
                    res.addAll(lbr);
                }
            }
        }
        return res;
    }

    @Override
    public List<Capability> getCapabilities(String namespace) {
        return this.getDeclaredCapabilities(namespace);
    }

    @Override
    public List<Requirement> getRequirements(String namespace) {
        return this.getDeclaredRequirements(namespace);
    }

    @Override
    public int getTypes() {
        return this.gen.isFragment() ? 1 : 0;
    }

    @Override
    public BundleWiring getWiring() {
        return this.bundleWiring;
    }

    public String toString() {
        return ((Object)new StringBuffer().append("BundleRevision[").append(this.getSymbolicName()).append(":").append(this.getVersion()).append("]")).toString();
    }

    BundleGeneration getBundleGeneration() {
        return this.gen;
    }

    void setWired() {
        this.bundleWiring = new BundleWiringImpl(this);
    }

    void clearWiring() {
        this.bundleWiring = null;
    }

    static int whichNameSpaces(String namespace) {
        int ns = namespace == null ? 31 : ("osgi.wiring.bundle".equals(namespace) ? 1 : ("osgi.wiring.host".equals(namespace) ? 2 : ("osgi.identity".equals(namespace) ? 4 : ("osgi.wiring.package".equals(namespace) ? 8 : 16))));
        return ns;
    }
}

