/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.permissions;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoImpl;
import org.knopflerfish.framework.permissions.ConditionalPermissionInfoStorage;
import org.knopflerfish.framework.permissions.PermissionInfoStorage;
import org.knopflerfish.framework.permissions.PermissionsWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionUpdate;
import org.osgi.service.permissionadmin.PermissionInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalPermissionAdminImpl
implements ConditionalPermissionAdmin {
    public static final String SPEC_VERSION = "1.1.0";
    private final ConditionalPermissionInfoStorage cpis;
    private final PermissionInfoStorage pis;
    private final FrameworkContext framework;

    public ConditionalPermissionAdminImpl(ConditionalPermissionInfoStorage cpis, PermissionInfoStorage pis, FrameworkContext framework) {
        this.cpis = cpis;
        this.pis = pis;
        this.framework = framework;
    }

    @Override
    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conds, PermissionInfo[] perms) {
        return this.cpis.put(null, conds, perms);
    }

    @Override
    public ConditionalPermissionInfo setConditionalPermissionInfo(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        return this.cpis.put(name, conds, perms);
    }

    @Override
    public Enumeration<ConditionalPermissionInfo> getConditionalPermissionInfos() {
        return this.cpis.getAllEnumeration();
    }

    @Override
    public ConditionalPermissionInfo getConditionalPermissionInfo(String name) {
        return this.cpis.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccessControlContext getAccessControlContext(String[] signers) {
        PermissionsWrapper perms;
        ConditionalPermissionInfoStorage conditionalPermissionInfoStorage = this.cpis;
        synchronized (conditionalPermissionInfoStorage) {
            perms = new PermissionsWrapper(this.framework, this.pis, this.cpis, null, new DummyBundle(signers), null);
        }
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    @Override
    public ConditionalPermissionUpdate newConditionalPermissionUpdate() {
        return this.cpis.getUpdate();
    }

    @Override
    public ConditionalPermissionInfo newConditionalPermissionInfo(String name, ConditionInfo[] conditions, PermissionInfo[] permissions, String access) {
        if ("allow".equalsIgnoreCase(access)) {
            access = "allow";
        } else if ("deny".equalsIgnoreCase(access)) {
            access = "deny";
        } else {
            throw new IllegalArgumentException("access must be allow or deny");
        }
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("permissions must contain atleast one element");
        }
        return new ConditionalPermissionInfoImpl(this.cpis, name, conditions, permissions, access, this.framework);
    }

    @Override
    public ConditionalPermissionInfo newConditionalPermissionInfo(String encoded) {
        return new ConditionalPermissionInfoImpl(this.cpis, encoded, this.framework);
    }

    static class PrincipalDummy
    implements Principal {
        private final String name;

        PrincipalDummy(String dn) {
            this.name = dn;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class X509Dummy
    extends X509Certificate {
        Principal subject;

        X509Dummy(String dn) {
            this.subject = new PrincipalDummy(dn);
        }

        @Override
        public void checkValidity() {
        }

        @Override
        public void checkValidity(Date date) {
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public BigInteger getSerialNumber() {
            return null;
        }

        @Override
        public Principal getIssuerDN() {
            return null;
        }

        @Override
        public Principal getSubjectDN() {
            return this.subject;
        }

        @Override
        public Date getNotBefore() {
            return null;
        }

        @Override
        public Date getNotAfter() {
            return null;
        }

        @Override
        public byte[] getTBSCertificate() {
            return null;
        }

        @Override
        public byte[] getSignature() {
            return null;
        }

        @Override
        public String getSigAlgName() {
            return null;
        }

        @Override
        public String getSigAlgOID() {
            return null;
        }

        @Override
        public byte[] getSigAlgParams() {
            return null;
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return null;
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return null;
        }

        @Override
        public boolean[] getKeyUsage() {
            return null;
        }

        @Override
        public int getBasicConstraints() {
            return 0;
        }

        @Override
        public byte[] getEncoded() {
            return null;
        }

        @Override
        public PublicKey getPublicKey() {
            return null;
        }

        @Override
        public String toString() {
            return ((Object)new StringBuffer().append("X509Dummy, ").append(this.subject.getName())).toString();
        }

        @Override
        public void verify(PublicKey k) {
        }

        @Override
        public void verify(PublicKey k, String p) {
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return null;
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.subject).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.subject).hashCode();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DummyBundle
    implements Bundle {
        private final HashMap<X509Certificate, List<X509Certificate>> signerMap = new HashMap();

        DummyBundle(String[] signers) {
            for (String signer : signers) {
                String[] chain = Util.splitwords(signer, ";");
                ArrayList<X509Dummy> tmp = new ArrayList<X509Dummy>(chain.length);
                for (String element : chain) {
                    tmp.add(new X509Dummy(element));
                }
                this.signerMap.put((X509Certificate)tmp.get(0), (List<X509Certificate>)tmp);
            }
        }

        @Override
        public int getState() {
            return 1;
        }

        @Override
        public void start() {
            this.start(0);
        }

        @Override
        public void start(int options) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public void stop() {
            this.stop(0);
        }

        @Override
        public void stop(int options) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public void update() {
            this.update(null);
        }

        @Override
        public void update(InputStream in) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public void uninstall() {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return this.getHeaders(null);
        }

        @Override
        public long getBundleId() {
            return -1L;
        }

        @Override
        public String getLocation() {
            return "";
        }

        @Override
        public ServiceReference<?>[] getRegisteredServices() {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public ServiceReference<?>[] getServicesInUse() {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public boolean hasPermission(Object permission) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public BundleContext getBundleContext() {
            return null;
        }

        @Override
        public URL getResource(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public String getSymbolicName() {
            return null;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }

        @Override
        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            Map res = (Map)this.signerMap.clone();
            return res;
        }

        @Override
        public Version getVersion() {
            return Version.emptyVersion;
        }

        @Override
        public <A> A adapt(Class<A> type) {
            return null;
        }

        @Override
        public File getDataFile(String filename) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public URL getEntry(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public Enumeration<String> getEntryPaths(String path) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public Dictionary<String, String> getHeaders(String locale) {
            return new Hashtable<String, String>();
        }

        @Override
        public Enumeration<URL> getResources(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public Class<?> loadClass(String name) {
            throw new IllegalStateException("Bundle is uninstalled");
        }

        @Override
        public int compareTo(Bundle bundle) {
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((Bundle)x0);
        }
    }
}

