/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.base;

import java.util.ArrayList;
import net.infonode.properties.base.Property;

public class PropertyGroup {
    private PropertyGroup superGroup;
    private String name;
    private String description;
    private ArrayList properties = new ArrayList(10);

    public PropertyGroup(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public PropertyGroup(PropertyGroup superGroup, String name, String description) {
        this(name, description);
        this.superGroup = superGroup;
    }

    public PropertyGroup getSuperGroup() {
        return this.superGroup;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public boolean hasProperty(Property property) {
        return this.isA(property.getGroup());
    }

    public Property getProperty(int index) {
        return (Property)this.properties.get(index);
    }

    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public String toString() {
        return this.getName();
    }

    public Property getProperty(String name) {
        int i = 0;
        while (i < this.getPropertyCount()) {
            if (this.getProperty(i).getName().equals(name)) {
                return this.getProperty(i);
            }
            ++i;
        }
        return this.superGroup == null ? null : this.superGroup.getProperty(name);
    }

    private boolean isA(PropertyGroup group) {
        return group == this || this.getSuperGroup() != null && this.getSuperGroup().isA(group);
    }
}

