/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme.internal.laftheme;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.infonode.util.Direction;

class PanePainter
extends JTabbedPane {
    private boolean mouseEntered = false;
    private boolean focusActive = false;
    private boolean useMouseEnterExit = false;
    private Direction direction;

    PanePainter(Direction d) {
        this.setTabPlacement(d);
        this.setTabLayoutPolicy(0);
        boolean bl = this.useMouseEnterExit = UIManager.getLookAndFeel().getClass().getName().indexOf(".LiquidLookAndFeel") > -1;
        if (!this.useMouseEnterExit) {
            super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
        }
    }

    void setTabAreaEntered(boolean entered) {
        if (entered) {
            super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
        } else {
            super.processMouseEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, -1, -1, 0, false));
        }
    }

    private void setTabPlacement(Direction d) {
        this.direction = d;
        if (d == Direction.UP) {
            this.setTabPlacement(1);
        } else if (d == Direction.LEFT) {
            this.setTabPlacement(2);
        } else if (d == Direction.RIGHT) {
            this.setTabPlacement(4);
        } else {
            this.setTabPlacement(3);
        }
    }

    void setMouseEntered(boolean entered) {
        if (this.useMouseEnterExit) {
            if (entered && !this.mouseEntered) {
                super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
            } else if (!entered && this.mouseEntered) {
                super.processMouseEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, -1, -1, 0, false));
            }
        } else if (!entered && this.mouseEntered) {
            super.processMouseMotionEvent(new MouseEvent(this, 503, System.currentTimeMillis(), 0, -1, -1, 0, false));
        }
        this.mouseEntered = entered;
    }

    void setHoveredTab(int index) {
        if (index > -1 && index < this.getTabCount()) {
            Rectangle hoverBounds = this.getBoundsAt(index);
            int xPos = hoverBounds.x + hoverBounds.width / 2;
            int yPos = hoverBounds.y + hoverBounds.height / 2;
            super.processMouseMotionEvent(new MouseEvent(this, 503, System.currentTimeMillis(), 0, xPos, yPos, 0, false));
        }
    }

    void setFocusActive(boolean active) {
        if (active && !this.focusActive) {
            super.processFocusEvent(new FocusEvent(this, 1004));
        } else if (!active && this.focusActive) {
            super.processFocusEvent(new FocusEvent(this, 1005));
        }
        this.focusActive = active;
    }

    Direction getDirection() {
        return this.direction;
    }

    void doValidation() {
        Container c = this;
        while (c != null) {
            ((Component)c).invalidate();
            c = c.getParent();
        }
        this.validate();
    }

    void removeAllTabs() {
        this.removeAll();
        this.doValidation();
    }

    @Override
    public Font getFont() {
        Font font = UIManager.getFont("TabbedPane.font");
        return font == null ? super.getFont() : font;
    }

    @Override
    public void updateUI() {
        this.setBorder(null);
        this.setBackground(null);
        this.setForeground(null);
        this.setOpaque(false);
        super.updateUI();
        this.setTabLayoutPolicy(0);
        boolean bl = this.useMouseEnterExit = UIManager.getLookAndFeel().getClass().getName().indexOf(".LiquidLookAndFeel") > -1;
        if (!this.useMouseEnterExit) {
            super.processMouseEvent(new MouseEvent(this, 504, System.currentTimeMillis(), 0, 0, 0, 0, false));
        }
    }

    @Override
    public boolean hasFocus() {
        return this.focusActive;
    }

    @Override
    public void repaint() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    void paint(Graphics g, int tx, int ty) {
        Rectangle clip = g.getClipBounds();
        if (clip != null && clip.x == 0 && clip.y == 0 && clip.width == 0 && clip.height == 0) {
            return;
        }
        g.translate(tx, ty);
        this.update(g);
        g.translate(-tx, -ty);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
    }
}

