/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.io.xml;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementWriter;
import org.freeplane.core.io.IExtensionAttributeWriter;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ListHashTable;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.io.xml.XMLWriter;
import org.freeplane.core.util.LogUtils;
import org.freeplane.n3.nanoxml.XMLElement;

public class TreeXmlWriter
implements ITreeWriter {
    private boolean elementStarted = false;
    private final HashMap<Object, Object> hints;
    private final WriteManager writeManager;
    private XMLElement xmlElement;
    private final XMLWriter xmlwriter;

    public static String BooleanToXml(boolean col) {
        return col ? "true" : "false";
    }

    public static String dateToString(Date date) {
        return Long.toString(date.getTime());
    }

    public static String listToString(List<?> list) {
        ListIterator<?> it = list.listIterator(0);
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append(";");
        }
        return sb.toString();
    }

    public static String PointToXml(Point col) {
        if (col == null) {
            return null;
        }
        Vector<String> l = new Vector<String>();
        l.add(Integer.toString(col.x));
        l.add(Integer.toString(col.y));
        return TreeXmlWriter.listToString(l);
    }

    public void flush() {
        this.xmlwriter.flush();
    }

    public TreeXmlWriter(WriteManager writeManager, Writer writer) {
        this.writeManager = writeManager;
        this.xmlwriter = new XMLWriter(writer);
        this.hints = new HashMap();
    }

    @Override
    public void addAttribute(String key, double value) {
        this.addAttribute(key, Double.toString(value));
    }

    @Override
    public void addAttribute(String key, int value) {
        this.addAttribute(key, Integer.toString(value));
    }

    @Override
    public void addAttribute(String key, String value) {
        if (this.elementStarted) {
            throw new RuntimeException("elementStarted");
        }
        if (null != this.xmlElement.getAttribute(key, null)) {
            LogUtils.warn("attribute \"" + key + "\" already exist with value \"" + value);
            return;
        }
        this.xmlElement.setAttribute(key, value);
    }

    @Override
    public void addComment(String comment) throws IOException {
        this.xmlwriter.write("<!-- ");
        this.xmlwriter.write(comment);
        this.xmlwriter.write(" -->\n");
    }

    @Override
    public void addElement(Object userObject, String name) throws IOException {
        XMLElement element = new XMLElement(name);
        this.addElement(userObject, element);
    }

    @Override
    public void addElement(Object userObject, XMLElement element) throws IOException {
        boolean isString = userObject instanceof String;
        if (!this.elementStarted && this.xmlElement != null) {
            this.xmlwriter.write(this.xmlElement, !isString, 0, true, false);
        }
        String name = element.getName();
        this.xmlElement = element;
        this.elementStarted = false;
        Iterator<Object> iterator = this.getAttributeWriters().iterator(name);
        while (iterator.hasNext()) {
            IAttributeWriter as = iterator.next();
            as.writeAttributes(this, userObject, name);
        }
        if (userObject instanceof List) {
            this.addExtensionAttributes(userObject, (List)userObject);
        }
        if (isString) {
            this.addElementContent((String)userObject);
        } else {
            iterator = this.getNodeWriters().iterator(name);
            while (iterator.hasNext()) {
                IElementWriter nw = (IElementWriter)iterator.next();
                nw.writeContent(this, userObject, name);
            }
            if (userObject instanceof List) {
                this.addExtensionNodes(userObject, (List)userObject);
            }
        }
        if (!this.elementStarted) {
            this.xmlwriter.write(this.xmlElement, true, 0, true, true);
            this.elementStarted = true;
        } else {
            this.xmlwriter.endElement(name, true);
        }
    }

    @Override
    public void addElementContent(String content) throws IOException {
        if (content.equals("")) {
            return;
        }
        if (!this.elementStarted && this.xmlElement != null) {
            this.xmlwriter.write(this.xmlElement, true, 0, true, false);
            this.elementStarted = true;
        }
        this.xmlwriter.write(content);
    }

    @Override
    public void addExtensionAttributes(Object map, Collection<IExtension> extensions) {
        for (IExtension extension : extensions) {
            Iterator<IExtensionAttributeWriter> writerIterator = this.writeManager.getExtensionAttributeWriters().iterator(extension.getClass());
            while (writerIterator.hasNext()) {
                writerIterator.next().writeAttributes(this, map, extension);
            }
        }
    }

    @Override
    public void addExtensionNodes(Object map, Collection<IExtension> extensions) throws IOException {
        for (IExtension extension : extensions) {
            Iterator<IExtensionElementWriter> writerIterator = this.writeManager.getExtensionElementWriters().iterator(extension.getClass());
            while (writerIterator.hasNext()) {
                writerIterator.next().writeContent(this, map, extension);
            }
        }
    }

    private ListHashTable<String, IAttributeWriter> getAttributeWriters() {
        return this.writeManager.getAttributeWriters();
    }

    @Override
    public Object getHint(Object key) {
        Object object = this.hints.get(key);
        return object == null ? Boolean.FALSE : object;
    }

    private ListHashTable<String, IElementWriter> getNodeWriters() {
        return this.writeManager.getElementWriters();
    }

    @Override
    public void setHint(Object key) {
        this.hints.put(key, Boolean.TRUE);
    }

    @Override
    public void setHint(Object key, Object value) {
        this.hints.put(key, value);
    }
}

