/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.JComboBoxWithBorder;

public abstract class EditableComboProperty<T>
extends PropertyBean
implements IPropertyControl {
    final JComboBox comboBox;
    private T selected;

    public EditableComboProperty(String name, List<? extends T> values) {
        super(name);
        this.comboBox = this.createFormatChooser(values);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                EditableComboProperty.this.firePropertyChangeEvent();
            }
        });
    }

    private JComboBox createFormatChooser(List<? extends T> list) {
        JComboBoxWithBorder formatChooser = new JComboBoxWithBorder((Vector<?>)new Vector<T>(list));
        formatChooser.setEditable(true);
        formatChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object valueObject = EditableComboProperty.this.toValueObject(e.getItem());
                if (valueObject != null) {
                    EditableComboProperty.this.selected = valueObject;
                }
            }
        });
        return formatChooser;
    }

    @Override
    public String getValue() {
        return this.selected == null ? null : this.selected.toString();
    }

    public T getSelected() {
        return this.selected;
    }

    @Override
    public void layout(DefaultFormBuilder builder) {
        this.layout(builder, this.comboBox);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.comboBox.setEnabled(pEnabled);
    }

    @Override
    public void setValue(String value) {
        this.comboBox.setSelectedItem(value == null ? null : this.toValueObject(value));
    }

    public void setToolTipText(String text) {
        this.comboBox.setToolTipText(text);
    }

    public abstract T toValueObject(Object var1);
}

