/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.FontProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.KeyProperty;
import org.freeplane.core.resources.components.NextLineProperty;
import org.freeplane.core.resources.components.NumberProperty;
import org.freeplane.core.resources.components.PathProperty;
import org.freeplane.core.resources.components.PropertyAdapter;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.core.resources.components.RemindValueProperty;
import org.freeplane.core.resources.components.SeparatorProperty;
import org.freeplane.core.resources.components.StringProperty;
import org.freeplane.core.resources.components.TabProperty;
import org.freeplane.core.resources.components.Text;
import org.freeplane.core.resources.components.TextBoxProperty;
import org.freeplane.core.ui.IndexedTree;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.ui.TimePeriodUnits;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLException;

public class OptionPanelBuilder {
    private static final String MAX_INT = Integer.toString(Integer.MAX_VALUE);
    private final IPropertyControlCreator nextLineCreator;
    private final ReadManager readManager = new ReadManager();
    private final IndexedTree tree = new IndexedTree(null);

    public OptionPanelBuilder() {
        this.nextLineCreator = new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new NextLineProperty();
            }
        };
        this.initReadManager();
    }

    public void addBooleanProperty(String path, String name, int position) {
        this.addCreator(path, this.createBooleanOptionCreator(name), name, position);
    }

    public void addColorProperty(String path, String name, int position) {
        this.addCreator(path, this.createColorOptionCreator(name), name, position);
    }

    public void addComboProperty(String path, String name, Vector<String> choices, Vector<String> translations, int position) {
        IPropertyControlCreator creator = this.createComboProperty(name, choices, translations);
        this.addCreator(path, creator, name, position);
    }

    public void addEditableComboProperty(String path, String name, Vector<String> choices, Vector<String> translations, int position) {
        IPropertyControlCreator creator = this.createEditableComboProperty(name, choices, translations);
        this.addCreator(path, creator, name, position);
    }

    public void addCreator(String path, IPropertyControlCreator creator, int position) {
        this.tree.addElement(path, creator, position);
    }

    public void addCreator(String path, IPropertyControlCreator creator, String name, int position) {
        this.tree.addElement(path, creator, path + "/" + name, position);
    }

    public void addFontProperty(String path, String name, int position) {
        this.addCreator(path, this.createFontOptionCreator(name), name, position);
    }

    public void addKeyProperty(String path, String name, int position) {
        this.addCreator(path, this.createKeyOptionCreator(name), name, position);
    }

    public void addNumberProperty(String path, String name, int min, int max, int step, int position) {
        this.addCreator(path, this.createNumberOptionCreator(name, min, max, step), name, position);
    }

    public void addRemindValueProperty(String path, String name, int position) {
        this.addCreator(path, this.createRemindValueProperty(name), name, position);
    }

    public void addSeparator(String path, String name, int position) {
        this.addCreator(path, this.createSeparatorCreator(name), name, position);
    }

    public void addSpace(String path, int position) {
        this.tree.addElement(path, this.nextLineCreator, position);
    }

    public void addStringProperty(String path, String name, int position) {
        this.addCreator(path, this.createStringOptionCreator(name), name, position);
    }

    public void addTab(String name) {
        this.addTab(name, null, 0);
    }

    public void addTab(String name, String layout, int position) {
        this.tree.addElement(this.tree, this.createTabCreator(name, layout), name, position);
    }

    public void addText(String path, String name, int position) {
        this.addCreator(path, this.createTextCreator(name), name, position);
    }

    private IPropertyControlCreator createBooleanOptionCreator(final String name) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new BooleanProperty(name);
            }
        };
    }

    private IPropertyControlCreator createColorOptionCreator(final String name) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new ColorProperty(name, ResourceController.getResourceController().getDefaultProperty(name));
            }
        };
    }

    private IPropertyControlCreator createComboProperty(final String name, final Vector<String> choices, final Vector<String> translations) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new ComboProperty(name, choices, translations);
            }
        };
    }

    private IPropertyControlCreator createEditableComboProperty(final String name, final Vector<String> choices, final Vector<String> translations) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                ComboProperty comboProperty = new ComboProperty(name, choices, translations);
                comboProperty.setEditable(true);
                return comboProperty;
            }
        };
    }

    private IPropertyControlCreator createFontOptionCreator(final String name) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new FontProperty(name);
            }
        };
    }

    private IPropertyControlCreator createKeyOptionCreator(final String name) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new KeyProperty(name);
            }
        };
    }

    private IPropertyControlCreator createNumberOptionCreator(final String name, final int min, final int max, final int step) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new NumberProperty(name, min, max, step);
            }
        };
    }

    private IPropertyControlCreator createRemindValueProperty(final String name) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new RemindValueProperty(name);
            }
        };
    }

    private IPropertyControlCreator createSeparatorCreator(final String label) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new SeparatorProperty(label);
            }
        };
    }

    private IPropertyControlCreator createStringOptionCreator(final String name) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new StringProperty(name);
            }
        };
    }

    private IPropertyControlCreator createTextBoxOptionCreator(final String name, final int lines) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new TextBoxProperty(name, lines);
            }
        };
    }

    private IPropertyControlCreator createTabCreator(final String label, final String layout) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                if (layout != null) {
                    return new TabProperty(label, layout);
                }
                return new TabProperty(label);
            }
        };
    }

    private IPropertyControlCreator createTextCreator(final String label) {
        return new IPropertyControlCreator(){

            @Override
            public IPropertyControl createControl() {
                return new Text(label);
            }
        };
    }

    ReadManager getReadManager() {
        return this.readManager;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.getTree().getRoot();
    }

    IndexedTree getTree() {
        return this.tree;
    }

    private void initReadManager() {
        this.readManager.addElementHandler("preferences_structure", new EmptyCreator());
        this.readManager.addElementHandler("tabbed_pane", new EmptyCreator());
        this.readManager.addElementHandler("group", new EmptyCreator());
        this.readManager.addElementHandler("tab", new TabCreator());
        this.readManager.addElementHandler("separator", new SeparatorCreator());
        this.readManager.addElementHandler("text", new TextCreator());
        this.readManager.addElementHandler("string", new StringOptionCreator());
        this.readManager.addElementHandler("textbox", new TextBoxOptionCreator());
        this.readManager.addElementHandler("font", new FontOptionCreator());
        this.readManager.addElementHandler("boolean", new BooleanOptionCreator());
        this.readManager.addElementHandler("number", new NumberOptionCreator());
        this.readManager.addElementHandler("length", new LengthOptionCreator());
        this.readManager.addElementHandler("time_period", new TimePeriodOptionCreator());
        this.readManager.addElementHandler("path", new PathOptionCreator());
        this.readManager.addElementHandler("color", new ColorOptionCreator());
        this.readManager.addElementHandler("combo", new ComboOptionCreator());
        this.readManager.addElementHandler("languages", new LanguagesComboCreator());
        this.readManager.addElementHandler("key", new KeyOptionCreator());
        this.readManager.addElementHandler("remind_value", new RemindValueCreator());
    }

    public void load(URL menu) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(new BufferedInputStream(menu.openStream()));
            this.load(reader);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.silentlyClose(reader);
                throw throwable;
            }
        }
        FileUtils.silentlyClose(reader);
    }

    public void load(Reader inputStreamReader) {
        TreeXmlReader treeXmlReader = new TreeXmlReader(this.readManager);
        try {
            treeXmlReader.load(inputStreamReader);
        }
        catch (XMLException e) {
            throw new RuntimeException(e);
        }
    }

    private class TextCreator
    extends PropertyCreator {
        private TextCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            String label = "OptionPanel.text." + name;
            return OptionPanelBuilder.this.createTextCreator(label);
        }
    }

    private class TabCreator
    extends PropertyCreator {
        private TabCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            String label = "OptionPanel." + name;
            String layout = data.getAttribute("layout", null);
            return OptionPanelBuilder.this.createTabCreator(label, layout);
        }
    }

    private class TextBoxOptionCreator
    extends PropertyCreator {
        private TextBoxOptionCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            int lines = data.getAttribute("lines", 2);
            return OptionPanelBuilder.this.createTextBoxOptionCreator(name, lines);
        }
    }

    private class StringOptionCreator
    extends PropertyCreator {
        private StringOptionCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            return OptionPanelBuilder.this.createStringOptionCreator(name);
        }
    }

    private class SeparatorCreator
    extends PropertyCreator {
        private SeparatorCreator() {
        }

        @Override
        public void endElement(Object parent, String tag, Object userObject, XMLElement lastBuiltElement) {
            Path path = (Path)userObject;
            DefaultMutableTreeNode treeNode = OptionPanelBuilder.this.tree.get(path.path);
            if (treeNode.getUserObject() != this) {
                return;
            }
            super.endElement(parent, tag, userObject, lastBuiltElement);
            OptionPanelBuilder.this.tree.addElement(path.parentPath == null ? OptionPanelBuilder.this.tree : path.parentPath, OptionPanelBuilder.this.nextLineCreator, 0);
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            String label = "OptionPanel.separator." + name;
            return OptionPanelBuilder.this.createSeparatorCreator(label);
        }
    }

    private class RemindValueCreator
    extends PropertyCreator {
        private RemindValueCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            return OptionPanelBuilder.this.createRemindValueProperty(name);
        }
    }

    protected abstract class PropertyCreator
    implements IElementDOMHandler {
        protected PropertyCreator() {
        }

        @Override
        public Object createElement(Object parent, String tag, XMLElement attributes) {
            if (attributes == null) {
                return null;
            }
            String name = attributes.getAttribute("name", null);
            if (name == null) {
                return parent == null ? Path.emptyPath() : parent;
            }
            Path path = new Path(parent == null ? null : parent.toString());
            path.setName(name);
            if (!OptionPanelBuilder.this.tree.contains(path.path)) {
                OptionPanelBuilder.this.tree.addElement(path.parentPath == null ? OptionPanelBuilder.this.tree : path.parentPath, this, path.path, 0);
            }
            return path;
        }

        @Override
        public void endElement(Object parent, String tag, Object userObject, XMLElement lastBuiltElement) {
            String name = lastBuiltElement.getAttribute("name", null);
            Path path = (Path)userObject;
            if (path.path == null) {
                return;
            }
            DefaultMutableTreeNode treeNode = OptionPanelBuilder.this.tree.get(path.path);
            if (treeNode.getUserObject() == this) {
                final IPropertyControlCreator creator = this.getCreator(name, lastBuiltElement);
                final String text = lastBuiltElement.getAttribute("text", null);
                if (text == null) {
                    treeNode.setUserObject(creator);
                } else {
                    treeNode.setUserObject(new IPropertyControlCreator(){

                        @Override
                        public IPropertyControl createControl() {
                            IPropertyControl control = creator.createControl();
                            if (control instanceof PropertyAdapter) {
                                PropertyAdapter control2 = (PropertyAdapter)((Object)control);
                                control2.setLabel(text);
                            }
                            return control;
                        }
                    });
                }
            }
        }

        public abstract IPropertyControlCreator getCreator(String var1, XMLElement var2);
    }

    private static class Path {
        String parentPath;
        String path;

        static Path emptyPath() {
            Path Path2 = new Path(null);
            Path2.path = null;
            return Path2;
        }

        Path(String path) {
            this.parentPath = path;
        }

        void setName(String name) {
            this.path = this.parentPath == null ? name : this.parentPath + '/' + name;
        }

        public String toString() {
            return this.path;
        }
    }

    private class PathOptionCreator
    extends PropertyCreator {
        private PathOptionCreator() {
        }

        private IPropertyControlCreator createPathPropertyCreator(final String name, final boolean isDir, final String[] suffixes) {
            return new IPropertyControlCreator(){

                @Override
                public IPropertyControl createControl() {
                    return new PathProperty(name, isDir, suffixes);
                }
            };
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            boolean isDir = Boolean.parseBoolean(data.getAttribute("dir", "false"));
            String[] suffixes = this.parseCSV(data.getAttribute("suffixes", ""));
            return this.createPathPropertyCreator(name, isDir, suffixes);
        }

        private String[] parseCSV(String csv) {
            if (csv == null) {
                return null;
            }
            String[] result = csv.trim().split("\\s*,\\s*");
            return result.length > 0 ? result : null;
        }
    }

    private class TimePeriodOptionCreator
    extends PropertyCreator {
        private TimePeriodOptionCreator() {
        }

        private IPropertyControlCreator createNumberPropertyCreator(final String name, final String defaultUnit, final double min, final double step, final double max) {
            return new IPropertyControlCreator(){

                @Override
                public IPropertyControl createControl() {
                    return new QuantityProperty<TimePeriodUnits>(name, min, max, step, TimePeriodUnits.valueOf(defaultUnit));
                }
            };
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            String minString = data.getAttribute("min", "0");
            String maxString = data.getAttribute("max", "100000");
            String stepString = data.getAttribute("step", "1");
            String defaultUnit = data.getAttribute("defaultUnit", "ms");
            return this.createNumberPropertyCreator(name, defaultUnit, Double.parseDouble(minString), Double.parseDouble(stepString), Double.parseDouble(maxString));
        }
    }

    private class LengthOptionCreator
    extends PropertyCreator {
        private LengthOptionCreator() {
        }

        private IPropertyControlCreator createNumberPropertyCreator(final String name, final String defaultUnit, final double min, final double step, final double max) {
            return new IPropertyControlCreator(){

                @Override
                public IPropertyControl createControl() {
                    return new QuantityProperty<LengthUnits>(name, min, max, step, LengthUnits.valueOf(defaultUnit));
                }
            };
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            String minString = data.getAttribute("min", "0");
            String maxString = data.getAttribute("max", "100000");
            String stepString = data.getAttribute("step", "0.1");
            String defaultUnit = data.getAttribute("defaultUnit", "px");
            return this.createNumberPropertyCreator(name, defaultUnit, Double.parseDouble(minString), Double.parseDouble(stepString), Double.parseDouble(maxString));
        }
    }

    private class NumberOptionCreator
    extends PropertyCreator {
        private NumberOptionCreator() {
        }

        private IPropertyControlCreator createNumberPropertyCreator(final String name, final int min, final int step, final int max) {
            return new IPropertyControlCreator(){

                @Override
                public IPropertyControl createControl() {
                    return new NumberProperty(name, min, max, step);
                }
            };
        }

        private IPropertyControlCreator createNumberPropertyCreator(final String name, final double min, final double step, final double max) {
            return new IPropertyControlCreator(){

                @Override
                public IPropertyControl createControl() {
                    return new NumberProperty(name, min, max, step);
                }
            };
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            String minString = data.getAttribute("min", "1");
            String maxString = data.getAttribute("max", MAX_INT);
            String stepString = data.getAttribute("step", "1");
            if (minString.contains(".") || maxString.contains(".") || stepString.contains(".")) {
                return this.createNumberPropertyCreator(name, Double.parseDouble(minString), Double.parseDouble(stepString), Double.parseDouble(maxString));
            }
            return this.createNumberPropertyCreator(name, Integer.parseInt(minString), Integer.parseInt(stepString), Integer.parseInt(maxString));
        }
    }

    private class KeyOptionCreator
    extends PropertyCreator {
        private KeyOptionCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            return OptionPanelBuilder.this.createKeyOptionCreator(name);
        }
    }

    private class FontOptionCreator
    extends PropertyCreator {
        private FontOptionCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            return OptionPanelBuilder.this.createFontOptionCreator(name);
        }
    }

    private class EmptyCreator
    extends PropertyCreator {
        private EmptyCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            return null;
        }
    }

    private class LanguagesComboCreator
    extends PropertyCreator {
        private LanguagesComboCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            Set<String> locales = this.findAvailableLocales();
            locales.add("automatic");
            Vector<String> choices = new Vector<String>(locales.size());
            Vector<String> translations = new Vector<String>(locales.size());
            TreeMap<Object, String> inverseMap = new TreeMap<Object, String>(Collator.getInstance());
            for (String string : locales) {
                String translation = TextUtils.getOptionalText("OptionPanel." + string);
                choices.add(string);
                translations.add(translation);
                if (inverseMap.containsKey(translation)) {
                    LogUtils.severe("translation " + translation + " is used for more that one locale, for " + (String)inverseMap.get(translation) + " and for " + string + ".");
                }
                inverseMap.put(translation, string);
            }
            if (inverseMap.size() == choices.size()) {
                choices.clear();
                translations.clear();
                for (Map.Entry entry : inverseMap.entrySet()) {
                    choices.add((String)entry.getValue());
                    translations.add((String)entry.getKey());
                }
            }
            return OptionPanelBuilder.this.createComboProperty(name, choices, translations);
        }

        private Set<String> findAvailableLocales() {
            TreeSet<String> locales = new TreeSet<String>();
            LogUtils.info("available locales not found");
            locales.addAll(Arrays.asList(ResourceController.getResourceController().getProperty("locales").split(",")));
            return locales;
        }
    }

    private class ComboOptionCreator
    extends PropertyCreator {
        private ComboOptionCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            int childrenCount = data.getChildrenCount();
            Vector<String> choices = new Vector<String>(childrenCount);
            Vector<String> translations = new Vector<String>(childrenCount);
            for (int i = 0; i < childrenCount; ++i) {
                XMLElement element = data.getChildAtIndex(i);
                String choice = element.getAttribute("value", null);
                choices.add(choice);
                String translationKey = element.getAttribute("text", "OptionPanel." + choice);
                String translation = TextUtils.getOptionalText(translationKey);
                translations.add(translation);
            }
            return OptionPanelBuilder.this.createComboProperty(name, choices, translations);
        }
    }

    private class ColorOptionCreator
    extends PropertyCreator {
        private ColorOptionCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            return OptionPanelBuilder.this.createColorOptionCreator(name);
        }
    }

    private class BooleanOptionCreator
    extends PropertyCreator {
        private BooleanOptionCreator() {
        }

        @Override
        public IPropertyControlCreator getCreator(String name, XMLElement data) {
            return OptionPanelBuilder.this.createBooleanOptionCreator(name);
        }
    }
}

