/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.util.Quantity;

public class QuantityProperty<U extends Enum<U>>
extends PropertyBean
implements IPropertyControl {
    private final JSpinner numberSpinner;
    private final JComboBox unitBox;
    private final U defaultUnit;
    private U currentUnit;

    public QuantityProperty(String name, double min, double max, double step, U defaultUnit) {
        super(name);
        this.defaultUnit = defaultUnit;
        this.numberSpinner = new JSpinner(new SpinnerNumberModel(min, min, max, step));
        Object[] units = TranslatedObject.fromEnum(((Enum)defaultUnit).getDeclaringClass());
        this.unitBox = new JComboBoxWithBorder(units);
        this.addChangeListeners();
    }

    private void addChangeListeners() {
        this.numberSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent pE) {
                QuantityProperty.this.firePropertyChangeEvent();
            }
        });
        this.unitBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object newUnit = QuantityProperty.this.getCurrentUnit();
                    double value = (Double)QuantityProperty.this.numberSpinner.getValue();
                    Quantity<Enum> newQuantity = new Quantity<Enum>(value, QuantityProperty.this.currentUnit).in((Enum)newUnit);
                    QuantityProperty.this.currentUnit = newUnit;
                    if (value != newQuantity.value) {
                        QuantityProperty.this.numberSpinner.setValue(newQuantity.value);
                    } else {
                        QuantityProperty.this.firePropertyChangeEvent();
                    }
                }
            }
        });
    }

    @Override
    public String getValue() {
        return this.getQuantifiedValue().toString();
    }

    @Override
    public void layout(DefaultFormBuilder builder) {
        Box box = Box.createHorizontalBox();
        box.add(this.numberSpinner);
        box.add(this.unitBox);
        this.layout(builder, box);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.numberSpinner.setEnabled(pEnabled);
    }

    public void setQuantifiedValue(Quantity<U> quantity) {
        this.currentUnit = quantity.unit;
        this.numberSpinner.setValue(quantity.value);
        this.unitBox.setSelectedIndex(((Enum)quantity.unit).ordinal());
    }

    public Quantity<U> getQuantifiedValue() {
        double value = (Double)this.numberSpinner.getValue();
        U unit = this.getCurrentUnit();
        return new Quantity<U>(value, unit);
    }

    public U getCurrentUnit() {
        return (U)((Enum[])((Enum)this.defaultUnit).getDeclaringClass().getEnumConstants())[this.unitBox.getSelectedIndex()];
    }

    @Override
    public void setValue(String value) {
        Quantity<U> quantity = Quantity.fromString(value, this.defaultUnit);
        this.setQuantifiedValue(quantity);
    }
}

