/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.IFreeplaneAction;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;

public abstract class AFreeplaneAction
extends AbstractAction
implements IFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final String key;
    private boolean selected = false;
    private static Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();
    private final String rawText;

    public boolean checkEnabledOnChange() {
        EnabledAction annotation = this.getClass().getAnnotation(EnabledAction.class);
        if (annotation == null) {
            return false;
        }
        return annotation.checkOnNodeChange();
    }

    public boolean checkSelectionOnChange() {
        SelectableAction annotation = this.getClass().getAnnotation(SelectableAction.class);
        if (annotation == null) {
            return false;
        }
        return annotation.checkOnNodeChange();
    }

    public boolean checkSelectionOnPropertyChange() {
        SelectableAction annotation = this.getClass().getAnnotation(SelectableAction.class);
        if (annotation == null) {
            return false;
        }
        return !"".equals(annotation.checkOnPropertyChange());
    }

    public boolean checkSelectionOnPopup() {
        SelectableAction annotation = this.getClass().getAnnotation(SelectableAction.class);
        if (annotation == null) {
            return false;
        }
        return annotation.checkOnPopup();
    }

    public AFreeplaneAction(String key) {
        this.key = key;
        this.rawText = TextUtils.getRawText(this.getTextKey());
        LabelAndMnemonicSetter.setLabelAndMnemonic(this, this.rawText);
        this.setIcon(this.getIconKey());
        this.setTooltip(this.getTooltipKey());
    }

    protected void setIcon(String iconKey) {
        ImageIcon cachedIcon = iconCache.get(iconKey);
        if (cachedIcon != null) {
            this.putValue("SmallIcon", cachedIcon);
        } else {
            String iconResource = ResourceController.getResourceController().getProperty(iconKey, null);
            if (iconResource != null) {
                URL url = ResourceController.getResourceController().getResource(iconResource);
                if (url == null) {
                    LogUtils.severe("can not load icon '" + iconResource + "'");
                } else {
                    ImageIcon icon = new ImageIcon(url);
                    this.putValue("SmallIcon", icon);
                    iconCache.put(iconKey, icon);
                }
            }
        }
    }

    protected void setTooltip(String tooltipKey) {
        String tooltip = TextUtils.getRawText(tooltipKey, null);
        if (tooltip != null && !"".equals(tooltip)) {
            this.putValue("ShortDescription", tooltip);
            this.putValue("LongDescription", tooltip);
        }
    }

    public AFreeplaneAction(String key, String title, Icon icon) {
        this.putValue("SmallIcon", icon);
        if (title != null && !title.equals("")) {
            LabelAndMnemonicSetter.setLabelAndMnemonic(this, title);
        }
        this.rawText = title;
        this.key = key;
    }

    @Override
    public void afterMapChange(Object newMap) {
        if (newMap == null) {
            if (super.isEnabled()) {
                this.setEnabled(false);
            }
        } else {
            if (!super.isEnabled()) {
                this.setEnabled(true);
            }
            this.setEnabled();
        }
    }

    @Override
    public final String getIconKey() {
        return this.key + ".icon";
    }

    public String getKey() {
        return this.key;
    }

    public String getTextKey() {
        return this.key + ".text";
    }

    public String getTooltipKey() {
        return this.key + ".tooltip";
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setEnabled() {
    }

    public void setSelected() {
    }

    @Override
    public void setSelected(boolean newValue) {
        boolean oldValue = this.selected;
        if (oldValue != newValue) {
            this.selected = newValue;
            this.firePropertyChange("selected", oldValue, newValue);
        }
    }

    public void setVisible() {
    }

    public boolean isSelectable() {
        return this.getClass().getAnnotation(SelectableAction.class) != null;
    }

    public String getRawText() {
        return this.rawText;
    }
}

