/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ColoredIconCreator {
    private final Map<Color, Icon> coloredNoteIcons;
    private final int replacedColorRGB;
    private final Image originalImage;

    public ColoredIconCreator(URL iconUrl, Color replacedColor) {
        this(ColoredIconCreator.read(iconUrl), replacedColor);
    }

    public ColoredIconCreator(Image originalImage, Color replacedColor) {
        this.replacedColorRGB = 0xFFFFFF & replacedColor.getRGB();
        this.coloredNoteIcons = new HashMap<Color, Icon>();
        this.originalImage = originalImage;
    }

    private static BufferedImage read(URL iconUrl) {
        try {
            return ImageIO.read(iconUrl);
        }
        catch (IOException e) {
            return null;
        }
    }

    private BufferedImage copy(Image img) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public Icon createColoredIcon(Color iconColor) {
        Icon icon = this.coloredNoteIcons.get(iconColor);
        if (icon == null && this.originalImage != null) {
            icon = new ImageIcon(this.createColoredImage(iconColor));
            this.coloredNoteIcons.put(iconColor, icon);
        }
        return icon;
    }

    public Image createColoredImage(Color newColor) {
        int newRGB = 0xFFFFFF & newColor.getRGB();
        if (this.replacedColorRGB != newRGB && this.originalImage != null) {
            BufferedImage img = this.copy(this.originalImage);
            for (int x = 0; x < img.getWidth(); ++x) {
                for (int y = 0; y < img.getHeight(); ++y) {
                    int rgb = img.getRGB(x, y);
                    if ((0xFFFFFF & rgb) != this.replacedColorRGB) continue;
                    img.setRGB(x, y, 0xFF000000 & rgb | newRGB);
                }
            }
            return img;
        }
        return this.originalImage;
    }
}

