/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components.html;

import java.awt.Color;
import java.awt.Font;
import java.io.StringReader;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.ui.components.html.ScaledStyleSheet;

public class ScaledEditorKit
extends HTMLEditorKit {
    private static StyleSheet defaultStyles;
    private static ScaledEditorKit kit;

    protected ScaledEditorKit() {
    }

    @Override
    public StyleSheet getStyleSheet() {
        if (defaultStyles == null) {
            defaultStyles = new StyleSheet();
            StringReader r = new StringReader("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }");
            try {
                defaultStyles.loadRules(r, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            r.close();
            defaultStyles.addStyleSheet(super.getStyleSheet());
        }
        return defaultStyles;
    }

    @Override
    public Document createDefaultDocument() {
        StyleSheet styles = this.getStyleSheet();
        ScaledStyleSheet ss = new ScaledStyleSheet();
        ss.addStyleSheet(styles);
        HTMLDocument doc = new HTMLDocument(ss);
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(4);
        doc.setTokenThreshold(100);
        return doc;
    }

    public static ScaledEditorKit create() {
        if (kit == null) {
            kit = new ScaledEditorKit();
        }
        return kit;
    }

    public Document createDefaultDocument(JLabel c) {
        Font font = c.getFont();
        Color foreground = c.getForeground();
        StyleSheet styles = this.getStyleSheet();
        ScaledStyleSheet ss = new ScaledStyleSheet();
        ss.addStyleSheet(styles);
        HTMLDocument doc = new HTMLDocument(ss);
        doc.setPreservesUnknownTags(false);
        doc.getStyleSheet().addRule(new StringBuffer("body {").append(new CssRuleBuilder().withFont(font, UITools.FONT_SCALE_FACTOR).withColor(foreground).withAlignment(c.getHorizontalAlignment())).append("}").toString());
        doc.setParser(this.getParser());
        doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        doc.setPreservesUnknownTags(false);
        return doc;
    }
}

