/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.freeplane.core.ui.menubuilders.MenuStructureXmlHandler;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XmlEntryStructureBuilder
implements EntryVisitor {
    static final String ENTRY = "Entry";
    private Reader stringReader;

    public XmlEntryStructureBuilder(Reader stringReader) {
        this.stringReader = stringReader;
    }

    @Override
    public void visit(Entry target) {
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(new MenuStructureXmlHandler(target));
            xmlReader.parse(new InputSource(this.stringReader));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Entry buildMenuStructure(String xmlWithoutContent) {
        StringReader reader = new StringReader(xmlWithoutContent);
        return XmlEntryStructureBuilder.buildMenuStructure(reader);
    }

    public static Entry buildMenuStructure(Reader reader) {
        XmlEntryStructureBuilder builder = new XmlEntryStructureBuilder(reader);
        Entry initialMenuStructure = new Entry();
        builder.visit(initialMenuStructure);
        return initialMenuStructure;
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return false;
    }
}

