/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.ResourceAccessor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;

public class EntryAccessor {
    public static final String COMPONENT = "component";
    public static final Class<AFreeplaneAction> ACTION = AFreeplaneAction.class;
    public static final String TEXT = "text";
    public static final String TEXT_KEY = "textKey";
    public static final Class<Icon> ICON = Icon.class;
    public static final String ACCELERATOR = "accelerator";
    public final ResourceAccessor resourceAccessor;
    public static final String MENU_ELEMENT_SEPARATOR = " -> ";

    public EntryAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public EntryAccessor() {
        this(ResourceAccessor.NULL_RESOURCE_ACCESSOR);
    }

    public Icon getIcon(Entry entry) {
        ImageIcon icon;
        if (entry.getAttribute(ICON) != null) {
            return entry.getAttribute(ICON);
        }
        String name = entry.getName();
        String key = name + ".icon";
        String iconResource = this.resourceAccessor.getProperty(key);
        if (iconResource != null) {
            URL url = this.resourceAccessor.getResource(iconResource);
            if (url != null) {
                icon = new ImageIcon(url);
            } else {
                LogUtils.severe("Can not load icon '" + iconResource + "'");
                icon = null;
            }
        } else {
            icon = null;
        }
        return icon;
    }

    public String getText(Entry entry) {
        if (entry.getAttribute(TEXT) != null) {
            return (String)entry.getAttribute(TEXT);
        }
        String textKey = (String)entry.getAttribute(TEXT_KEY);
        if (textKey != null) {
            return this.resourceAccessor.getRawText(textKey);
        }
        AFreeplaneAction action = this.getAction(entry);
        if (action != null) {
            return action.getRawText();
        }
        String name = entry.getName();
        if (name.isEmpty()) {
            return "";
        }
        String rawText = this.resourceAccessor.getRawText(name);
        if (rawText != null) {
            return rawText;
        }
        return "";
    }

    public String getTextKey(Entry entry) {
        if (entry.getAttribute(TEXT) != null) {
            return null;
        }
        String textKey = (String)entry.getAttribute(TEXT_KEY);
        if (textKey != null) {
            return textKey;
        }
        AFreeplaneAction action = this.getAction(entry);
        if (action != null) {
            String actionTextKey = action.getTextKey();
            if (TextUtils.getRawText(actionTextKey, null) != null) {
                return actionTextKey;
            }
            return null;
        }
        String name = entry.getName();
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    public String getTooltipKey(Entry entry) {
        AFreeplaneAction action = this.getAction(entry);
        if (action != null) {
            String actionTooltipKey = action.getTooltipKey();
            return actionTooltipKey;
        }
        return null;
    }

    public Object getComponent(Entry entry) {
        return entry.getAttribute(COMPONENT);
    }

    public Object removeComponent(Entry entry) {
        return entry.removeAttribute(COMPONENT);
    }

    public void setComponent(Entry entry, Object component) {
        entry.setAttribute(COMPONENT, component);
    }

    public AFreeplaneAction getAction(Entry entry) {
        return entry.getAttribute(ACTION);
    }

    public void setAction(Entry entry, AFreeplaneAction action) {
        entry.setAttribute(ACTION, (Object)action);
    }

    public Object getAncestorComponent(Entry entry) {
        Entry parent = entry.getParent();
        if (parent == null) {
            return null;
        }
        Object parentComponent = this.getComponent(parent);
        if (parentComponent != null) {
            return parentComponent;
        }
        return this.getAncestorComponent(parent);
    }

    public void setText(Entry entry, String text) {
        entry.setAttribute(TEXT, (Object)text);
    }

    public void setIcon(Entry entry, Icon icon) {
        entry.setAttribute(ICON, (Object)icon);
    }

    public String getAccelerator(Entry entry) {
        String accelerator = (String)entry.getAttribute(ACCELERATOR);
        return accelerator;
    }

    public void addChildAction(Entry target, AFreeplaneAction action) {
        Entry actionEntry = new Entry();
        actionEntry.setName(action.getKey());
        this.setAction(actionEntry, action);
        target.addChild(actionEntry);
    }

    public String getLocationDescription(Entry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildLocationDescription(entry, stringBuilder);
        return stringBuilder.toString();
    }

    private void buildLocationDescription(Entry entry, StringBuilder stringBuilder) {
        String entryText;
        Entry parent = entry.getParent();
        if (parent != null) {
            this.buildLocationDescription(parent, stringBuilder);
        }
        if (!(entryText = TextUtils.removeMnemonic(this.getText(entry))).isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(MENU_ELEMENT_SEPARATOR);
            }
            stringBuilder.append(entryText);
        }
    }
}

