/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.io.IOException;
import org.freeplane.core.ui.menubuilders.generic.EntryNavigator;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;

public class EntryNavigatorFactory {
    private static final String MENU_ALIASES_PROPERTIES = "/menu_aliases.properties";
    private EntryNavigator entryNavigator;

    public EntryNavigator createNavigator() {
        this.entryNavigator = new EntryNavigator();
        try {
            String content = FileUtils.slurpResource(MENU_ALIASES_PROPERTIES);
            for (String line : content.split("[\n\r]+")) {
                this.parseLine(line);
            }
        }
        catch (IOException e) {
            LogUtils.severe("cannot load /menu_aliases.properties", e);
        }
        return this.entryNavigator;
    }

    private void parseLine(String line) {
        if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
            String[] words = line.split("\\s*=\\s*");
            if (words.length != 2) {
                throw new RuntimeException("parse error in /menu_aliases.properties line '" + line + "'");
            }
            this.entryNavigator.addAlias(words[0], words[1]);
        }
    }
}

