/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryPopupListener;

class PopupMenuListenerForEntry
implements PopupMenuListener {
    private final Entry entry;
    private final EntryPopupListener popupListener;
    final EntryAccessor entryAccessor = new EntryAccessor();

    PopupMenuListenerForEntry(Entry entry, EntryPopupListener popupListener) {
        this.entry = entry;
        this.popupListener = popupListener;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.fireChildEntriesWillBecomeVisible(this.entry);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopupMenuListenerForEntry.this.fireChildEntriesHidden(PopupMenuListenerForEntry.this.entry);
            }
        });
    }

    private void fireChildEntriesWillBecomeVisible(Entry entry) {
        this.popupListener.childEntriesWillBecomeVisible(entry);
        for (Entry child : entry.children()) {
            if (this.entryAccessor.getComponent(child) instanceof JMenu) continue;
            this.fireChildEntriesWillBecomeVisible(child);
        }
    }

    private void fireChildEntriesHidden(Entry entry) {
        this.popupListener.childEntriesHidden(entry);
        for (Entry child : entry.children()) {
            if (this.entryAccessor.getComponent(child) instanceof JMenu) continue;
            this.fireChildEntriesHidden(child);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

