/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

class StdFormatter
extends SimpleFormatter {
    public static final Level STDERR = new StdOutErrLevel("STDERR", Level.SEVERE.intValue() + 53);
    public static final Level STDOUT = new StdOutErrLevel("STDOUT", Level.WARNING.intValue() + 53);
    private final String lineSeparator = System.getProperty("line.separator");

    StdFormatter() {
    }

    @Override
    public synchronized String format(LogRecord record) {
        if (!STDERR.getName().equals(record.getLoggerName()) && !STDOUT.getName().equals(record.getLoggerName())) {
            return super.format(record);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.lineSeparator);
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        return sb.toString();
    }

    private static class StdOutErrLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        public StdOutErrLevel(String name, int value) {
            super(name, value);
        }
    }
}

