/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeConditionController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeContainsCondition
extends ASelectableCondition {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_contains_condition";
    static final String VALUE = "VALUE";
    static final String MATCH_CASE = "MATCH_CASE";
    static final String MATCH_APPROXIMATELY = "MATCH_APPROXIMATELY";
    private final Object attribute;
    private final String value;
    private final String comparedValue;
    private final boolean matchCase;
    private final boolean matchApproximately;
    private final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeContainsCondition(AttributeConditionController.toAttributeObject(element.getAttribute(ATTRIBUTE, null)), element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute(MATCH_CASE, null)), Boolean.valueOf(element.getAttribute(MATCH_APPROXIMATELY, null)));
    }

    public AttributeContainsCondition(Object attribute, String value, boolean matchCase, boolean matchApproximately) {
        this.attribute = attribute;
        this.value = value;
        this.matchCase = matchCase;
        this.comparedValue = value;
        this.matchApproximately = matchApproximately;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        TextController textController = TextController.getController();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            Object originalContent;
            String text;
            if (this.attribute.equals(AttributeConditionController.ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT)) {
                if (this.checkText(attributes.getValueAt(i, 0).toString())) {
                    return true;
                }
            } else if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            if (!this.checkText(text = textController.getTransformedTextNoThrow(originalContent = attributes.getValueAt(i, 1), node, null))) continue;
            return true;
        }
        return false;
    }

    private boolean checkText(String text) {
        return this.stringMatchingStrategy.matches(this.comparedValue, text, true, this.matchCase);
    }

    @Override
    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_contains");
        return ConditionFactory.createDescription(this.attribute.toString(), simpleCondition, this.value, this.matchCase, this.matchApproximately);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.attribute instanceof String) {
            child.setAttribute(ATTRIBUTE, (String)this.attribute);
        }
        child.setAttribute(VALUE, this.value);
        child.setAttribute(MATCH_CASE, Boolean.toString(this.matchCase));
        child.setAttribute(MATCH_APPROXIMATELY, Boolean.toString(this.matchApproximately));
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

