/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.util.regex.Pattern;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.attribute.AttributeConditionController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeMatchesCondition
extends ASelectableCondition {
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String NAME = "attribute_matches_condition";
    static final String VALUE = "VALUE";
    static final String MATCH_CASE = "MATCH_CASE";
    private final Object attribute;
    private final String value;
    private final Pattern searchPattern;

    static ASelectableCondition load(XMLElement element) {
        return new AttributeMatchesCondition(AttributeConditionController.toAttributeObject(element.getAttribute(ATTRIBUTE, null)), element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute(MATCH_CASE, null)));
    }

    public AttributeMatchesCondition(Object attribute, String value, boolean matchCase) {
        this.attribute = attribute;
        this.value = value;
        int flags = 32;
        if (!matchCase) {
            flags |= 0x42;
        }
        this.searchPattern = Pattern.compile(value, flags);
    }

    @Override
    public boolean checkNode(NodeModel node) {
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        TextController textController = TextController.getController();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            Object originalContent;
            String text;
            if (this.attribute.equals(AttributeConditionController.ANY_ATTRIBUTE_NAME_OR_VALUE_OBJECT)) {
                if (this.checkText(attributes.getValueAt(i, 0).toString())) {
                    return true;
                }
            } else if (!attributes.getValueAt(i, 0).equals(this.attribute)) continue;
            if (!this.checkText(text = textController.getTransformedTextNoThrow(originalContent = attributes.getValueAt(i, 1), node, null))) continue;
            return true;
        }
        return false;
    }

    private boolean checkText(String text) {
        return this.searchPattern.matcher(text).find();
    }

    @Override
    protected String createDescription() {
        String simpleCondition = TextUtils.getText("filter_regexp_matches");
        return ConditionFactory.createDescription(this.attribute.toString(), simpleCondition, this.value, this.isMatchCase(), false);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        if (this.attribute instanceof String) {
            child.setAttribute(ATTRIBUTE, (String)this.attribute);
        }
        child.setAttribute(VALUE, this.value);
        child.setAttribute(MATCH_CASE, Boolean.toString(this.isMatchCase()));
    }

    @Override
    protected String getName() {
        return NAME;
    }

    private boolean isMatchCase() {
        return (this.searchPattern.flags() & 2) == 0;
    }
}

