/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.clipboard;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.text.DetailTextModel;
import org.freeplane.features.text.TextController;

class MindMapHTMLWriter {
    private static String el = System.getProperty("line.separator");
    private final boolean basedOnHeadings;
    private final Writer fileout;
    private final MapController mapController;
    private boolean writeFoldingCode;
    private final NodeStyleController nodeStyleController;
    private Font defaultFont;
    private Color defaultColor;

    private static String convertSpecialChar(char c) {
        String cvt;
        switch (c) {
            case '\u00e4': {
                cvt = "&auml;";
                break;
            }
            case '\u00f6': {
                cvt = "&ouml;";
                break;
            }
            case '\u00fc': {
                cvt = "&uuml;";
                break;
            }
            case '\u00c4': {
                cvt = "&Auml;";
                break;
            }
            case '\u00d6': {
                cvt = "&Ouml;";
                break;
            }
            case '\u00dc': {
                cvt = "&Uuml;";
                break;
            }
            case '\u00df': {
                cvt = "&szlig;";
                break;
            }
            default: {
                cvt = "&#" + Integer.toString(c) + ";";
            }
        }
        return cvt;
    }

    private static String writeHTML_escapeUnicodeAndSpecialCharacters(String text) {
        int len = text.length();
        StringBuilder result = new StringBuilder(len);
        boolean previousSpace = false;
        boolean spaceOccured = false;
        for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue >= '\u0080') {
                result.append(MindMapHTMLWriter.convertSpecialChar(myChar));
                continue;
            }
            spaceOccured = false;
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case ' ': {
                    spaceOccured = true;
                    if (previousSpace) {
                        result.append("&nbsp;");
                        break;
                    }
                    result.append(" ");
                    break;
                }
                case '\n': {
                    result.append("\n<br>\n");
                    break;
                }
                default: {
                    result.append(myChar);
                }
            }
            previousSpace = spaceOccured;
        }
        return result.toString();
    }

    MindMapHTMLWriter(MapController mapController, Writer fileout) {
        this.mapController = mapController;
        this.nodeStyleController = NodeStyleController.getController();
        this.fileout = fileout;
        this.writeFoldingCode = false;
        this.basedOnHeadings = this.getProperty("html_export_folding").equals("html_export_based_on_headings");
    }

    private String fontStyle(Color color, Font font) throws IOException {
        StringBuilder fontStyle = new StringBuilder();
        if (!(color == null || this.defaultColor != null && color.equals(this.defaultColor))) {
            fontStyle.append("color: ").append(ColorUtils.colorToString(color)).append("; ");
        }
        if (font != null) {
            int fontSize = font.getSize();
            if (this.defaultFont == null || fontSize != this.defaultFont.getSize()) {
                fontStyle.append("font-size: ").append(fontSize).append("pt; ");
            }
            String fontFamily = font.getFamily();
            if (this.defaultFont == null || !fontFamily.equals(this.defaultFont.getFamily())) {
                fontStyle.append("font-family: ").append(fontFamily).append(", sans-serif; ");
            }
            if ((this.defaultFont == null || !this.defaultFont.isItalic()) && font.isItalic()) {
                fontStyle.append("font-style: italic; ");
            }
            if ((this.defaultFont == null || !this.defaultFont.isBold()) && font.isBold()) {
                fontStyle.append("font-weight: bold; ");
            }
        }
        return fontStyle.toString();
    }

    private String getProperty(String key) {
        return ResourceController.getResourceController().getProperty(key);
    }

    private void writeBodyWithFolding(NodeModel rootNodeOfBranch) throws IOException {
        this.writeJavaScript();
        this.fileout.write("<SPAN class=\"foldspecial\" onclick=\"fold_document()\">All +</SPAN>" + el);
        this.fileout.write("<SPAN class=\"foldspecial\" onclick=\"unfold_document()\">All -</SPAN>" + el);
        this.writeHTML(rootNodeOfBranch, "1", 0, true, true, 1);
        this.fileout.write("<SCRIPT type=\"text/javascript\">" + el);
        this.fileout.write("fold_document();" + el);
        this.fileout.write("</SCRIPT>" + el);
    }

    private void writeFoldingButtons(String localParentID) throws IOException {
        this.fileout.write("<span id=\"show" + localParentID + "\" class=\"foldclosed\" onClick=\"show_folder('" + localParentID + "')\" style=\"POSITION: absolute\">+</span> " + "<span id=\"hide" + localParentID + "\" class=\"foldopened\" onClick=\"hide_folder('" + localParentID + "')\">-</span>");
        this.fileout.write("\n");
    }

    void writeHTML(Collection<NodeModel> selectedNodes) throws IOException {
        this.fileout.write("<html>" + el + "<head>" + el);
        if (!selectedNodes.isEmpty()) {
            MapModel map = selectedNodes.iterator().next().getMap();
            this.setDefaultsFrom(map);
            this.writeStyle();
        }
        this.fileout.write(el + "</head>" + el + "<body>" + el);
        for (NodeModel node : selectedNodes) {
            this.writeHTML(node, "1", 0, true, true, 1);
        }
        this.fileout.write("</body>" + el);
        this.fileout.write("</html>" + el);
        this.fileout.close();
        this.resetDefaults();
    }

    private void resetDefaults() {
        this.defaultFont = null;
        this.defaultColor = null;
    }

    private void setDefaultsFrom(MapModel map) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        NodeModel styleNode = model.getStyleNodeSafe(MapStyleModel.DEFAULT_STYLE);
        this.defaultFont = this.nodeStyleController.getFont(styleNode);
        this.defaultColor = this.nodeStyleController.getColor(styleNode);
    }

    void writeHTML(NodeModel rootNodeOfBranch) throws IOException {
        Color background;
        this.setDefaultsFrom(rootNodeOfBranch.getMap());
        String htmlExportFoldingOption = this.getProperty("html_export_folding");
        this.writeFoldingCode = htmlExportFoldingOption.equals("html_export_fold_currently_folded") && this.mapController.hasFoldedStrictDescendant(rootNodeOfBranch) || htmlExportFoldingOption.equals("html_export_fold_all");
        ResourceController.getResourceController().getBooleanProperty("export_icons_in_html");
        this.fileout.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + el + "<html>" + el + "<head>" + el);
        this.fileout.write("<title>" + MindMapHTMLWriter.writeHTML_escapeUnicodeAndSpecialCharacters(TextController.getController().getPlainTextContent(rootNodeOfBranch).replace('\n', ' ')) + "</title>" + el);
        this.writeStyle();
        this.fileout.write(el + "</head>" + el + "<body");
        MapStyleModel style = MapStyleModel.getExtension(rootNodeOfBranch.getMap());
        Color color = background = style != null ? style.getBackgroundColor() : null;
        if (background != null) {
            this.fileout.write(" bgcolor=" + ColorUtils.colorToString(background));
        }
        this.fileout.write(">" + el);
        if (this.writeFoldingCode) {
            this.writeBodyWithFolding(rootNodeOfBranch);
        } else {
            this.writeHTML(rootNodeOfBranch, "1", 0, true, true, 1);
        }
        this.fileout.write("</body>" + el);
        this.fileout.write("</html>" + el);
        this.fileout.close();
        this.resetDefaults();
    }

    private int writeHTML(NodeModel model, String parentID, int lastChildNumber, boolean isRoot, boolean treatAsParagraph, int depth) throws IOException {
        String noteContent;
        String detailText;
        String link;
        String fontStyle;
        boolean heading;
        if (!model.hasVisibleContent()) {
            for (NodeModel child : this.mapController.childrenUnfolded(model)) {
                lastChildNumber = this.writeHTML(child, parentID, lastChildNumber, false, false, depth);
            }
            return lastChildNumber;
        }
        boolean createFolding = false;
        if (this.writeFoldingCode) {
            createFolding = this.mapController.isFolded(model);
            if (this.getProperty("html_export_folding").equals("html_export_fold_all")) {
                createFolding = this.mapController.hasChildren(model);
            }
            if (this.getProperty("html_export_folding").equals("html_export_no_folding") || this.basedOnHeadings || isRoot) {
                createFolding = false;
            }
        }
        TextController textController = TextController.getController();
        Object userObject = model.getUserObject();
        String text = textController.getTransformedTextNoThrow(userObject, model, userObject);
        boolean hasHtml = text.startsWith("<html>");
        boolean bl = heading = this.basedOnHeadings && !hasHtml && this.mapController.hasChildren(model) && depth <= 6;
        if (!treatAsParagraph && !this.basedOnHeadings) {
            this.fileout.write("<li>");
        } else if (heading) {
            this.fileout.write("<h" + depth + ">");
        } else if (!hasHtml) {
            this.fileout.write("<p>");
        }
        String localParentID = parentID;
        if (createFolding) {
            localParentID = parentID + "_" + ++lastChildNumber;
            this.writeFoldingButtons(localParentID);
        }
        if (!(fontStyle = this.fontStyle(this.nodeStyleController.getColor(model), this.nodeStyleController.getFont(model))).equals("")) {
            this.fileout.write("<span style=\"" + fontStyle + "\">");
        }
        if ((link = NodeLinks.getLinkAsString(model)) != null) {
            if (link.endsWith(".mm")) {
                link = link + ".html";
            }
            this.fileout.write("<a href=\"" + link + "\" target=\"_blank\">");
        }
        if (ResourceController.getResourceController().getBooleanProperty("export_icons_in_html")) {
            this.writeIcons(model);
        }
        this.writeModelContent(text);
        if (link != null) {
            this.fileout.write("</a>" + el);
        }
        if (fontStyle != "") {
            this.fileout.write("</span>");
        }
        if ((detailText = DetailTextModel.getDetailTextText(model)) != null) {
            this.writeModelContent(detailText);
        }
        if ((noteContent = NoteModel.getNoteText(model)) != null) {
            this.writeModelContent(noteContent);
        }
        this.fileout.write(el);
        if (heading) {
            this.fileout.write("</h" + depth + ">" + el);
        }
        if (this.getProperty("html_export_folding").equals("html_export_based_on_headings")) {
            for (NodeModel child : this.mapController.childrenUnfolded(model)) {
                lastChildNumber = this.writeHTML(child, parentID, lastChildNumber, false, false, depth + 1);
            }
            return lastChildNumber;
        }
        if (this.mapController.hasChildren(model)) {
            if (this.getProperty("html_export_folding").equals("html_export_based_on_headings")) {
                for (NodeModel child : this.mapController.childrenUnfolded(model)) {
                    lastChildNumber = this.writeHTML(child, parentID, lastChildNumber, false, false, depth + 1);
                }
            } else if (createFolding) {
                this.fileout.write("<ul id=\"fold" + localParentID + "\" style=\"POSITION: relative; VISIBILITY: visible;\">");
                int localLastChildNumber = 0;
                for (NodeModel child : this.mapController.childrenUnfolded(model)) {
                    localLastChildNumber = this.writeHTML(child, localParentID, localLastChildNumber, false, false, depth + 1);
                }
            } else {
                this.fileout.write("<ul>");
                for (NodeModel child : this.mapController.childrenUnfolded(model)) {
                    lastChildNumber = this.writeHTML(child, parentID, lastChildNumber, false, false, depth + 1);
                }
            }
            this.fileout.write(el);
            this.fileout.write("</ul>");
        }
        if (!treatAsParagraph) {
            this.fileout.write(el + "</li>" + el);
        }
        return lastChildNumber;
    }

    private void writeIcons(NodeModel model) throws IOException {
        Collection<MindIcon> icons = IconController.getController().getIcons(model);
        for (MindIcon icon : icons) {
            String iconFileName = icon.getFileName();
            this.fileout.write("<img src=\"" + iconFileName + "\" alt=\"" + icon.getTranslationValueLabel() + "\">");
        }
    }

    private void writeJavaScript() throws IOException {
        this.fileout.write("<script type=\"text/javascript\">" + el);
        this.fileout.write(FileUtils.slurpResource("/html/folding.js"));
        this.fileout.write(el + "</script>" + el);
    }

    private void writeModelContent(String string) throws IOException {
        if (string.matches(" +")) {
            this.fileout.write("&nbsp;");
        } else if (string.startsWith("<html")) {
            String output = string.substring(6);
            int start = output.indexOf("<body");
            start = start == -1 ? output.indexOf(62) + 1 : output.indexOf(62, start + 5) + 1;
            int end = output.indexOf("</body>");
            if (end == -1) {
                end = output.indexOf("</html>");
            }
            if (end == -1) {
                end = output.length();
            }
            output = output.substring(start, end);
            this.fileout.write(output);
        } else {
            this.fileout.write(HtmlUtils.unicodeToHTMLUnicodeEntity(string));
        }
    }

    private void writeStyle() throws IOException {
        this.fileout.write("<style type=\"text/css\">" + el);
        this.fileout.write("    body {");
        this.writeDefaultFontStyle();
        this.fileout.write("}" + el);
        this.fileout.write(FileUtils.slurpResource("/html/freeplane.css"));
        if (this.writeFoldingCode) {
            this.fileout.write(FileUtils.slurpResource("/html/folding.css"));
        }
        this.fileout.write(el + el + "</style>" + el + "<!-- ^ Position is not set to relative / absolute here because of Mozilla -->");
    }

    private void writeDefaultFontStyle() throws IOException {
        Font font = this.defaultFont;
        this.defaultFont = null;
        Color color = this.defaultColor;
        this.defaultColor = null;
        this.fileout.write(this.fontStyle(color, font));
        this.defaultFont = font;
        this.defaultColor = color;
    }
}

