/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.cloud;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.cloud.CloudBuilder;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class CloudController
implements IExtension {
    static final Stroke DEF_STROKE = new BasicStroke(3.0f);
    public static final int DEFAULT_WIDTH = -1;
    private static CloudAdapterListener listener = null;
    public static final int NORMAL_WIDTH = 3;
    public static final String RESOURCES_CLOUD_COLOR = "standardcloudcolor";
    private static Color standardColor = null;
    private final ExclusivePropertyChain<CloudModel, NodeModel> cloudHandlers = new ExclusivePropertyChain();

    public static Color getStandardColor() {
        return standardColor;
    }

    public static CloudController getController() {
        return CloudController.getController(Controller.getCurrentModeController());
    }

    public static CloudController getController(ModeController modeController) {
        return modeController.getExtension(CloudController.class);
    }

    public static void install(CloudController cloudController) {
        Controller.getCurrentModeController().addExtension(CloudController.class, cloudController);
    }

    public CloudController(final ModeController modeController) {
        if (listener == null) {
            listener = new CloudAdapterListener();
            ResourceController.getResourceController().addPropertyChangeListener(listener);
        }
        this.updateStandards();
        this.addCloudGetter(IPropertyHandler.STYLE, new IPropertyHandler<CloudModel, NodeModel>(){

            @Override
            public CloudModel getProperty(NodeModel node, CloudModel currentValue) {
                return CloudController.this.getStyleCloud(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node));
            }
        });
        MapController mapController = Controller.getCurrentModeController().getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        CloudBuilder cloudBuilder = new CloudBuilder(mapController, this);
        cloudBuilder.registerBy(readManager, writeManager);
    }

    protected CloudModel getStyleCloud(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            CloudModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = CloudModel.getModel(styleNode)) == null) continue;
            return styleModel;
        }
        return null;
    }

    public IPropertyHandler<CloudModel, NodeModel> addCloudGetter(Integer key, IPropertyHandler<CloudModel, NodeModel> getter) {
        return this.cloudHandlers.addGetter(key, getter);
    }

    public Color getColor(NodeModel node) {
        CloudModel cloud = this.getCloud(node);
        return cloud != null ? cloud.getColor() : null;
    }

    public Color getExteriorColor(NodeModel node) {
        return this.getColor(node).darker();
    }

    public int getWidth(NodeModel node) {
        return 3;
    }

    public IPropertyHandler<CloudModel, NodeModel> removeCloudGetter(Integer key) {
        return this.cloudHandlers.removeGetter(key);
    }

    private void updateStandards() {
        if (standardColor == null) {
            String stdColor = ResourceController.getResourceController().getProperty(RESOURCES_CLOUD_COLOR);
            standardColor = ColorUtils.stringToColor(stdColor);
        }
    }

    public CloudModel getCloud(NodeModel model) {
        return this.cloudHandlers.getProperty(model);
    }

    public CloudModel.Shape getShape(NodeModel node) {
        CloudModel cloud = this.getCloud(node);
        return cloud != null ? cloud.getShape() : null;
    }

    protected static class CloudAdapterListener
    implements IFreeplanePropertyListener {
        protected CloudAdapterListener() {
        }

        @Override
        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals(CloudController.RESOURCES_CLOUD_COLOR)) {
                standardColor = ColorUtils.stringToColor(newValue);
            }
        }
    }
}

