/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessControlException;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ButtonModelStateChangeListenerForProperty;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.JAutoToggleButton;
import org.freeplane.core.ui.components.JComboBoxWithBorder;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.ApplyNoFilteringAction;
import org.freeplane.features.filter.ApplySelectedViewConditionAction;
import org.freeplane.features.filter.ApplyToVisibleAction;
import org.freeplane.features.filter.EditFilterAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterHistory;
import org.freeplane.features.filter.FilterMenuBuilder;
import org.freeplane.features.filter.FindAction;
import org.freeplane.features.filter.QuickFilterAction;
import org.freeplane.features.filter.QuickFindAction;
import org.freeplane.features.filter.QuickFindAllAction;
import org.freeplane.features.filter.QuickHighlightAction;
import org.freeplane.features.filter.ReapplyFilterAction;
import org.freeplane.features.filter.RedoFilterAction;
import org.freeplane.features.filter.ShowAncestorsAction;
import org.freeplane.features.filter.ShowDescendantsAction;
import org.freeplane.features.filter.UndoFilterAction;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ConditionSnapshotFactory;
import org.freeplane.features.filter.condition.DefaultConditionRenderer;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.filter.condition.NoFilteringCondition;
import org.freeplane.features.filter.condition.SelectedViewCondition;
import org.freeplane.features.map.CloneOfSelectedViewCondition;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapNavigationUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.ToggleToolbarAction;
import org.freeplane.features.ui.UIComponentVisibilityDispatcher;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLParserFactory;
import org.freeplane.n3.nanoxml.XMLWriter;

public class FilterController
implements IMapSelectionListener,
IExtension {
    public static int TOOLBAR_SIDE = 0;
    static final String FREEPLANE_FILTER_EXTENSION_WITHOUT_DOT = "mmfilter";
    private static final ASelectableCondition NO_FILTERING = NoFilteringCondition.createCondition();
    private final ButtonModel applyToVisibleNodeOnly;
    private ConditionFactory conditionFactory;
    private DefaultConditionRenderer conditionRenderer = null;
    private final FilterChangeListener filterChangeListener;
    private DefaultComboBoxModel filterConditions;
    private final FilterMenuBuilder filterMenuBuilder;
    private JToolBar filterToolbar;
    private final FilterHistory history;
    private Filter inactiveFilter;
    private final String pathToFilterFile;
    private ASelectableCondition selectedViewCondition;
    private ASelectableCondition cloneOfSelectedViewCondition;
    private final ButtonModel showAncestors;
    private final ButtonModel approximateMatchingButtonModel;
    private final ButtonModel caseSensitiveButtonModel;
    private final ButtonModel showDescendants;
    private final ButtonModel highlightNodes;
    private ASelectableCondition highlightCondition;
    private JComboBox activeFilterConditionComboBox;
    private final FilterConditionEditor quickEditor;
    static final int USER_DEFINED_CONDITION_START_INDEX = 3;
    private final QuickFilterAction quickFilterAction;

    public static FilterController getController(Controller controller) {
        return controller.getExtension(FilterController.class);
    }

    public static FilterController getCurrentFilterController() {
        return FilterController.getController(Controller.getCurrentController());
    }

    public static void install() {
        Controller.getCurrentController().addExtension(FilterController.class, new FilterController());
    }

    public FilterController() {
        Controller controller = Controller.getCurrentController();
        this.filterMenuBuilder = new FilterMenuBuilder(controller, this);
        this.history = new FilterHistory();
        this.filterChangeListener = new FilterChangeListener();
        this.showAncestors = new JToggleButton.ToggleButtonModel();
        Filter transparentFilter = this.createTransparentFilter();
        this.showAncestors.setSelected(transparentFilter.areAncestorsShown());
        this.showAncestors.addChangeListener(this.filterChangeListener);
        this.showAncestors.addChangeListener(new ButtonModelStateChangeListenerForProperty("filter.showAncestors"));
        this.showDescendants = new JToggleButton.ToggleButtonModel();
        this.showDescendants.setSelected(transparentFilter.areDescendantsShown());
        this.showDescendants.addChangeListener(this.filterChangeListener);
        this.showDescendants.addChangeListener(new ButtonModelStateChangeListenerForProperty("filter.showDescendants"));
        this.highlightNodes = new JToggleButton.ToggleButtonModel();
        this.highlightNodes.setSelected(false);
        this.applyToVisibleNodeOnly = new JToggleButton.ToggleButtonModel();
        this.applyToVisibleNodeOnly.setSelected(false);
        this.approximateMatchingButtonModel = new JToggleButton.ToggleButtonModel();
        this.approximateMatchingButtonModel.setSelected(false);
        this.caseSensitiveButtonModel = new JToggleButton.ToggleButtonModel();
        this.caseSensitiveButtonModel.setSelected(false);
        controller.getMapViewManager().addMapSelectionListener(this);
        ToggleFilterToolbarAction showFilterToolbar = new ToggleFilterToolbarAction("ShowFilterToolbarAction", "/filter_toolbar");
        this.quickEditor = new FilterConditionEditor(this, 0, true);
        this.quickEditor.setEnterKeyActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((QuickFindAction)Controller.getCurrentController().getAction("QuickFindAction.FORWARD")).executeAction(true);
                if (FilterController.this.getHighlightNodes().isSelected()) {
                    FilterController.this.setHighlightCondition(FilterController.this.quickEditor.getCondition());
                }
            }
        });
        controller.addAction(showFilterToolbar);
        controller.addAction(new ApplyNoFilteringAction(this));
        controller.addAction(new ApplySelectedViewConditionAction(this));
        controller.addAction(new EditFilterAction(this));
        controller.addAction(new UndoFilterAction(this));
        controller.addAction(new RedoFilterAction(this));
        controller.addAction(new ReapplyFilterAction(this));
        controller.addAction(new ShowAncestorsAction(this));
        controller.addAction(new ShowDescendantsAction(this));
        controller.addAction(new ApplyToVisibleAction(this));
        this.quickFilterAction = new QuickFilterAction(this, this.quickEditor);
        controller.addAction(this.quickFilterAction);
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.BACK));
        controller.addAction(new QuickFindAction(this, this.quickEditor, MapController.Direction.FORWARD));
        controller.addAction(new QuickFindAllAction(this, this.quickEditor));
        controller.addAction(new QuickHighlightAction(this, this.quickEditor));
        FindAction find = new FindAction();
        controller.addAction(find);
        controller.addAction(find.getFindNextAction());
        controller.addAction(find.getFindPreviousAction());
        this.pathToFilterFile = ResourceController.getResourceController().getFreeplaneUserDirectory() + File.separator + "auto." + FREEPLANE_FILTER_EXTENSION_WITHOUT_DOT;
    }

    private void addStandardConditions() {
        ASelectableCondition noFiltering = NO_FILTERING;
        this.filterConditions.insertElementAt(noFiltering, 0);
        if (this.selectedViewCondition == null) {
            this.selectedViewCondition = SelectedViewCondition.CreateCondition();
        }
        this.filterConditions.insertElementAt(this.selectedViewCondition, 1);
        if (this.filterConditions.getSelectedItem() == null) {
            this.filterConditions.setSelectedItem(noFiltering);
        }
        if (this.cloneOfSelectedViewCondition == null) {
            this.cloneOfSelectedViewCondition = CloneOfSelectedViewCondition.CreateCondition();
        }
        this.filterConditions.insertElementAt(this.cloneOfSelectedViewCondition, 2);
    }

    @Override
    public void afterMapChange(MapModel oldMap, MapModel newMap) {
        if (this.filterToolbar == null) {
            return;
        }
        this.history.clear();
        if (newMap != null) {
            this.filterToolbar.setEnabled(true);
            this.activeFilterConditionComboBox.setEnabled(true);
            this.quickEditor.setEnabled(true);
            this.quickEditor.mapChanged(newMap);
            Filter filter = newMap.getFilter();
            this.updateSettingsFromFilter(filter);
            this.quickFilterAction.setSelected(this.isFilterActive());
        } else {
            this.filterConditions.setSelectedItem(this.filterConditions.getElementAt(0));
            this.filterToolbar.setEnabled(false);
            this.quickEditor.setEnabled(false);
            this.activeFilterConditionComboBox.setEnabled(false);
        }
    }

    void applyFilter(boolean force) {
        this.quickFilterAction.setSelected(this.isFilterActive());
        ASelectableCondition selectedCondition = this.getSelectedCondition();
        Filter filter = this.createFilter(selectedCondition);
        ICondition condition = this.condition(filter);
        if (condition != selectedCondition && condition instanceof ASelectableCondition) {
            this.getFilterConditions().setSelectedItem(condition);
        } else {
            this.applyFilter(filter, Controller.getCurrentController().getMap(), force);
        }
    }

    public void applyFilter(Filter filter, MapModel map, boolean force) {
        filter.applyFilter(this, map, force);
        this.history.add(filter);
    }

    public void applyNoFiltering() {
        this.getFilterConditions().setSelectedItem(NO_FILTERING);
    }

    void applySelectedViewCondition() {
        if (this.getFilterConditions().getSelectedItem() != this.selectedViewCondition) {
            this.getFilterConditions().setSelectedItem(this.selectedViewCondition);
        } else {
            this.applyFilter(true);
        }
    }

    @Override
    public void beforeMapChange(MapModel oldMap, MapModel newMap) {
    }

    private Filter createFilter(ASelectableCondition selectedCondition) {
        ASelectableCondition filterCondition = selectedCondition == null || selectedCondition.equals(NO_FILTERING) ? null : (selectedCondition instanceof ConditionSnapshotFactory ? ((ConditionSnapshotFactory)((Object)selectedCondition)).createSnapshotCondition() : selectedCondition);
        Filter filter = new Filter(filterCondition, this.showAncestors.isSelected(), this.showDescendants.isSelected(), this.applyToVisibleNodeOnly.isSelected());
        return filter;
    }

    private JToolBar createFilterToolbar() {
        FreeplaneToolBar filterToolbar = new FreeplaneToolBar("filter_toolbar", 0);
        filterToolbar.setVisible(ResourceController.getResourceController().getBooleanProperty("filter_toolbar_visible"));
        Controller controller = Controller.getCurrentController();
        FrameController frameController = (FrameController)controller.getViewController();
        UIComponentVisibilityDispatcher.install(frameController, filterToolbar, "filter_toolbar_visible");
        JButton undoBtn = new JButton(controller.getAction("UndoFilterAction"));
        JButton redoBtn = new JButton(controller.getAction("RedoFilterAction"));
        JAutoToggleButton showAncestorsBox = new JAutoToggleButton(controller.getAction("ShowAncestorsAction"), this.showAncestors);
        showAncestorsBox.setSelected(this.showAncestors.isSelected());
        JAutoToggleButton showDescendantsBox = new JAutoToggleButton(controller.getAction("ShowDescendantsAction"), this.showDescendants);
        JAutoToggleButton applyToVisibleBox = new JAutoToggleButton(controller.getAction("ApplyToVisibleAction"), this.applyToVisibleNodeOnly);
        JButton btnEdit = new JButton(controller.getAction("EditFilterAction"));
        this.activeFilterConditionComboBox = new JComboBoxWithBorder((ComboBoxModel)this.getFilterConditions());
        JButton applyBtn = new JButton(controller.getAction("ReapplyFilterAction"));
        JButton filterSelectedBtn = new JButton(controller.getAction("ApplySelectedViewConditionAction"));
        JButton noFilteringBtn = new JButton(controller.getAction("ApplyNoFilteringAction"));
        JButton applyFindPreviousBtn = new JButton(controller.getAction("QuickFindAction.BACK"));
        JButton applyFindNextBtn = new JButton(controller.getAction("QuickFindAction.FORWARD"));
        JAutoToggleButton applyQuickFilterBtn = new JAutoToggleButton(controller.getAction("QuickFilterAction"));
        JButton applyQuickSelectBtn = new JButton(controller.getAction("QuickFindAllAction"));
        JAutoToggleButton applyQuickHighlightBtn = new JAutoToggleButton(controller.getAction("QuickHighlightAction"));
        filterToolbar.addSeparator();
        ((Container)filterToolbar).add(undoBtn);
        ((Container)filterToolbar).add(redoBtn);
        ((Container)filterToolbar).add(showAncestorsBox);
        ((Container)filterToolbar).add(showDescendantsBox);
        ((Container)filterToolbar).add(applyToVisibleBox);
        ((Container)filterToolbar).add(this.activeFilterConditionComboBox);
        ((Container)filterToolbar).add(applyBtn);
        ((Container)filterToolbar).add(filterSelectedBtn);
        ((Container)filterToolbar).add(noFilteringBtn);
        ((Container)filterToolbar).add(btnEdit);
        filterToolbar.addSeparator();
        ((Container)filterToolbar).add(this.quickEditor);
        ((Container)filterToolbar).add(applyFindPreviousBtn);
        ((Container)filterToolbar).add(applyFindNextBtn);
        ((Container)filterToolbar).add(applyQuickSelectBtn);
        ((Container)filterToolbar).add(applyQuickFilterBtn);
        ((Container)filterToolbar).add(applyQuickHighlightBtn);
        DefaultConditionRenderer toolbarConditionRenderer = new DefaultConditionRenderer(TextUtils.getText("filter_no_filtering"), false);
        this.activeFilterConditionComboBox.setRenderer(toolbarConditionRenderer);
        return filterToolbar;
    }

    public Filter createTransparentFilter() {
        if (this.inactiveFilter == null) {
            this.inactiveFilter = Filter.createTransparentFilter();
        }
        return this.inactiveFilter;
    }

    protected ButtonModel getApplyToVisibleNodeOnly() {
        return this.applyToVisibleNodeOnly;
    }

    public ConditionFactory getConditionFactory() {
        if (this.conditionFactory == null) {
            this.conditionFactory = new ConditionFactory();
        }
        return this.conditionFactory;
    }

    DefaultConditionRenderer getConditionRenderer() {
        if (this.conditionRenderer == null) {
            this.conditionRenderer = new DefaultConditionRenderer(TextUtils.getText("filter_no_filtering"), true);
        }
        return this.conditionRenderer;
    }

    public DefaultComboBoxModel getFilterConditions() {
        if (this.filterConditions == null) {
            this.initConditions();
        }
        return this.filterConditions;
    }

    public JToolBar getFilterToolbar() {
        if (this.filterToolbar == null) {
            this.filterToolbar = this.createFilterToolbar();
        }
        return this.filterToolbar;
    }

    public FilterHistory getHistory() {
        return this.history;
    }

    ASelectableCondition getSelectedCondition() {
        return (ASelectableCondition)this.getFilterConditions().getSelectedItem();
    }

    public ButtonModel getShowAncestors() {
        return this.showAncestors;
    }

    public ButtonModel getShowDescendants() {
        return this.showDescendants;
    }

    public ButtonModel getHighlightNodes() {
        return this.highlightNodes;
    }

    public ASelectableCondition getHighlightCondition() {
        return this.highlightCondition;
    }

    void setHighlightCondition(ASelectableCondition condition) {
        if (condition != null) {
            this.highlightCondition = condition;
            this.getHighlightNodes().setSelected(true);
        } else {
            this.highlightCondition = null;
        }
        Component mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        if (mapViewComponent != null) {
            mapViewComponent.repaint();
        }
    }

    private void initConditions() {
        this.filterConditions = new DefaultComboBoxModel();
        this.addStandardConditions();
        this.filterConditions.setSelectedItem(this.filterConditions.getElementAt(0));
        this.filterConditions.addListDataListener(this.filterChangeListener);
    }

    public void loadDefaultConditions() {
        try {
            this.loadConditions(this.getFilterConditions(), this.pathToFilterFile, false);
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }

    void loadConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile, boolean showPopupOnError) throws IOException {
        block5: {
            try {
                IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
                File filterFile = new File(pathToFilterFile);
                StdXMLReader reader = new StdXMLReader(new BufferedInputStream(new FileInputStream(filterFile)));
                parser.setReader(reader);
                reader.setSystemID(filterFile.toURL().toString());
                XMLElement loader = (XMLElement)parser.parse();
                Vector<XMLElement> conditions = loader.getChildren();
                for (int i = 0; i < conditions.size(); ++i) {
                    ASelectableCondition condition = this.getConditionFactory().loadCondition(conditions.get(i));
                    if (condition == null) continue;
                    filterConditionModel.addElement(condition);
                }
            }
            catch (FileNotFoundException parser) {
            }
            catch (AccessControlException parser) {
            }
            catch (Exception e) {
                LogUtils.warn(e);
                if (!showPopupOnError) break block5;
                UITools.errorMessage(TextUtils.getText("filters_not_loaded"));
            }
        }
    }

    public void saveConditions() {
        try {
            this.saveConditions(this.getFilterConditions(), this.pathToFilterFile);
        }
        catch (Exception e) {
            LogUtils.warn(e);
        }
    }

    void saveConditions(DefaultComboBoxModel filterConditionModel, String pathToFilterFile) throws IOException {
        XMLElement saver = new XMLElement();
        saver.setName("filter_conditions");
        FileWriter writer = new FileWriter(pathToFilterFile);
        for (int i = 0; i < filterConditionModel.getSize(); ++i) {
            ASelectableCondition cond = (ASelectableCondition)filterConditionModel.getElementAt(i);
            if (cond == null || cond instanceof NoFilteringCondition) continue;
            cond.toXml(saver);
        }
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.write(saver, true);
        ((Writer)writer).close();
    }

    void setFilterConditions(DefaultComboBoxModel newConditionModel) {
        this.filterConditions.removeListDataListener(this.filterChangeListener);
        this.filterConditions.removeAllElements();
        for (int i = 0; i < newConditionModel.getSize(); ++i) {
            this.filterConditions.addElement(newConditionModel.getElementAt(i));
        }
        this.filterConditions.setSelectedItem(newConditionModel.getSelectedItem());
        this.addStandardConditions();
        this.filterConditions.addListDataListener(this.filterChangeListener);
        this.applyFilter(false);
        this.filterMenuBuilder.updateMenus();
    }

    private void updateSettingsFromFilter(Filter filter) {
        this.getFilterConditions().removeListDataListener(this.filterChangeListener);
        this.showAncestors.removeChangeListener(this.filterChangeListener);
        this.showDescendants.removeChangeListener(this.filterChangeListener);
        this.filterConditions.setSelectedItem(this.condition(filter));
        this.showAncestors.setSelected(filter.areAncestorsShown());
        this.showDescendants.setSelected(filter.areDescendantsShown());
        this.applyToVisibleNodeOnly.setSelected(filter.appliesToVisibleNodesOnly());
        this.filterConditions.addListDataListener(this.filterChangeListener);
        this.showAncestors.addChangeListener(this.filterChangeListener);
        this.showDescendants.addChangeListener(this.filterChangeListener);
        this.quickFilterAction.setSelected(this.isFilterActive());
    }

    private ICondition condition(Filter filter) {
        ICondition condition = filter.getCondition();
        if (condition == null) {
            return NO_FILTERING;
        }
        return condition;
    }

    void updateSettingsFromHistory() {
        Filter filter = this.history.getCurrentFilter();
        this.updateSettingsFromFilter(filter);
    }

    NodeModel findNext(NodeModel from, NodeModel end, MapController.Direction direction, ASelectableCondition condition) {
        block6: {
            NodeModel next = from;
            while (true) {
                switch (direction) {
                    case FORWARD: 
                    case FORWARD_N_FOLD: {
                        next = MapNavigationUtils.findNext(direction, next, end);
                        break;
                    }
                    case BACK: 
                    case BACK_N_FOLD: {
                        next = MapNavigationUtils.findPrevious(direction, next, end);
                    }
                }
                if (next == null) {
                    return null;
                }
                if (!next.hasVisibleContent()) continue;
                if (next == from) break block6;
                if (condition == null || condition.checkNode(next)) break;
            }
            return next;
        }
        return null;
    }

    public void redo() {
        this.history.redo();
        this.updateSettingsFromHistory();
    }

    public void undo() {
        this.history.undo();
        this.updateSettingsFromHistory();
    }

    public boolean isNodeHighlighted(NodeModel node) {
        return this.highlightCondition != null && this.highlightCondition.checkNode(node);
    }

    public ButtonModel getApproximateMatchingButtonModel() {
        return this.approximateMatchingButtonModel;
    }

    public ButtonModel getCaseSensitiveButtonModel() {
        return this.caseSensitiveButtonModel;
    }

    public void apply(ASelectableCondition condition) {
        DefaultComboBoxModel filterConditions = this.getFilterConditions();
        if (condition.equals(filterConditions.getSelectedItem())) {
            this.applyFilter(true);
        } else {
            filterConditions.setSelectedItem(condition);
        }
    }

    public EntryVisitor getMenuBuilder() {
        return this.filterMenuBuilder;
    }

    public boolean isFilterActive() {
        ASelectableCondition selectedCondition = this.getSelectedCondition();
        return NO_FILTERING != selectedCondition && null != selectedCondition;
    }

    private class FilterChangeListener
    implements ListDataListener,
    ChangeListener {
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() == -1) {
                FilterController.this.applyFilter(false);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FilterController.this.applyFilter(false);
        }
    }

    @SelectableAction(checkOnPopup=true)
    private class ToggleFilterToolbarAction
    extends ToggleToolbarAction {
        private ToggleFilterToolbarAction(String actionName, String toolbarName) {
            super(actionName, toolbarName);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComponent toolbar = this.getToolbar();
            if (toolbar == null) {
                return;
            }
            boolean visible = this.isVisible();
            if (visible && !FilterController.this.quickEditor.isInputFieldFocused() && EventQueue.getCurrentEvent() instanceof KeyEvent) {
                FilterController.this.quickEditor.focusInputField(true);
            } else {
                this.changeFocusWhenVisibilityChanges(toolbar);
                super.actionPerformed(event);
            }
        }

        private void changeFocusWhenVisibilityChanges(JComponent toolBar) {
            FilterController.this.quickEditor.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    FilterController.this.quickEditor.focusInputField(true);
                    FilterController.this.quickEditor.removeAncestorListener(this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    Component selectedComponent = Controller.getCurrentController().getMapViewManager().getSelectedComponent();
                    if (selectedComponent != null) {
                        selectedComponent.requestFocusInWindow();
                    }
                    FilterController.this.quickEditor.removeAncestorListener(this);
                }
            });
        }
    }
}

