/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.util.LinkedList;
import java.util.ListIterator;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;

public class FilterHistory {
    private ListIterator<Filter> filters;

    FilterHistory() {
        this.init();
    }

    void add(Filter filter) {
        Filter currentFilter = this.getCurrentFilter();
        if (this.isConditionStronger(currentFilter, filter)) {
            this.filters.previous();
            this.filters.remove();
        }
        while (this.filters.hasNext()) {
            this.filters.next();
            this.filters.remove();
        }
        this.filters.add(filter);
    }

    void clear() {
        this.init();
    }

    Filter getCurrentFilter() {
        this.filters.previous();
        return this.filters.next();
    }

    private void init() {
        LinkedList list = new LinkedList();
        this.filters = list.listIterator();
        this.filters.add(Filter.createTransparentFilter());
    }

    private boolean isConditionStronger(Filter oldFilter, Filter newFilter) {
        return newFilter.isConditionStronger(oldFilter);
    }

    void redo() {
        if (!this.filters.hasNext()) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        Filter next = this.filters.next();
        next.applyFilter(this, map, true);
    }

    void undo() {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        Filter previous = this.filters.previous();
        this.undoImpl(map);
        while (previous != this.filters.next()) {
        }
        if (this.filters.nextIndex() > 1) {
            this.filters.previous();
        }
    }

    private void undoImpl(MapModel map) {
        if (!this.filters.hasPrevious()) {
            return;
        }
        Filter previous = this.filters.previous();
        if (previous.appliesToVisibleNodesOnly()) {
            this.undoImpl(map);
        }
        previous.applyFilter(this, map, true);
    }
}

