/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.FoundNodes;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class FindAction
extends AFreeplaneAction {
    static final String KEY = "FindAction";
    private static final long serialVersionUID = 1L;
    private FilterConditionEditor editor;
    private final FindNextAction findNextAction = new FindNextAction();
    private final AFreeplaneAction findPreviousAction = new FindPreviousAction();

    public FindAction() {
        super(KEY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            return;
        }
        NodeModel start = selection.getSelected();
        if (this.editor == null) {
            this.editor = new FilterConditionEditor(FilterController.getCurrentFilterController());
            this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        } else {
            this.editor.mapChanged(start.getMap());
        }
        this.editor.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JComponent component = event.getComponent();
                final Window windowAncestor = SwingUtilities.getWindowAncestor(component);
                if (windowAncestor.isFocused()) {
                    FindAction.this.editor.focusInputField(true);
                } else {
                    windowAncestor.addWindowFocusListener(new WindowFocusListener(){

                        @Override
                        public void windowLostFocus(WindowEvent e) {
                        }

                        @Override
                        public void windowGainedFocus(WindowEvent e) {
                            windowAncestor.removeWindowFocusListener(this);
                            FindAction.this.editor.focusInputField(true);
                        }
                    });
                    windowAncestor.toFront();
                }
                FindAction.this.editor.removeAncestorListener(this);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        int run = UITools.showConfirmDialog(start, this.editor, TextUtils.getText("FindAction.text"), 2, -1);
        Container parent = this.editor.getParent();
        if (parent != null) {
            parent.remove(this.editor);
        }
        if (run != 0) {
            return;
        }
        ASelectableCondition condition = this.editor.getCondition();
        this.findFirst(condition);
    }

    void findFirst(ASelectableCondition condition) {
        FoundNodes info = FoundNodes.get(Controller.getCurrentController().getMap());
        info.condition = condition;
        if (info.condition == null) {
            return;
        }
        info.rootID = Controller.getCurrentController().getSelection().getSelected().createID();
        this.findNext(MapController.Direction.FORWARD);
    }

    void findNext(MapController.Direction direction) {
        MapModel map = Controller.getCurrentController().getMap();
        FoundNodes info = FoundNodes.get(map);
        if (info.condition == null) {
            this.displayNoPreviousFindMessage();
            return;
        }
        FilterController filterController = FilterController.getCurrentFilterController();
        NodeModel start = Controller.getCurrentController().getSelection().getSelected();
        NodeModel root = map.getNodeForID(info.rootID);
        if (root == null) {
            info.condition = null;
            this.displayNoPreviousFindMessage();
            return;
        }
        NodeModel next = filterController.findNext(start, null, direction, info.condition);
        if (next == null) {
            this.displayNotFoundMessage(root, info.condition);
            return;
        }
        info.displayFoundNode(next);
    }

    private void displayNoPreviousFindMessage() {
        UITools.informationMessage(Controller.getCurrentController().getViewController().getCurrentRootComponent(), TextUtils.getText("no_previous_find"));
    }

    private void displayNotFoundMessage(NodeModel start, ICondition condition) {
        String message = TextUtils.format("no_more_found_from", condition.toString(), this.getFindFromText(start));
        UITools.informationMessage(Controller.getCurrentController().getViewController().getCurrentRootComponent(), message);
    }

    public String getFindFromText(NodeModel node) {
        String plainNodeText = node.toString().replaceAll("\n", " ");
        return plainNodeText.length() <= 30 ? plainNodeText : plainNodeText.substring(0, 30) + "...";
    }

    public AFreeplaneAction getFindNextAction() {
        return this.findNextAction;
    }

    public AFreeplaneAction getFindPreviousAction() {
        return this.findPreviousAction;
    }

    private class FindPreviousAction
    extends AFreeplaneAction {
        FindPreviousAction() {
            super("FindPreviousAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAction.this.findNext(MapController.Direction.BACK);
        }
    }

    private class FindNextAction
    extends AFreeplaneAction {
        FindNextAction() {
            super("FindNextAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindAction.this.findNext(MapController.Direction.FORWARD);
        }
    }
}

