/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.icon.HierarchicalIcons;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class AccumulatedIcons
implements IExtension {
    private final TreeSet<UIIcon> childIcons;
    private final Collection<? extends UIIcon> ownIcons;

    AccumulatedIcons(Collection<? extends UIIcon> ownIcons) {
        this.ownIcons = ownIcons;
        this.childIcons = new TreeSet();
    }

    public Collection<UIIcon> getAccumulatedIcons() {
        return this.childIcons;
    }

    private void addAccumulatedIconsToTreeSet(NodeModel child) {
        IconController iconController = IconController.getController();
        this.childIcons.addAll(iconController.getIcons(child));
        AccumulatedIcons icons = child.getExtension(AccumulatedIcons.class);
        if (icons == null) {
            return;
        }
        this.childIcons.addAll(icons.childIcons);
    }

    public static boolean setStyleCheckForChange(NodeModel node, HierarchicalIcons.Mode mode) {
        Collection<MindIcon> ownIcons = IconController.getController().getIcons(node);
        AccumulatedIcons iconSet = new AccumulatedIcons(ownIcons);
        boolean first = true;
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            if (first || mode.equals((Object)HierarchicalIcons.Mode.OR)) {
                iconSet.addAccumulatedIconsToTreeSet(child);
            } else {
                AccumulatedIcons iconSet2 = new AccumulatedIcons(Collections.EMPTY_SET);
                iconSet2.addAccumulatedIconsToTreeSet(child);
                iconSet.childIcons.retainAll(iconSet2.childIcons);
                if (iconSet.ownIcons.isEmpty() && iconSet.childIcons.isEmpty()) break;
            }
            first = false;
        }
        iconSet.childIcons.removeAll(ownIcons);
        AccumulatedIcons oldSet = !iconSet.ownIcons.isEmpty() || !iconSet.childIcons.isEmpty() ? (AccumulatedIcons)node.putExtension(iconSet) : node.removeExtension(AccumulatedIcons.class);
        if (iconSet.equals(oldSet) || iconSet.ownIcons.isEmpty() && iconSet.childIcons.isEmpty() && oldSet == null) {
            return false;
        }
        Controller.getCurrentModeController().getMapController().delayedNodeRefresh(node, "hierarchical_icons", null, null);
        return true;
    }

    public int hashCode() {
        return this.childIcons.hashCode() + this.ownIcons.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AccumulatedIcons) {
            AccumulatedIcons ai = (AccumulatedIcons)obj;
            return this.ownIcons.equals(ai.ownIcons) && this.childIcons.equals(ai.childIcons);
        }
        return false;
    }
}

