/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IReadCompletionListener;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.xml.TreeXmlReader;
import org.freeplane.core.io.xml.TreeXmlWriter;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.link.ArrowType;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.url.MapVersionInterpreter;
import org.freeplane.n3.nanoxml.XMLElement;

public class LinkBuilder
implements IElementDOMHandler,
IReadCompletionListener {
    private static final int FREEPLANE_VERSION_WITH_CURVED_LOOPED_CONNECTORS = 3;
    private static final String FORMAT_AS_HYPERLINK = "FORMAT_AS_HYPERLINK";
    private static final String LINK = "LINK";
    private final HashSet<NodeLinkModel> processedLinks;
    private final LinkController linkController;

    public LinkBuilder(LinkController linkController) {
        this.linkController = linkController;
        this.processedLinks = new HashSet();
    }

    protected NodeLinkModel createArrowLink(NodeModel source, String targetID) {
        return new ConnectorModel(source, targetID, this.linkController.getStandardConnectorColor(), this.linkController.getStandardConnectorAlpha(), this.linkController.getStandardConnectorShape(), this.linkController.getStandardConnectorWidth(), this.linkController.getStandardLabelFontFamily(), this.linkController.getStandardLabelFontSize());
    }

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals("arrowlink")) {
            return this.createArrowLink((NodeModel)parent, null);
        }
        return null;
    }

    @Override
    public void readingCompleted(NodeModel topNode, Map<String, String> newIds) {
        for (NodeLinkModel arrowLink : this.processedLinks) {
            String targetID;
            String id = arrowLink.getTargetID();
            String newId = newIds.get(id);
            String string = targetID = newId != null ? newId : id;
            if (targetID == null) {
                new NullPointerException().printStackTrace();
                continue;
            }
            arrowLink.setTargetID(targetID);
            NodeModel source = arrowLink.getSource();
            NodeLinks.createLinkExtension(source).addArrowlink(arrowLink);
        }
        this.processedLinks.clear();
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler("node", LINK, new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LinkBuilder.this.linkController.loadLink(node, value);
                Collection<NodeLinkModel> links = NodeLinks.getLinks(node);
                LinkBuilder.this.processedLinks.addAll(links);
            }
        });
        IAttributeHandler hyperlinkHandler = new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                LinkBuilder.this.linkController.loadLinkFormat(node, Boolean.parseBoolean(value));
            }
        };
        reader.addAttributeHandler("node", FORMAT_AS_HYPERLINK, hyperlinkHandler);
        reader.addAttributeHandler("stylenode", FORMAT_AS_HYPERLINK, hyperlinkHandler);
        reader.addAttributeHandler("arrowlink", "EDGE_LIKE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setShape(ConnectorModel.Shape.EDGE_LIKE);
            }
        });
        reader.addAttributeHandler("arrowlink", "SHAPE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setShape(ConnectorModel.Shape.valueOf(value));
            }
        });
        reader.addAttributeHandler("arrowlink", "DASH", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                String[] split = value.split(" ");
                int[] dash = new int[split.length];
                int i = 0;
                for (String s : split) {
                    dash[i++] = Integer.parseInt(s);
                }
                arrowLink.setDash(dash);
            }
        });
        reader.addAttributeHandler("arrowlink", "DESTINATION", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setTargetID(value);
                LinkBuilder.this.processedLinks.add(arrowLink);
            }
        });
        reader.addAttributeHandler("arrowlink", "SOURCE_LABEL", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setSourceLabel(value.toString());
            }
        });
        reader.addAttributeHandler("arrowlink", "MIDDLE_LABEL", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setMiddleLabel(value.toString());
            }
        });
        reader.addAttributeHandler("arrowlink", "TARGET_LABEL", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setTargetLabel(value.toString());
            }
        });
        reader.addAttributeHandler("arrowlink", "STARTINCLINATION", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setStartInclination(TreeXmlReader.xmlToPoint(value.toString()));
            }
        });
        reader.addAttributeHandler("arrowlink", "ENDINCLINATION", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setEndInclination(TreeXmlReader.xmlToPoint(value.toString()));
            }
        });
        reader.addAttributeHandler("arrowlink", "STARTARROW", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setStartArrow(ArrowType.valueOf(value.toUpperCase(Locale.ENGLISH)));
            }
        });
        reader.addAttributeHandler("arrowlink", "ENDARROW", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setEndArrow(ArrowType.valueOf(value.toUpperCase(Locale.ENGLISH)));
            }
        });
        reader.addAttributeHandler("arrowlink", "WIDTH", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setWidth(Integer.parseInt(value.toString()));
            }
        });
        reader.addAttributeHandler("arrowlink", "FONT_FAMILY", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setLabelFontFamily(value.toString());
            }
        });
        reader.addAttributeHandler("arrowlink", "FONT_SIZE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                ConnectorModel arrowLink = (ConnectorModel)userObject;
                arrowLink.setLabelFontSize(Integer.parseInt(value.toString()));
            }
        });
    }

    @Override
    public void endElement(Object parent, String tag, Object element, XMLElement dom) {
        ConnectorModel arrowLink = (ConnectorModel)element;
        String color = dom.getAttribute("COLOR", null);
        String transparency = dom.getAttribute("TRANSPARENCY", null);
        if (color != null) {
            arrowLink.setColor(ColorUtils.stringToColor(color));
            if (transparency == null) {
                arrowLink.setAlpha(255);
            }
        } else {
            arrowLink.setColor(this.linkController.getStandardConnectorColor());
        }
        if (transparency != null) {
            arrowLink.setAlpha(Integer.parseInt(transparency));
        } else if (color == null) {
            arrowLink.setAlpha(this.linkController.getStandardConnectorAlpha());
        }
        this.fixSelfLoopedConnectorShape(arrowLink);
    }

    private void fixSelfLoopedConnectorShape(ConnectorModel connector) {
        if (connector.isSelfLink() && ConnectorModel.Shape.CUBIC_CURVE.equals((Object)connector.getShape()) && MapVersionInterpreter.isOlderThan(connector.getSource().getMap(), 3)) {
            connector.setShape(ConnectorModel.Shape.LINE);
        }
    }

    void registerBy(ReadManager reader) {
        reader.addElementHandler("arrowlink", this);
        this.registerAttributeHandlers(reader);
        reader.addReadCompletionListener(this);
    }

    public void save(ITreeWriter writer, ConnectorModel model) throws IOException {
        String endArrow;
        String startArrow;
        Point endInclination;
        Point startInclination;
        String middleLabel;
        String targetLabel;
        String sourceLabel;
        NodeModel target = model.getTarget();
        if (target == null) {
            return;
        }
        XMLElement arrowLink = new XMLElement();
        arrowLink.setName("arrowlink");
        ConnectorModel.Shape shape = model.getShape();
        arrowLink.setAttribute("SHAPE", shape.toString());
        Color color = model.getColor();
        arrowLink.setAttribute("COLOR", ColorUtils.colorToString(color));
        int width = model.getWidth();
        arrowLink.setAttribute("WIDTH", Integer.toString(width));
        int alpha = model.getAlpha();
        arrowLink.setAttribute("TRANSPARENCY", Integer.toString(alpha));
        int[] dash = model.getDash();
        if (dash != null) {
            StringBuilder sb = null;
            for (int i : dash) {
                if (sb == null) {
                    sb = new StringBuilder(dash.length * 4);
                } else {
                    sb.append(' ');
                }
                sb.append(i);
            }
            if (sb != null) {
                arrowLink.setAttribute("DASH", sb.toString());
            }
        }
        int fontSize = model.getLabelFontSize();
        arrowLink.setAttribute("FONT_SIZE", Integer.toString(fontSize));
        String fontFamily = model.getLabelFontFamily();
        arrowLink.setAttribute("FONT_FAMILY", fontFamily);
        String destinationLabel = target.createID();
        if (destinationLabel != null) {
            arrowLink.setAttribute("DESTINATION", destinationLabel);
        }
        if ((sourceLabel = model.getSourceLabel()) != null) {
            arrowLink.setAttribute("SOURCE_LABEL", sourceLabel);
        }
        if ((targetLabel = model.getTargetLabel()) != null) {
            arrowLink.setAttribute("TARGET_LABEL", targetLabel);
        }
        if ((middleLabel = model.getMiddleLabel()) != null) {
            arrowLink.setAttribute("MIDDLE_LABEL", middleLabel);
        }
        if ((startInclination = model.getStartInclination()) != null) {
            arrowLink.setAttribute("STARTINCLINATION", TreeXmlWriter.PointToXml(startInclination));
        }
        if ((endInclination = model.getEndInclination()) != null) {
            arrowLink.setAttribute("ENDINCLINATION", TreeXmlWriter.PointToXml(endInclination));
        }
        if ((startArrow = model.getStartArrow().toString()) != null) {
            arrowLink.setAttribute("STARTARROW", startArrow);
        }
        if ((endArrow = model.getEndArrow().toString()) != null) {
            arrowLink.setAttribute("ENDARROW", endArrow);
        }
        writer.addElement((Object)model, arrowLink);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    public void writeAttributes(ITreeWriter writer, NodeModel node) {
        NodeLinks links = node.getExtension(NodeLinks.class);
        if (links != null) {
            Boolean formatNodeAsHyperlink;
            URI link = links.getHyperLink(node);
            if (link != null) {
                String string = link.toString();
                if (string.startsWith("#") && node.getMap().getNodeForID(string.substring(1)) == null) {
                    return;
                }
                writer.addAttribute(LINK, string);
            }
            if ((formatNodeAsHyperlink = links.formatNodeAsHyperlink()) != null) {
                writer.addAttribute(FORMAT_AS_HYPERLINK, formatNodeAsHyperlink.toString());
            }
        }
    }

    public void writeContent(ITreeWriter writer, NodeModel node) throws IOException {
        NodeLinks links = node.getExtension(NodeLinks.class);
        if (links != null) {
            for (NodeLinkModel linkModel : links.getLinks()) {
                ConnectorModel arrowLinkModel;
                boolean linkNotWrittenBefore;
                if (!(linkModel instanceof ConnectorModel) || !(linkNotWrittenBefore = !this.processedLinks.contains(linkModel)) || (arrowLinkModel = (ConnectorModel)linkModel.cloneForSource(node)) == null) continue;
                this.save(writer, arrowLinkModel);
                this.processedLinks.add(linkModel);
            }
        }
    }
}

