/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.List;
import org.freeplane.features.map.CloneEncryptedNodeException;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.NodeModel;

class Cloner {
    private final NodeModel nodeModel;

    public Cloner(NodeModel nodeModel) {
        this.nodeModel = nodeModel;
    }

    public NodeModel cloneTree() {
        NodeModel clone = this.cloneStructure(this.nodeModel);
        return clone;
    }

    private NodeModel cloneStructure(NodeModel node) {
        if (node.containsExtension(EncryptionModel.class)) {
            throw new CloneEncryptedNodeException();
        }
        NodeModel clone = node.cloneNode(NodeModel.CloneType.TREE);
        List<NodeModel> cloneChildren = clone.getChildrenInternal();
        for (NodeModel childNode : node.getChildrenInternal()) {
            NodeModel childClone = this.cloneStructure(childNode);
            childClone.setParent(clone);
            cloneChildren.add(childClone);
        }
        return clone;
    }
}

