/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.UnknownElementWriter;
import org.freeplane.core.io.UnknownElements;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.DelayedRunner;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.CloneConditionController;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.GotoNodeAction;
import org.freeplane.features.map.HideChildSubtree;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeLevelConditionController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.ShowNextChildAction;
import org.freeplane.features.map.ToggleChildrenFoldedAction;
import org.freeplane.features.map.ToggleFoldedAction;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.SelectionController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.UrlManager;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class MapController
extends SelectionController
implements IExtension {
    private final Collection<IMapChangeListener> mapChangeListeners;
    private final Collection<IMapLifeCycleListener> mapLifeCycleListeners;
    private final MapReader mapReader;
    private final MapWriter mapWriter;
    private final ModeController modeController;
    final LinkedList<INodeChangeListener> nodeChangeListeners;
    private final ReadManager readManager;
    private final WriteManager writeManager;
    private final ConcurrentHashMap<NodeRefreshKey, NodeRefreshValue> nodesToRefresh = new ConcurrentHashMap();
    private final ActionEnablerOnChange actionEnablerOnChange;
    private final ActionSelectorOnChange actionSelectorOnChange;

    private static boolean hasValidSelection() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        return selection != null && selection.getSelected() != null;
    }

    public static void install() {
        ConditionFactory conditionFactory = FilterController.getCurrentFilterController().getConditionFactory();
        conditionFactory.addConditionController(80, new NodeLevelConditionController());
        conditionFactory.addConditionController(75, new CloneConditionController());
    }

    public void addListenerForAction(AFreeplaneAction action) {
        if (action.checkEnabledOnChange()) {
            this.actionEnablerOnChange.add(action);
        }
        if (action.checkSelectionOnChange()) {
            this.actionSelectorOnChange.add(action);
        }
    }

    public void removeListenerForAction(AFreeplaneAction action) {
        if (action.checkEnabledOnChange()) {
            this.actionEnablerOnChange.remove(action);
        }
        if (action.checkSelectionOnChange()) {
            this.actionSelectorOnChange.remove(action);
        }
    }

    public MapController(ModeController modeController) {
        modeController.setMapController(this);
        this.modeController = modeController;
        this.mapLifeCycleListeners = new LinkedList<IMapLifeCycleListener>();
        this.addMapLifeCycleListener(modeController.getController());
        this.writeManager = new WriteManager();
        this.mapWriter = new MapWriter(this);
        this.readManager = new ReadManager();
        this.mapReader = new MapReader(this.readManager);
        this.readManager.addElementHandler("map", this.mapReader);
        this.readManager.addAttributeHandler("map", "version", new IAttributeHandler(){

            @Override
            public void setAttribute(Object node, String value) {
            }
        });
        this.readManager.addAttributeHandler("map", "dialect", new IAttributeHandler(){

            @Override
            public void setAttribute(Object node, String value) {
            }
        });
        this.writeManager.addElementWriter("map", this.mapWriter);
        this.writeManager.addAttributeWriter("map", this.mapWriter);
        UnknownElementWriter unknownElementWriter = new UnknownElementWriter();
        this.writeManager.addExtensionAttributeWriter(UnknownElements.class, unknownElementWriter);
        this.writeManager.addExtensionElementWriter(UnknownElements.class, unknownElementWriter);
        this.mapChangeListeners = new LinkedList<IMapChangeListener>();
        this.nodeChangeListeners = new LinkedList();
        this.actionEnablerOnChange = new ActionEnablerOnChange(modeController);
        this.actionSelectorOnChange = new ActionSelectorOnChange(modeController);
        this.addNodeSelectionListener(this.actionEnablerOnChange);
        this.addNodeChangeListener(this.actionEnablerOnChange);
        this.addMapChangeListener(this.actionEnablerOnChange);
        this.addNodeSelectionListener(this.actionSelectorOnChange);
        this.addNodeChangeListener(this.actionSelectorOnChange);
        this.addMapChangeListener(this.actionSelectorOnChange);
        this.createActions(modeController);
    }

    public void setFoldedAndScroll(final NodeModel node, boolean folded) {
        if (node.isFolded() != folded) {
            this.setFolded(node, folded);
            if (!folded && ResourceController.getResourceController().getBooleanProperty("scrollOnUnfold")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Controller.getCurrentController().getSelection().scrollNodeTreeToVisible(node);
                    }
                });
            }
        }
    }

    public void setFolded(NodeModel node, boolean folded) {
        if (node == null) {
            throw new IllegalArgumentException("setFolded was called with a null node.");
        }
        if (node.getChildCount() == 0) {
            return;
        }
        boolean unfold = !folded;
        boolean childShown = this.unfoldHiddenChildren(node);
        boolean mapChanged = false;
        if (unfold && this.unfoldInvisibleChildren(node, true)) {
            mapChanged = true;
        }
        if (!node.isRoot() || !folded) {
            if (node.isFolded() != folded) {
                mapChanged = true;
            }
            this.setFoldingState(node, folded);
        }
        if (mapChanged) {
            this.fireFoldingChanged(node);
        }
        if (childShown) {
            this.fireNodeUnfold(node);
        }
    }

    protected void setFoldingState(NodeModel node, boolean folded) {
        node.setFolded(folded);
    }

    public boolean showNextChild(NodeModel node) {
        if (node.getChildCount() == 0) {
            return false;
        }
        boolean unfold = Controller.getCurrentController().getMapViewManager().isFoldedOnCurrentView(node);
        if (unfold) {
            for (NodeModel child : this.childrenUnfolded(node)) {
                child.addExtension(HideChildSubtree.instance);
            }
            this.setFoldingState(node, false);
        }
        boolean childMadeVisible = false;
        for (NodeModel child : this.childrenUnfolded(node)) {
            if (!child.removeExtension(HideChildSubtree.instance) || !child.hasVisibleContent() && !this.unfoldInvisibleChildren(child, true)) continue;
            childMadeVisible = true;
            break;
        }
        if (childMadeVisible) {
            this.fireNodeUnfold(node);
        }
        return childMadeVisible;
    }

    private void fireNodeUnfold(NodeModel node) {
        node.fireNodeChanged(new NodeChangeEvent(node, HideChildSubtree.instance, null, null));
    }

    public boolean hasHiddenChildren(NodeModel node) {
        for (NodeModel child : this.childrenUnfolded(node)) {
            if (!child.containsExtension(HideChildSubtree.class)) continue;
            return true;
        }
        return false;
    }

    private void fireFoldingChanged(NodeModel node) {
        if (this.isFoldingPersistentAlways()) {
            MapModel map = node.getMap();
            this.setSaved(map, false);
        }
    }

    private boolean isFoldingPersistentAlways() {
        ResourceController resourceController = ResourceController.getResourceController();
        return resourceController.getProperty("save_folding").equals("always_save_folding");
    }

    protected boolean unfoldHiddenChildren(NodeModel node) {
        List<NodeModel> children = this.childrenFolded(node);
        boolean changed = false;
        for (NodeModel child : children) {
            if (child.removeExtension(HideChildSubtree.class) == null) continue;
            changed = true;
        }
        return changed;
    }

    private boolean unfoldInvisibleChildren(NodeModel node, boolean reportUnfolded) {
        boolean visibleFound = false;
        boolean unfolded = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            NodeModel child = node.getChildAt(i);
            if (child.hasVisibleContent()) {
                visibleFound = true;
                continue;
            }
            if (!this.unfoldInvisibleChildren(child, false) || !child.isFolded()) continue;
            unfolded = true;
            visibleFound = true;
            this.setFoldingState(node, false);
        }
        if (reportUnfolded) {
            return unfolded;
        }
        return visibleFound;
    }

    public void addMapChangeListener(IMapChangeListener listener) {
        this.mapChangeListeners.add(listener);
    }

    public void addMapLifeCycleListener(IMapLifeCycleListener listener) {
        this.mapLifeCycleListeners.add(listener);
    }

    public void addNodeChangeListener(INodeChangeListener listener) {
        this.nodeChangeListeners.add(listener);
    }

    public void centerNode(NodeModel node) {
        Controller.getCurrentController().getSelection().centerNode(node);
    }

    public List<NodeModel> childrenFolded(NodeModel node) {
        if (node.isFolded()) {
            List<NodeModel> empty = Collections.emptyList();
            return empty;
        }
        return this.childrenUnfolded(node);
    }

    public List<NodeModel> childrenUnfolded(NodeModel node) {
        EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        if (encryptionModel != null && !encryptionModel.isAccessible()) {
            List<NodeModel> empty = Collections.emptyList();
            return empty;
        }
        return node.getChildren();
    }

    public boolean close(MapModel map) {
        this.closeWithoutSaving(map);
        return true;
    }

    public boolean closeAllMaps() {
        Controller controller = this.getModeController().getController();
        MapModel map = controller.getMap();
        while (map != null) {
            boolean closingNotCancelled = this.close(map);
            if (!closingNotCancelled) {
                return false;
            }
            map = controller.getMap();
        }
        return true;
    }

    public void closeWithoutSaving(MapModel map) {
        this.fireMapRemoved(map);
        map.destroy();
    }

    private void createActions(ModeController modeController) {
        modeController.addAction(new ToggleFoldedAction());
        modeController.addAction(new ToggleChildrenFoldedAction());
        modeController.addAction(new ShowNextChildAction());
        modeController.addAction(new GotoNodeAction());
    }

    public void displayNode(NodeModel node) {
        this.displayNode(node, null);
    }

    public void displayNode(NodeModel node, ArrayList<NodeModel> nodesUnfoldedByDisplay) {
        if (!node.hasVisibleContent()) {
            node.getFilterInfo().reset();
            this.nodeRefresh(node);
        }
        NodeModel[] path = node.getPathToRoot();
        for (int i = 0; i < path.length - 1; ++i) {
            NodeModel nodeOnPath = path[i];
            if (nodesUnfoldedByDisplay != null && this.isFolded(nodeOnPath)) {
                nodesUnfoldedByDisplay.add(nodeOnPath);
            }
            this.setFolded(nodeOnPath, false);
        }
    }

    public void fireMapChanged(MapChangeEvent event) {
        IMapChangeListener[] list;
        MapModel map = event.getMap();
        if (map != null) {
            this.setSaved(map, false);
        }
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.mapChanged(event);
        }
        if (map != null) {
            map.fireMapChangeEvent(event);
        }
    }

    public void fireMapCreated(MapModel map) {
        IMapLifeCycleListener[] list;
        for (IMapLifeCycleListener next : list = this.mapLifeCycleListeners.toArray(new IMapLifeCycleListener[0])) {
            next.onCreate(map);
        }
    }

    protected void fireMapRemoved(MapModel map) {
        IMapLifeCycleListener[] list;
        for (IMapLifeCycleListener next : list = this.mapLifeCycleListeners.toArray(new IMapLifeCycleListener[0])) {
            next.onRemove(map);
        }
    }

    private void fireNodeChanged(NodeModel node, NodeChangeEvent nodeChangeEvent) {
        INodeChangeListener[] nodeChangeListeners = this.nodeChangeListeners.toArray(new INodeChangeListener[0]);
        node.fireNodeChanged(nodeChangeListeners, nodeChangeEvent);
    }

    protected void fireNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        IMapChangeListener[] list;
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.onNodeDeleted(nodeDeletionEvent);
        }
        NodeModel node = nodeDeletionEvent.node;
        node.getMap().unregistryNodes(node);
    }

    protected void fireNodeInserted(NodeModel parent, NodeModel child, int index) {
        IMapChangeListener[] list;
        parent.getMap().registryNodeRecursive(child);
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.onNodeInserted(parent, child, index);
        }
    }

    protected void fireNodeMoved(NodeMoveEvent nodeMoveEvent) {
        IMapChangeListener[] list;
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.onNodeMoved(nodeMoveEvent);
        }
    }

    protected void firePreNodeMoved(NodeMoveEvent nodeMoveEvent) {
        IMapChangeListener[] list;
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.onPreNodeMoved(nodeMoveEvent);
        }
    }

    protected void firePreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
        IMapChangeListener[] list;
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.onPreNodeDelete(nodeDeletionEvent);
        }
    }

    public void getFilteredXml(MapModel map, Writer fileout, MapWriter.Mode mode, boolean forceFormat) throws IOException {
        this.getMapWriter().writeMapAsXml(map, fileout, mode, false, forceFormat);
    }

    private Boolean getCommonFoldingState(Collection<NodeModel> list) {
        Boolean state = null;
        for (NodeModel node : list) {
            if (node.getChildCount() == 0) continue;
            if (state == null) {
                state = this.canBeUnfolded(node);
                continue;
            }
            if (this.canBeUnfolded(node) == state.booleanValue()) continue;
            return null;
        }
        return state;
    }

    private boolean canBeUnfolded(NodeModel node) {
        return Controller.getCurrentController().getMapViewManager().isFoldedOnCurrentView(node) || this.hasHiddenChildren(node);
    }

    public MapReader getMapReader() {
        return this.mapReader;
    }

    public MapWriter getMapWriter() {
        return this.mapWriter;
    }

    public NodeModel getNodeFromID(String nodeID) {
        MapModel map = Controller.getCurrentController().getMap();
        if (map == null) {
            return null;
        }
        NodeModel node = map.getNodeForID(nodeID);
        return node;
    }

    public String getNodeID(NodeModel selected) {
        return selected.createID();
    }

    public ReadManager getReadManager() {
        return this.readManager;
    }

    public NodeModel getRootNode() {
        MapModel map = Controller.getCurrentController().getMap();
        return map.getRootNode();
    }

    public NodeModel getSelectedNode() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            return selection.getSelected();
        }
        return null;
    }

    public Collection<NodeModel> getSelectedNodes() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            List<NodeModel> list = Collections.emptyList();
            return list;
        }
        return selection.getSelection();
    }

    public WriteManager getWriteManager() {
        return this.writeManager;
    }

    public boolean hasChildren(NodeModel node) {
        EncryptionModel encryptionModel = EncryptionModel.getModel(node);
        if (encryptionModel != null && !encryptionModel.isAccessible()) {
            return false;
        }
        return node.hasChildren();
    }

    public boolean hasFoldedStrictDescendant(NodeModel node) {
        for (NodeModel child : this.childrenUnfolded(node)) {
            if (!this.isFolded(child) && !this.hasFoldedStrictDescendant(child)) continue;
            return true;
        }
        return false;
    }

    public void insertNodeIntoWithoutUndo(NodeModel newChild, NodeModel parent) {
        this.insertNodeIntoWithoutUndo(newChild, parent, parent.getChildCount());
    }

    public void insertNodeIntoWithoutUndo(NodeModel newNode, NodeModel parent, int index) {
        if (parent.getParentNode() != null) {
            newNode.setLeft(parent.isLeft());
        }
        parent.insert(newNode, index);
        this.fireNodeInserted(parent, newNode, index);
    }

    public boolean isFolded(NodeModel node) {
        return node.isFolded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean newMap(URL url) throws FileNotFoundException, XMLParseException, IOException, URISyntaxException, XMLException {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (mapViewManager.tryToChangeToMapView(url)) {
            return false;
        }
        try {
            if (AddOnsController.getController().installIfAppropriate(url)) {
                boolean bl = false;
                return bl;
            }
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            MapModel newModel = new MapModel();
            UrlManager.getController().loadCatchExceptions(url, newModel);
            newModel.setReadOnly(true);
            newModel.setSaved(true);
            this.fireMapCreated(newModel);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    public void openMapSelectReferencedNode(URL url) throws FileNotFoundException, XMLParseException, IOException, URISyntaxException, XMLException, MalformedURLException {
        String nodeReference = url.getRef();
        if (nodeReference != null) {
            this.newMap(new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath()));
            this.select(this.getNodeFromID(nodeReference));
        } else {
            this.newMap(url);
        }
    }

    public void newMapView(MapModel mapModel) {
        Controller.getCurrentController().getMapViewManager().newMapView(mapModel, Controller.getCurrentModeController());
    }

    public MapModel newMap() {
        MapModel newModel = this.newModel();
        this.fireMapCreated(newModel);
        this.newMapView(newModel);
        return newModel;
    }

    public MapModel newModel() {
        MapModel mindMapMapModel = new MapModel();
        mindMapMapModel.createNewRoot();
        this.fireMapCreated(mindMapMapModel);
        return mindMapMapModel;
    }

    public NodeModel newNode(Object userObject, MapModel map) {
        return new NodeModel(userObject, map);
    }

    @Deprecated
    public void nodeChanged(NodeModel node) {
        this.nodeChanged(node, NodeModel.UNKNOWN_PROPERTY, null, null);
    }

    public void nodeChanged(NodeModel node, Object property, Object oldValue, Object newValue) {
        this.setSaved(node.getMap(), false);
        this.nodeRefresh(node, property, oldValue, newValue, true);
    }

    @Deprecated
    public void nodeRefresh(NodeModel node) {
        this.nodeRefresh(node, NodeModel.UNKNOWN_PROPERTY, null, null);
    }

    public void nodeRefresh(NodeModel node, Object property, Object oldValue, Object newValue) {
        this.nodeRefresh(node, property, oldValue, newValue, false);
    }

    private void nodeRefresh(final NodeModel node, Object property, Object oldValue, Object newValue, boolean isUpdate) {
        HistoryInformationModel historyInformation;
        if (this.mapReader.isMapLoadingInProcess()) {
            return;
        }
        if (isUpdate && !Controller.getCurrentModeController().isUndoAction() && (historyInformation = node.getHistoryInformation()) != null) {
            IActor historyActor = new IActor(){
                private final Date lastModifiedAt;
                private final Date now;
                {
                    this.lastModifiedAt = historyInformation.getLastModifiedAt();
                    this.now = new Date();
                }

                @Override
                public void undo() {
                    this.setDate(historyInformation, this.lastModifiedAt);
                }

                private void setDate(HistoryInformationModel historyInformation2, Date lastModifiedAt) {
                    Date oldLastModifiedAt = historyInformation2.getLastModifiedAt();
                    historyInformation2.setLastModifiedAt(lastModifiedAt);
                    NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(node, HistoryInformationModel.class, oldLastModifiedAt, lastModifiedAt);
                    MapController.this.fireNodeChanged(node, nodeChangeEvent);
                }

                @Override
                public String getDescription() {
                    return null;
                }

                @Override
                public void act() {
                    this.setDate(historyInformation, this.now);
                }
            };
            Controller.getCurrentModeController().execute(historyActor, node.getMap());
        }
        NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(node, property, oldValue, newValue);
        this.fireNodeChanged(node, nodeChangeEvent);
    }

    public void delayedNodeRefresh(NodeModel node, Object property, Object oldValue, Object newValue) {
        boolean startThread = this.nodesToRefresh.isEmpty();
        NodeRefreshKey key = new NodeRefreshKey(node, property);
        NodeRefreshValue value = new NodeRefreshValue(Controller.getCurrentModeController(), oldValue, newValue);
        NodeRefreshValue old = this.nodesToRefresh.put(key, value);
        if (old != null && old.newValue != value.newValue) {
            old.newValue = value.newValue;
            this.nodesToRefresh.put(key, old);
        }
        if (startThread) {
            Runnable refresher = new Runnable(){

                @Override
                public void run() {
                    ModeController currentModeController = Controller.getCurrentModeController();
                    Iterator it = MapController.this.nodesToRefresh.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        NodeRefreshValue info = (NodeRefreshValue)entry.getValue();
                        if (info.controller == currentModeController) {
                            NodeRefreshKey key = (NodeRefreshKey)entry.getKey();
                            currentModeController.getMapController().nodeRefresh(key.node, key.property, info.oldValue, info.newValue);
                        }
                        it.remove();
                    }
                }
            };
            EventQueue.invokeLater(refresher);
        }
    }

    public void removeMapChangeListener(IMapChangeListener listener) {
        this.mapChangeListeners.remove(listener);
    }

    public void removeMapLifeCycleListener(IMapLifeCycleListener listener) {
        this.mapLifeCycleListeners.remove(listener);
    }

    void removeNodeChangeListener(Class<? extends AController.IActionOnChange> clazz, Action action) {
        Iterator iterator = this.nodeChangeListeners.iterator();
        while (iterator.hasNext()) {
            INodeChangeListener next = (INodeChangeListener)iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    void removeMapChangeListener(Class<? extends AController.IActionOnChange> clazz, Action action) {
        Iterator<IMapChangeListener> iterator = this.mapChangeListeners.iterator();
        while (iterator.hasNext()) {
            IMapChangeListener next = iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    public void removeNodeChangeListener(INodeChangeListener listener) {
        this.nodeChangeListeners.remove(listener);
    }

    void removeNodeSelectionListener(Class<? extends AController.IActionOnChange> clazz, Action action) {
        Iterator iterator = this.getNodeSelectionListeners().iterator();
        while (iterator.hasNext()) {
            INodeSelectionListener next = (INodeSelectionListener)iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    public Collection<IMapChangeListener> getMapChangeListeners() {
        return Collections.unmodifiableCollection(this.mapChangeListeners);
    }

    public Collection<IMapLifeCycleListener> getMapLifeCycleListeners() {
        return Collections.unmodifiableCollection(this.mapLifeCycleListeners);
    }

    public Collection<INodeChangeListener> getNodeChangeListeners() {
        return Collections.unmodifiableCollection(this.nodeChangeListeners);
    }

    public void select(NodeModel node) {
        Controller controller;
        MapModel map = node.getMap();
        if (!map.equals((controller = Controller.getCurrentController()).getMap())) {
            controller.getMapViewManager().changeToMap(map);
        }
        this.displayNode(node);
        controller.getSelection().selectAsTheOnlyOneSelected(node);
    }

    public void selectMultipleNodes(NodeModel focussed, Collection<NodeModel> selecteds) {
        for (NodeModel node : selecteds) {
            this.displayNode(node);
        }
        this.select(focussed);
        for (NodeModel node : selecteds) {
            Controller.getCurrentController().getSelection().makeTheSelected(node);
        }
    }

    public void setSaved(MapModel mapModel, boolean saved) {
        mapModel.setSaved(saved);
    }

    public void sortNodesByDepth(List<NodeModel> collection) {
        Collections.sort(collection, new NodesDepthComparator());
    }

    public void toggleFolded(Collection<NodeModel> collection) {
        NodeModel[] nodes;
        Boolean isFolded = this.getCommonFoldingState(collection);
        boolean shouldBeFolded = isFolded != null ? !isFolded.booleanValue() : true;
        for (NodeModel node : nodes = collection.toArray(new NodeModel[0])) {
            this.setFolded(node, shouldBeFolded);
        }
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public void select(String nodeReference) {
        this.select(this.getNodeFromID(nodeReference));
    }

    private static class NodeRefreshValue {
        final ModeController controller;
        Object oldValue;
        Object newValue;

        public NodeRefreshValue(ModeController controller, Object oldValue, Object newValue) {
            this.controller = controller;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }

    private static class NodeRefreshKey {
        final NodeModel node;
        final Object property;

        public NodeRefreshKey(NodeModel node, Object property) {
            this.node = node;
            this.property = property;
        }

        public int hashCode() {
            return this.node.hashCode() + this.propertyHash();
        }

        protected int propertyHash() {
            return this.property != null ? 37 * this.property.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            NodeRefreshKey key2 = (NodeRefreshKey)obj;
            return this.node.equals(key2.node) && (this.property == key2.property || this.property != null && this.property.equals(key2.property));
        }
    }

    private static class NodesDepthComparator
    implements Comparator<NodeModel> {
        @Override
        public int compare(NodeModel n1, NodeModel n2) {
            NodeModel[] path2;
            NodeModel[] path1 = n1.getPathToRoot();
            int depth = path1.length - (path2 = n2.getPathToRoot()).length;
            if (depth > 0) {
                return -1;
            }
            if (depth < 0) {
                return 1;
            }
            if (n1.isRoot()) {
                return 0;
            }
            return n1.getParentNode().getIndex(n1) - n2.getParentNode().getIndex(n2);
        }
    }

    private static class ActionSelectorOnChange
    implements INodeChangeListener,
    INodeSelectionListener,
    IMapChangeListener {
        private final Collection<AFreeplaneAction> actions = new HashSet<AFreeplaneAction>();
        private final DelayedRunner runner;

        public ActionSelectorOnChange(final ModeController modeController) {
            this.runner = new DelayedRunner(new Runnable(){

                @Override
                public void run() {
                    if (modeController == Controller.getCurrentModeController()) {
                        ActionSelectorOnChange.this.setActionsSelectedNow();
                    }
                }
            });
        }

        @Override
        public void nodeChanged(NodeChangeEvent event) {
            if (NodeModel.NodeChangeType.REFRESH.equals(event.getProperty())) {
                return;
            }
            this.setActionsSelected();
        }

        private void setActionsSelected() {
            if (MapController.hasValidSelection()) {
                this.runner.runLater();
            }
        }

        private void setActionsSelectedNow() {
            if (MapController.hasValidSelection()) {
                for (AFreeplaneAction action : this.actions) {
                    action.setSelected();
                }
            }
        }

        @Override
        public void onDeselect(NodeModel node) {
        }

        @Override
        public void onSelect(NodeModel node) {
            this.setActionsSelected();
        }

        @Override
        public void mapChanged(MapChangeEvent event) {
            this.setActionsSelected();
        }

        @Override
        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionsSelected();
        }

        @Override
        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            this.setActionsSelected();
        }

        @Override
        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
            this.setActionsSelected();
        }

        @Override
        public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionsSelected();
        }

        @Override
        public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
            this.setActionsSelected();
        }

        public void add(AFreeplaneAction action) {
            this.actions.add(action);
        }

        public void remove(AFreeplaneAction action) {
            this.actions.remove(action);
        }
    }

    private static class ActionEnablerOnChange
    implements INodeChangeListener,
    INodeSelectionListener,
    IMapChangeListener {
        private final Collection<AFreeplaneAction> actions = new HashSet<AFreeplaneAction>();
        private final DelayedRunner runner;

        public ActionEnablerOnChange(final ModeController modeController) {
            this.runner = new DelayedRunner(new Runnable(){

                @Override
                public void run() {
                    if (modeController == Controller.getCurrentModeController()) {
                        ActionEnablerOnChange.this.setActionsEnabledNow();
                    }
                }
            });
        }

        @Override
        public void nodeChanged(NodeChangeEvent event) {
            this.setActionEnabled();
        }

        @Override
        public void onDeselect(NodeModel node) {
        }

        @Override
        public void onSelect(NodeModel node) {
            this.runner.runLater();
        }

        private void setActionsEnabledNow() {
            if (MapController.hasValidSelection()) {
                for (AFreeplaneAction action : this.actions) {
                    action.setEnabled();
                }
            }
        }

        @Override
        public void mapChanged(MapChangeEvent event) {
            this.setActionEnabled();
        }

        @Override
        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionEnabled();
        }

        @Override
        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            this.setActionEnabled();
        }

        @Override
        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
            this.setActionEnabled();
        }

        @Override
        public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
        }

        @Override
        public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionEnabled();
        }

        private void setActionEnabled() {
            if (MapController.hasValidSelection()) {
                this.runner.runLater();
            }
        }

        public void add(AFreeplaneAction action) {
            this.actions.add(action);
        }

        public void remove(AFreeplaneAction action) {
            this.actions.remove(action);
        }
    }

    public static enum Direction {
        BACK,
        BACK_N_FOLD,
        FORWARD,
        FORWARD_N_FOLD;

    }
}

