/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterInfo;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.CloneEncryptedNodeException;
import org.freeplane.features.map.Cloner;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.DetachedNodeList;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeIconSetModel;
import org.freeplane.features.map.SharedNodeData;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.ui.INodeViewVisitor;

public class NodeModel {
    static final int TREE_CLONE_INDEX = CloneType.TREE.ordinal();
    static final int CONTENT_CLONE_INDEX = CloneType.CONTENT.ordinal();
    private static final boolean ALLOWSCHILDREN = true;
    public static final int LEFT_POSITION = -1;
    public static final String NODE_TEXT = "node_text";
    public static final String NOTE_TEXT = "note_text";
    public static final int RIGHT_POSITION = 1;
    public static final int UNKNOWN_POSITION = 0;
    public static final Object UNKNOWN_PROPERTY = new Object();
    public static final String NODE_ICON = "icon";
    public static final Object HYPERLINK_CHANGED = "hyperlink_changed";
    private final List<NodeModel> children;
    private NodeModel parent;
    private final FilterInfo filterInfo;
    private String id;
    private MapModel map = null;
    private int position = 0;
    private NodeModel preferredChild;
    private Collection<INodeView> views = null;
    private SharedNodeData sharedData;
    private Clones[] clones;

    void setClones(Clones clones) {
        this.clones[clones.getCloneType().ordinal()] = clones;
        for (NodeModel clone : clones) {
            clone.fireNodeChanged(new NodeChangeEvent(this, UNKNOWN_PROPERTY, null, null));
        }
    }

    public Object getUserObject() {
        return this.sharedData.getUserObject();
    }

    public NodeModel(MapModel map) {
        this("", map);
    }

    public NodeModel(Object userObject, MapModel map) {
        this.sharedData = new SharedNodeData();
        this.init(userObject);
        this.map = map;
        this.children = new ArrayList<NodeModel>();
        this.filterInfo = new FilterInfo();
        this.clones = new Clones[]{new DetachedNodeList(this, CloneType.TREE), new DetachedNodeList(this, CloneType.CONTENT)};
    }

    private NodeModel(NodeModel toBeCloned, CloneType cloneType) {
        this.map = toBeCloned.map;
        this.sharedData = toBeCloned.sharedData;
        this.children = new ArrayList<NodeModel>();
        this.filterInfo = new FilterInfo();
        this.clones = new Clones[]{new DetachedNodeList(this, cloneType == CloneType.TREE ? toBeCloned : this, CloneType.TREE), new DetachedNodeList(this, toBeCloned, CloneType.CONTENT)};
    }

    protected void init(Object userObject) {
        this.setUserObject(userObject);
        this.setHistoryInformation(new HistoryInformationModel());
    }

    public void acceptViewVisitor(INodeViewVisitor visitor) {
        if (this.views == null) {
            return;
        }
        for (INodeView view : this.views) {
            visitor.visit(view);
        }
    }

    public void addExtension(IExtension extension) {
        this.getExtensionContainer().addExtension(extension);
    }

    public IExtension putExtension(IExtension extension) {
        return this.getExtensionContainer().putExtension(extension);
    }

    public void addIcon(MindIcon icon) {
        this.getIconModel().addIcon(icon);
        if (this.map != null) {
            this.map.getIconRegistry().addIcon(icon);
        }
    }

    public void addIcon(MindIcon icon, int position) {
        this.getIconModel().addIcon(icon, position);
        this.getMap().getIconRegistry().addIcon(icon);
    }

    public void addViewer(INodeView viewer) {
        this.getViewers().add(viewer);
    }

    public boolean areViewsEmpty() {
        return this.views == null || this.views.isEmpty();
    }

    protected List<NodeModel> getChildrenInternal() {
        return this.children;
    }

    public Enumeration<NodeModel> children() {
        final Iterator<NodeModel> i = this.getChildrenInternal().iterator();
        return new Enumeration<NodeModel>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public NodeModel nextElement() {
                return (NodeModel)i.next();
            }
        };
    }

    public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.getExtensionContainer().containsExtension(clazz);
    }

    public String createID() {
        if (this.id == null) {
            this.id = this.getMap().registryNode(this);
        }
        return this.id;
    }

    public void fireNodeChanged(NodeChangeEvent nodeChangeEvent) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            iterator.next().nodeChanged(nodeChangeEvent);
        }
    }

    private void fireNodeInserted(NodeModel child, int index) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            iterator.next().onNodeInserted(this, child, index);
        }
    }

    private void fireNodeRemoved(NodeModel child, int index) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        NodeDeletionEvent nodeDeletionEvent = new NodeDeletionEvent(this, child, index);
        while (iterator.hasNext()) {
            iterator.next().onNodeDeleted(nodeDeletionEvent);
        }
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public NodeModel getChildAt(int childIndex) {
        return childIndex >= 0 ? this.getChildrenInternal().get(childIndex) : null;
    }

    public int getChildCount() {
        if (this.getChildrenInternal() == null) {
            return 0;
        }
        EncryptionModel encryptionModel = EncryptionModel.getModel(this);
        return encryptionModel == null || encryptionModel.isAccessible() ? this.getChildrenInternal().size() : 0;
    }

    public List<NodeModel> getChildren() {
        List<Object> childrenList = this.getChildrenInternal() != null ? this.getChildrenInternal() : Collections.emptyList();
        return Collections.unmodifiableList(childrenList);
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.getExtensionContainer().getExtension(clazz);
    }

    public Map<Class<? extends IExtension>, IExtension> getSharedExtensions() {
        return this.getExtensionContainer().getExtensions();
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public HistoryInformationModel getHistoryInformation() {
        return this.sharedData.getHistoryInformation();
    }

    public MindIcon getIcon(int position) {
        return this.getIconModel().getIcon(position);
    }

    public List<MindIcon> getIcons() {
        return this.getIconModel().getIcons();
    }

    public String getID() {
        return this.id;
    }

    public int getIndex(NodeModel node) {
        return this.children.indexOf(node);
    }

    public MapModel getMap() {
        return this.map;
    }

    public int getNodeLevel(boolean countHidden) {
        int level = 0;
        for (NodeModel parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!countHidden && !parent.isVisible()) continue;
            ++level;
        }
        return level;
    }

    public NodeModel getParentNode() {
        return this.parent;
    }

    public NodeModel[] getPathToRoot() {
        int i = this.getNodeLevel(true);
        NodeModel[] path = new NodeModel[i + 1];
        NodeModel node = this;
        while (i >= 0) {
            path[i--] = node;
            node = node.getParentNode();
        }
        return path;
    }

    public String getText() {
        String string = "";
        if (this.getUserObject() != null) {
            string = this.getUserObject().toString();
        }
        return string;
    }

    public Collection<INodeView> getViewers() {
        if (this.views == null) {
            this.views = new LinkedList<INodeView>();
        }
        return this.views;
    }

    public final String getXmlText() {
        return this.sharedData.getXmlText();
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public boolean hasID() {
        return this.id != null;
    }

    public void insert(NodeModel child, int index) {
        if (!this.isAccessible()) {
            throw new IllegalArgumentException("Trying to insert nodes into a ciphered node.");
        }
        NodeModel childNode = child;
        if (index < 0) {
            index = this.getChildCount();
            this.children.add(index, child);
        } else {
            this.children.add(index, child);
            this.preferredChild = childNode;
        }
        child.setParent(this);
        this.fireNodeInserted(childNode, this.getIndex(child));
    }

    private boolean isAccessible() {
        EncryptionModel encryptionModel = EncryptionModel.getModel(this);
        return encryptionModel == null || encryptionModel.isAccessible();
    }

    public boolean isDescendantOf(NodeModel node) {
        if (this.parent == null) {
            return false;
        }
        if (node == this.parent) {
            return true;
        }
        return this.parent.isDescendantOf(node);
    }

    public boolean isFolded() {
        return this.sharedData.isFolded();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isLeft() {
        if (this.position == 0 && this.getParentNode() != null) {
            this.setLeft(this.getParentNode().isLeft());
        }
        return this.position == -1;
    }

    public boolean isNewChildLeft() {
        if (!this.isRoot()) {
            return this.isLeft();
        }
        int rightChildrenCount = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getChildAt(i).isLeft()) {
                ++rightChildrenCount;
            }
            if (rightChildrenCount <= this.getChildCount() / 2) continue;
            return true;
        }
        return false;
    }

    public boolean isRoot() {
        return this.getMap().getRootNode() == this;
    }

    public boolean hasVisibleContent() {
        return !this.isHiddenSummary() && this.satisfiesFilter();
    }

    private boolean satisfiesFilter() {
        Filter filter = this.getMap().getFilter();
        return filter == null || filter.isVisible(this);
    }

    public boolean isHiddenSummary() {
        return SummaryNode.isHidden(this);
    }

    public boolean isVisible() {
        return this.isHiddenSummary() || this.satisfiesFilter();
    }

    public void remove(int index) {
        NodeModel child = this.children.get(index);
        if (child == this.preferredChild) {
            this.preferredChild = this.getChildrenInternal().size() > index + 1 ? this.getChildrenInternal().get(index + 1) : (index > 0 ? this.getChildrenInternal().get(index - 1) : null);
        }
        child.setParent(null);
        this.children.remove(index);
        this.fireNodeRemoved(child, index);
    }

    public <T extends IExtension> T removeExtension(Class<T> clazz) {
        return this.getExtensionContainer().removeExtension(clazz);
    }

    public boolean removeExtension(IExtension extension) {
        return this.getExtensionContainer().removeExtension(extension);
    }

    public int removeIcon() {
        return this.getIconModel().removeIcon();
    }

    public int removeIcon(int position) {
        return this.getIconModel().removeIcon(position);
    }

    public void removeViewer(INodeView viewer) {
        this.getViewers().remove(viewer);
    }

    public void setFolded(boolean folded) {
        boolean wasFolded = this.isFolded();
        if (wasFolded != folded) {
            EncryptionModel encryptionModel = EncryptionModel.getModel(this);
            this.sharedData.setFolded(encryptionModel != null && !encryptionModel.isAccessible() || folded && !AlwaysUnfoldedNode.isConnectorNode(this));
        }
        this.fireNodeChanged(new NodeChangeEvent(this, (Object)NodeChangeType.FOLDING, wasFolded, folded));
    }

    public void setHistoryInformation(HistoryInformationModel historyInformation) {
        this.sharedData.setHistoryInformation(historyInformation);
    }

    public void setID(String value) {
        this.id = value;
        this.getMap().registryID(value, this);
    }

    public void setLeft(boolean isLeft) {
        int n = this.position = isLeft ? -1 : 1;
        if (!this.isRoot()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                NodeModel child = this.getChildAt(i);
                if (child.position == this.position) continue;
                child.setLeft(isLeft);
            }
        }
    }

    public void setMap(MapModel map) {
        this.map = map;
        for (NodeModel child : this.getChildrenInternal()) {
            child.setMap(map);
        }
    }

    public void setParent(NodeModel newParent) {
        if (this.parent == null && newParent != null && newParent.isAttached()) {
            this.attach();
        } else if (this.parent != null && this.parent.isAttached() && (newParent == null || !newParent.isAttached())) {
            this.detach();
        }
        this.parent = newParent;
    }

    void attach() {
        this.attachClones();
        for (NodeModel child : this.children) {
            child.attach();
        }
    }

    private void attachClones() {
        for (Clones clonesGroup : this.clones) {
            clonesGroup.attach();
        }
    }

    private void detach() {
        this.detachClones();
        for (NodeModel child : this.children) {
            child.detach();
        }
    }

    private void detachClones() {
        for (Clones clonesGroup : this.clones) {
            clonesGroup.detach(this);
        }
    }

    boolean isAttached() {
        return this.clones[0].size() != 0;
    }

    public final void setText(String text) {
        this.sharedData.setText(text);
    }

    public final void setUserObject(Object data) {
        this.sharedData.setUserObject(data);
    }

    public final void setXmlText(String pXmlText) {
        this.sharedData.setXmlText(pXmlText);
    }

    public String toString() {
        return HtmlUtils.htmlToPlain(this.getText());
    }

    public int depth() {
        NodeModel parentNode = this.getParentNode();
        if (parentNode == null) {
            return 0;
        }
        return parentNode.depth() + 1;
    }

    public void insert(NodeModel newNodeModel) {
        this.insert(newNodeModel, this.getChildCount());
    }

    public NodeModel getVisibleAncestorOrSelf() {
        NodeModel node = this;
        while (!node.hasVisibleContent()) {
            node = node.getParentNode();
        }
        return node;
    }

    private ExtensionContainer getExtensionContainer() {
        return this.sharedData.getExtensionContainer();
    }

    private NodeIconSetModel getIconModel() {
        return this.sharedData.getIcons();
    }

    void fireNodeChanged(INodeChangeListener[] nodeChangeListeners, NodeChangeEvent nodeChangeEvent) {
        for (NodeModel node : this.clones[CloneType.CONTENT.ordinal()]) {
            NodeChangeEvent cloneEvent = nodeChangeEvent.forNode(node);
            node.fireSingleNodeChanged(nodeChangeListeners, cloneEvent);
        }
    }

    private void fireSingleNodeChanged(INodeChangeListener[] nodeChangeListeners, NodeChangeEvent nodeChangeEvent) {
        for (INodeChangeListener listener : nodeChangeListeners) {
            listener.nodeChanged(nodeChangeEvent);
        }
        this.fireNodeChanged(nodeChangeEvent);
    }

    public NodeModel cloneTree() {
        NodeModel clone = new Cloner(this).cloneTree();
        return clone;
    }

    public NodeModel cloneContent() {
        if (this.containsExtension(EncryptionModel.class)) {
            throw new CloneEncryptedNodeException();
        }
        return this.cloneNode(CloneType.CONTENT);
    }

    protected NodeModel cloneNode(CloneType cloneType) {
        NodeModel clone = new NodeModel(this, cloneType);
        return clone;
    }

    public SharedNodeData getSharedData() {
        return this.sharedData;
    }

    public Collection<IExtension> getIndividualExtensionValues() {
        return Collections.emptyList();
    }

    public void convertToClone(NodeModel node, CloneType cloneType) {
        this.sharedData = node.sharedData;
        if (cloneType == CloneType.TREE) {
            this.clones[CloneType.TREE.ordinal()] = new DetachedNodeList(this, node, CloneType.TREE);
        }
        this.clones[CloneType.CONTENT.ordinal()] = new DetachedNodeList(this, node, CloneType.CONTENT);
    }

    public Clones subtreeClones() {
        return this.clones(CloneType.TREE);
    }

    public Clones allClones() {
        return this.clones(CloneType.CONTENT);
    }

    Clones clones(CloneType cloneType) {
        return this.clones[cloneType.ordinal()];
    }

    public boolean subtreeContainsCloneOf(NodeModel node) {
        for (NodeModel clone : node.subtreeClones()) {
            if (!this.equals(clone)) continue;
            return true;
        }
        for (NodeModel child : this.children) {
            if (!child.subtreeContainsCloneOf(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubtreeCloneOf(NodeModel ancestorClone) {
        return this.subtreeClones().contains(ancestorClone);
    }

    public NodeModel getSubtreeRoot() {
        if (this.isSubtreeRoot()) {
            return this;
        }
        return this.getParentNode().getSubtreeRoot();
    }

    private boolean isSubtreeRoot() {
        return this.parent == null || this.isCloneTreeRoot();
    }

    public boolean isCloneTreeRoot() {
        return this.parent != null && this.parent.clones[TREE_CLONE_INDEX].size() < this.clones[TREE_CLONE_INDEX].size() || this.clones[TREE_CLONE_INDEX].size() == 1 && this.clones[CONTENT_CLONE_INDEX].size() > 1;
    }

    public boolean isCloneTreeNode() {
        return this.parent != null && this.clones[TREE_CLONE_INDEX].size() > 1 && this.parent.clones[TREE_CLONE_INDEX].size() == this.clones[TREE_CLONE_INDEX].size();
    }

    public int nextNodeIndex(int index, boolean leftSide) {
        return this.nextNodeIndex(index, leftSide, 1);
    }

    public int previousNodeIndex(int index, boolean leftSide) {
        return this.nextNodeIndex(index, leftSide, -1);
    }

    private int nextNodeIndex(int index, boolean leftSide, int step) {
        for (int i = index + step; i >= 0 && i < this.getChildCount(); i += step) {
            NodeModel followingNode = this.getChildAt(i);
            if (followingNode.isLeft() != leftSide) continue;
            return i;
        }
        return -1;
    }

    public NodeModel previousNode(int start, boolean isLeft) {
        int previousNodeIndex = this.previousNodeIndex(start, isLeft);
        return this.parent.getChildAt(previousNodeIndex);
    }

    public int getIndex() {
        NodeModel parentNode = this.getParentNode();
        return parentNode != null ? parentNode.getIndex(this) : -1;
    }

    public void swapData(NodeModel duplicate) {
        this.detachClones();
        SharedNodeData sharedDataSwap = this.sharedData;
        this.sharedData = duplicate.sharedData;
        duplicate.sharedData = sharedDataSwap;
        Clones[] clonesSwap = this.clones;
        this.clones = duplicate.clones;
        duplicate.clones = clonesSwap;
        for (CloneType cloneType : CloneType.values()) {
            DetachedNodeList detachedClone = (DetachedNodeList)this.clones[cloneType.ordinal()];
            this.clones[cloneType.ordinal()] = detachedClone.forClone(this);
        }
        this.attachClones();
    }

    public static enum CloneType {
        TREE,
        CONTENT;

    }

    public static enum NodeChangeType {
        FOLDING,
        REFRESH;

    }
}

