/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.print;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.print.BrowseAction;
import org.freeplane.features.print.Preview;
import org.freeplane.features.print.PrintController;
import org.freeplane.features.print.ZoomAction;

class PreviewDialog
extends JDialog
implements ActionListener {
    private static final double DEFAULT_ZOOM_FACTOR_STEP = Math.sqrt(2.0);
    private static final long serialVersionUID = 1L;
    private final JLabel pageNumber;
    protected Printable view;

    public PreviewDialog(PrintController printController, String title, Component c) {
        super(JOptionPane.getFrameForComponent(c), title, true);
        this.view = (Printable)((Object)c);
        Rectangle screenBounds = UITools.getAvailableScreenBounds(c);
        Dimension previewSize = new Dimension(screenBounds.width * 3 / 4, screenBounds.height * 3 / 4);
        Preview preview = new Preview(printController, this.view, previewSize);
        JScrollPane scrollPane = new JScrollPane(preview, 22, 32);
        UITools.setScrollbarIncrement(scrollPane);
        this.getContentPane().add((Component)scrollPane, "Center");
        FreeplaneToolBar toolbar = new FreeplaneToolBar("preview_toolbar", 0);
        this.getContentPane().add((Component)toolbar, "North");
        this.pageNumber = new JLabel("- 9999 -");
        JButton button = this.getButton("Back24.gif", new BrowseAction(preview, this.pageNumber, -1));
        ((Container)toolbar).add(button);
        this.pageNumber.setPreferredSize(new Dimension(this.pageNumber.getPreferredSize().width, button.getPreferredSize().height));
        this.pageNumber.setText("- 1 -");
        this.pageNumber.setHorizontalAlignment(0);
        ((Container)toolbar).add(this.pageNumber);
        ((Container)toolbar).add(this.getButton("Forward24.gif", new BrowseAction(preview, this.pageNumber, 1)));
        ((Container)toolbar).add(new JToolBar.Separator());
        ((Container)toolbar).add(this.getButton("ZoomIn24.png", new ZoomAction(preview, DEFAULT_ZOOM_FACTOR_STEP)));
        ((Container)toolbar).add(this.getButton("ZoomOut24.png", new ZoomAction(preview, 1.0 / DEFAULT_ZOOM_FACTOR_STEP)));
        ((Container)toolbar).add(new JToolBar.Separator());
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        buttons.add(ok);
        this.getContentPane().add((Component)buttons, "South");
        UITools.addEscapeActionToDialog(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private JButton getButton(String iconName, AbstractAction action) {
        return this.getButton(null, iconName, action);
    }

    private JButton getButton(String name, String iconName, AbstractAction action) {
        JButton result = null;
        ImageIcon icon = null;
        URL imageURL = ResourceController.getResourceController().getResource("/images/" + iconName);
        if (imageURL != null) {
            icon = new ImageIcon(imageURL);
        }
        if (action != null) {
            if (icon != null) {
                action.putValue("SmallIcon", new ImageIcon(imageURL));
            }
            if (name != null) {
                action.putValue("Name", name);
            }
            result = new JButton(action);
        } else {
            result = new JButton(name, icon);
        }
        return result;
    }
}

