/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.styles.AutomaticLayout;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.n3.nanoxml.XMLElement;

@NodeHookDescriptor(hookName="accessories/plugins/AutomaticLayout.properties")
public class AutomaticLayoutController
extends PersistentNodeHook
implements IExtension {
    private static final int FIRST_CYCLIC_STYLE_LEVEL = 1;
    private static final String AUTOMATIC_LAYOUT_LEVEL = "AutomaticLayout.level,";
    private static final String AUTOMATIC_LAYOUT_LEVEL_ROOT = "AutomaticLayout.level.root";

    public AutomaticLayoutController() {
        LogicalStyleController.getController().addStyleGetter(IPropertyHandler.AUTO, new IPropertyHandler<Collection<IStyle>, NodeModel>(){

            @Override
            public Collection<IStyle> getProperty(NodeModel model, Collection<IStyle> currentValue) {
                AutomaticLayout layout = model.getMap().getRootNode().getExtension(AutomaticLayout.class);
                IStyle autoStyle = AutomaticLayoutController.this.getStyle(model, layout);
                if (autoStyle != null) {
                    LogicalStyleController.getController().add(model, currentValue, autoStyle);
                }
                return currentValue;
            }
        });
    }

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        if (element == null || !element.hasAttribute("VALUE")) {
            return AutomaticLayout.ALL;
        }
        return super.createExtension(node, element);
    }

    private IStyle getStyle(NodeModel node, AutomaticLayout layout) {
        if (layout == null || node.isLeaf() && !layout.applyToLeaves) {
            return null;
        }
        int depth = node.depth();
        return this.getStyle(node.getMap(), depth, false);
    }

    public IStyle getStyle(MapModel map, int depth, boolean cyclic) {
        String name;
        TranslatedObject styleKey;
        IStyle style;
        MapStyleModel extension = MapStyleModel.getExtension(map);
        if (extension.getStyleNode(style = StyleFactory.create(styleKey = TranslatedObject.format(name = depth == 0 ? AUTOMATIC_LAYOUT_LEVEL_ROOT : AUTOMATIC_LAYOUT_LEVEL + depth))) != null) {
            return style;
        }
        if (!cyclic) {
            return null;
        }
        TranslatedObject rootKey = TranslatedObject.format(AUTOMATIC_LAYOUT_LEVEL_ROOT);
        IStyle rootStyle = StyleFactory.create(rootKey);
        NodeModel rootStyleNode = extension.getStyleNode(rootStyle);
        if (rootStyleNode == null) {
            return null;
        }
        NodeModel automaticStylesParentNode = rootStyleNode.getParentNode();
        int cycledLevelStyleCount = automaticStylesParentNode.getChildCount() - 1;
        if (cycledLevelStyleCount <= 0) {
            return null;
        }
        return this.getStyle(map, 1 + (depth - 1) % cycledLevelStyleCount, false);
    }

    public NodeModel getStyleNode(MapModel map, int depth, boolean cyclic) {
        IStyle style = this.getStyle(map, depth, cyclic);
        if (style != null) {
            MapStyleModel extension = MapStyleModel.getExtension(map);
            return extension.getStyleNode(style);
        }
        return null;
    }

    @Override
    protected Class<? extends IExtension> getExtensionClass() {
        return AutomaticLayout.class;
    }

    @Override
    protected IExtension toggle(NodeModel node, IExtension extension) {
        extension = super.toggle(node, extension);
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        if (modeController.isUndoAction()) {
            return extension;
        }
        LogicalStyleController.getController().refreshMap(node.getMap());
        return extension;
    }

    public boolean isAutomaticLevelStyle(NodeModel styleNode) {
        NodeModel parentNode = styleNode.getParentNode();
        if (parentNode == null) {
            return false;
        }
        Object userObject = parentNode.getUserObject();
        if (!(userObject instanceof StyleTranslatedObject)) {
            return false;
        }
        return ((StyleTranslatedObject)userObject).getObject().equals("styles.AutomaticLayout");
    }
}

