/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.ui;

import java.awt.Component;
import javax.swing.Box;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JResizer;
import org.freeplane.core.ui.components.OneTouchCollapseResizer;
import org.freeplane.core.ui.components.ResizeEvent;
import org.freeplane.core.ui.components.ResizerListener;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.UIComponentVisibilityDispatcher;

public class CollapseableBoxBuilder {
    private static final int DEFAULT_SIZE = 350;
    private final FrameController frameController;
    private String propertyNameBase;
    private boolean resizeable = true;

    public CollapseableBoxBuilder setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
        return this;
    }

    public CollapseableBoxBuilder(FrameController frameController) {
        this.frameController = frameController;
    }

    public CollapseableBoxBuilder setPropertyNameBase(String name) {
        this.propertyNameBase = name;
        return this;
    }

    public Box createBox(final Component component, final JResizer.Direction direction) {
        Box resisableComponent = direction.createBox();
        UIComponentVisibilityDispatcher.install(this.frameController, resisableComponent, this.propertyNameBase);
        final UIComponentVisibilityDispatcher dispatcher = UIComponentVisibilityDispatcher.dispatcher(resisableComponent);
        final String sizePropertyName = dispatcher.getPropertyName() + ".size";
        boolean expanded = dispatcher.isVisible();
        OneTouchCollapseResizer resizer = new OneTouchCollapseResizer(direction);
        dispatcher.setResizer(resizer);
        switch (direction) {
            case RIGHT: 
            case DOWN: {
                resisableComponent.add(resizer);
                resisableComponent.add(component);
                break;
            }
            default: {
                resisableComponent.add(component);
                resisableComponent.add(resizer);
            }
        }
        if (this.resizeable) {
            try {
                int size = ResourceController.getResourceController().getIntProperty(sizePropertyName, 350);
                if (size <= 10) {
                    size = 350;
                }
                direction.setPreferredSize(component, size);
            }
            catch (Exception exception) {
                // empty catch block
            }
            resizer.addResizerListener(new ResizerListener(){

                @Override
                public void componentResized(ResizeEvent event) {
                    if (event.getComponent().equals(component)) {
                        ResourceController.getResourceController().setProperty(sizePropertyName, String.valueOf(direction.getPreferredSize(component)));
                    }
                }
            });
        } else {
            resizer.setSliderLocked(true);
        }
        resizer.addCollapseListener(new OneTouchCollapseResizer.ComponentCollapseListener(){

            @Override
            public void componentCollapsed(ResizeEvent event) {
                if (event.getComponent().equals(component)) {
                    dispatcher.setProperty(false);
                }
            }

            @Override
            public void componentExpanded(ResizeEvent event) {
                if (event.getComponent().equals(component)) {
                    dispatcher.setProperty(true);
                }
            }
        });
        resizer.setExpanded(expanded);
        return resisableComponent;
    }
}

