/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.addons;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.TextUtils;
import org.freeplane.n3.nanoxml.CdataContentXmlWriter;
import org.freeplane.n3.nanoxml.XMLElement;

public class AddOnProperties {
    public static final String OP_CONFIGURE = "configure";
    public static final String OP_DEACTIVATE = "deactivate";
    public static final String OP_ACTIVATE = "activate";
    public static final String OP_DEINSTALL = "deinstall";
    private final AddOnType addOnType;
    private boolean active = true;
    private String name;
    private String author;
    private String version;
    private String latestVersion;
    private FreeplaneVersion freeplaneVersionFrom;
    private FreeplaneVersion freeplaneVersionTo;
    private URL homepage;
    private URL updateUrl;
    private URL latestVersionDownloadUrl;
    private URL latestVersionChangelogUrl;
    private String description;
    private String license;
    private Map<String, Map<String, String>> translations;
    private String preferencesXml;
    private Map<String, String> defaultProperties;
    private List<String[]> deinstallationRules;
    private List<String> images;
    private File addOnPropertiesFile;

    public AddOnProperties(AddOnType addOnType) {
        this.addOnType = addOnType;
    }

    public AddOnProperties(AddOnType addOnType, XMLElement addOnElement) {
        this(addOnType);
        this.setName(addOnElement.getAttribute("name", null));
        this.setVersion(addOnElement.getAttribute("version", null));
        this.setLatestVersion(addOnElement.getAttribute("latestVersion", null));
        this.setFreeplaneVersionFrom(FreeplaneVersion.getVersion(addOnElement.getAttribute("freeplaneVersionFrom", null)));
        this.setFreeplaneVersionTo(FreeplaneVersion.getVersion(addOnElement.getAttribute("freeplaneVersionTo", null)));
        this.setHomepage(this.parseUrl(addOnElement.getAttribute("homepage", null)));
        this.setUpdateUrl(this.parseUrl(addOnElement.getAttribute("updateUrl", null)));
        this.setActive(Boolean.parseBoolean(addOnElement.getAttribute("active", "true")));
        this.setDescription(this.getContentOfFirstElement(addOnElement.getChildrenNamed("description")));
        this.setLicense(this.getContentOfFirstElement(addOnElement.getChildrenNamed("license")));
        this.setAuthor(addOnElement.getAttribute("author", null));
        this.setTranslations(this.parseTranslations(addOnElement.getChildrenNamed("translations")));
        this.setPreferencesXml(this.getContentOfFirstElement(addOnElement.getChildrenNamed("preferences.xml")));
        this.setDefaultProperties(this.parseAttributesToProperties(addOnElement.getChildrenNamed("default.properties")));
        this.setImages(this.parseBinaries(addOnElement.getChildrenNamed("images")));
        this.setDeinstallationRules(this.parseDeinstallationRules(addOnElement.getChildrenNamed(OP_DEINSTALL)));
        this.validate();
    }

    private URL parseUrl(String url) {
        try {
            return new URL(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getContentOfFirstElement(Vector<XMLElement> xmlElements) {
        if (xmlElements == null || xmlElements.isEmpty()) {
            return null;
        }
        return xmlElements.get(0).getContent();
    }

    private Map<String, Map<String, String>> parseTranslations(Vector<XMLElement> xmlElements) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (xmlElements != null && !xmlElements.isEmpty()) {
            for (XMLElement xmlElement : xmlElements.get(0).getChildren()) {
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                result.put(xmlElement.getAttribute("name", null), properties);
                for (XMLElement entryXmlElement : xmlElement.getChildren()) {
                    properties.put(entryXmlElement.getAttribute("key", null), entryXmlElement.getContent());
                }
            }
        }
        return result;
    }

    private Map<String, String> parseAttributesToProperties(Vector<XMLElement> xmlElements) {
        if (xmlElements == null || xmlElements.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.propertiesToStringMap(xmlElements.get(0).getAttributes());
    }

    private Map<String, String> propertiesToStringMap(Properties props) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    protected List<String> parseBinaries(Vector<XMLElement> xmlElements) {
        ArrayList<String> result = new ArrayList<String>();
        if (xmlElements != null && !xmlElements.isEmpty()) {
            for (XMLElement xmlElement : xmlElements.get(0).getChildren()) {
                result.add(xmlElement.getAttribute("name", null));
            }
        }
        return result;
    }

    private List<String[]> parseDeinstallationRules(Vector<XMLElement> xmlElements) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (xmlElements != null && !xmlElements.isEmpty()) {
            for (XMLElement xmlElement : xmlElements.get(0).getChildren()) {
                result.add(new String[]{xmlElement.getName(), xmlElement.getContent()});
            }
        }
        return result;
    }

    private void validate() {
        if (this.empty(this.name)) {
            throw new RuntimeException("while parsing .addon.xml file: name must be set");
        }
        if (this.empty(this.version)) {
            throw new RuntimeException("while parsing .addon.xml file: version must be set");
        }
        if (this.freeplaneVersionFrom == null) {
            throw new RuntimeException("while parsing .addon.xml file: freeplaneVersionFrom must be set");
        }
        if (this.empty(this.description)) {
            throw new RuntimeException("while parsing .addon.xml file: description must be set");
        }
    }

    public AddOnType getAddOnType() {
        return this.addOnType;
    }

    public String getNameKey() {
        return "addons." + this.name;
    }

    public String getTranslatedName() {
        return TextUtils.getRawText(this.getNameKey());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public URL getLatestVersionDownloadUrl() {
        return this.latestVersionDownloadUrl;
    }

    public URL getLatestVersionChangelogUrl() {
        return this.latestVersionChangelogUrl;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLatestVersionDownloadUrl(URL latestVersionDownloadUrl) {
        this.latestVersionDownloadUrl = latestVersionDownloadUrl;
    }

    public void setLatestVersionChangelogUrl(URL latestVersionChangelogUrl) {
        this.latestVersionChangelogUrl = latestVersionChangelogUrl;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public FreeplaneVersion getFreeplaneVersionFrom() {
        return this.freeplaneVersionFrom;
    }

    public void setFreeplaneVersionFrom(FreeplaneVersion freeplaneVersionFrom) {
        this.freeplaneVersionFrom = freeplaneVersionFrom;
    }

    public FreeplaneVersion getFreeplaneVersionTo() {
        return this.freeplaneVersionTo;
    }

    public void setFreeplaneVersionTo(FreeplaneVersion freeplaneVersionTo) {
        this.freeplaneVersionTo = freeplaneVersionTo;
    }

    public URL getHomepage() {
        return this.homepage;
    }

    public URL getUpdateUrl() {
        if (this.updateUrl != null) {
            return this.updateUrl;
        }
        if (this.homepage != null && !this.homepage.getPath().isEmpty()) {
            return this.homepagePlusLatestVersionFile();
        }
        return null;
    }

    private URL homepagePlusLatestVersionFile() {
        try {
            String pathWithForwardSlashes = this.homepage.getPath() + '/' + "version.properties";
            return new URL(this.homepage.getProtocol(), this.homepage.getHost(), this.homepage.getPort(), pathWithForwardSlashes);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setHomepage(URL homepage) {
        this.homepage = homepage;
    }

    public void setUpdateUrl(Object updateUrl) {
        this.updateUrl = this.toURL(updateUrl);
    }

    private URL toURL(Object updateUrl) {
        try {
            if (updateUrl == null) {
                return null;
            }
            if (updateUrl instanceof URL) {
                return (URL)updateUrl;
            }
            if (updateUrl instanceof URI) {
                return ((URI)updateUrl).toURL();
            }
            return new URL(updateUrl.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public Map<String, Map<String, String>> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Map<String, Map<String, String>> translations) {
        this.translations = translations;
    }

    public String getPreferencesXml() {
        return this.preferencesXml;
    }

    public void setPreferencesXml(String preferencesXml) {
        this.preferencesXml = preferencesXml;
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public List<String[]> getDeinstallationRules() {
        return this.deinstallationRules;
    }

    public void setDeinstallationRules(List<String[]> rules) {
        this.deinstallationRules = rules;
    }

    public List<String> getImages() {
        return this.images;
    }

    public void setImages(Collection<String> images) {
        this.images = new ArrayList<String>(images);
    }

    public File getAddOnPropertiesFile() {
        return this.addOnPropertiesFile;
    }

    public void setAddOnPropertiesFile(File file) {
        this.addOnPropertiesFile = file;
    }

    public boolean supportsOperation(String opName) {
        if (opName.equals(OP_CONFIGURE)) {
            return !this.empty(this.preferencesXml);
        }
        if (opName.equals(OP_DEACTIVATE)) {
            return this.active;
        }
        if (opName.equals(OP_ACTIVATE)) {
            return !this.active;
        }
        if (opName.equals(OP_DEINSTALL)) {
            return this.deinstallationRules != null && !this.deinstallationRules.isEmpty();
        }
        return false;
    }

    public String toXmlString() {
        try {
            String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            StringWriter writer = new StringWriter();
            CdataContentXmlWriter xmlWriter = new CdataContentXmlWriter(writer);
            xmlWriter.addRawContent("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xmlWriter.addRawContent(System.getProperty("line.separator"));
            xmlWriter.write(this.toXml(), true);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XMLElement toXml() {
        XMLElement addonElement = new XMLElement("addon");
        addonElement.setAttribute("name", this.name);
        addonElement.setAttribute("version", this.version);
        addonElement.setAttribute("latestVersion", this.latestVersion == null ? "" : this.latestVersion);
        addonElement.setAttribute("freeplaneVersionFrom", this.freeplaneVersionFrom.toString());
        if (this.freeplaneVersionTo != null) {
            addonElement.setAttribute("freeplaneVersionTo", this.freeplaneVersionTo.toString());
        }
        if (this.homepage != null) {
            addonElement.setAttribute("homepage", this.homepage.toString());
        }
        if (this.updateUrl != null) {
            addonElement.setAttribute("updateUrl", this.updateUrl.toString());
        }
        if (this.author != null) {
            addonElement.setAttribute("author", this.author);
        }
        addonElement.setAttribute("active", Boolean.toString(this.active));
        this.addAsChildWithContent(addonElement, "description", this.description);
        this.addAsChildWithContent(addonElement, "license", this.license);
        this.addAsChildWithContent(addonElement, "preferences.xml", this.preferencesXml);
        this.addTranslationsAsChild(addonElement);
        this.addDefaultPropertiesAsChild(addonElement);
        this.addImagesAsChild(addonElement);
        this.addDeinstallationRulesAsChild(addonElement);
        return addonElement;
    }

    private void addAsChildWithContent(XMLElement parent, String name, String content) {
        XMLElement xmlElement = new XMLElement(name);
        xmlElement.setContent(content);
        parent.addChild(xmlElement);
    }

    private void addTranslationsAsChild(XMLElement parent) {
        XMLElement translationsElement = new XMLElement("translations");
        for (Map.Entry<String, Map<String, String>> localeEntry : this.translations.entrySet()) {
            XMLElement localeElement = new XMLElement("locale");
            localeElement.setAttribute("name", localeEntry.getKey());
            for (Map.Entry<String, String> translationEntry : localeEntry.getValue().entrySet()) {
                XMLElement translationElement = new XMLElement("entry");
                translationElement.setAttribute("key", translationEntry.getKey());
                translationElement.setContent(StringEscapeUtils.escapeJava((String)translationEntry.getValue()));
                localeElement.addChild(translationElement);
            }
            translationsElement.addChild(localeElement);
        }
        parent.addChild(translationsElement);
    }

    private void addDefaultPropertiesAsChild(XMLElement parent) {
        XMLElement xmlElement = new XMLElement("default.properties");
        for (Map.Entry<String, String> entry : this.defaultProperties.entrySet()) {
            xmlElement.setAttribute(entry.getKey(), entry.getValue());
        }
        parent.addChild(xmlElement);
    }

    private void addImagesAsChild(XMLElement parent) {
        XMLElement xmlElement = new XMLElement("images");
        if (this.images != null) {
            for (String image : this.images) {
                XMLElement imageElement = new XMLElement("image");
                imageElement.setAttribute("name", image);
                xmlElement.addChild(imageElement);
            }
        }
        parent.addChild(xmlElement);
    }

    private void addDeinstallationRulesAsChild(XMLElement parent) {
        XMLElement xmlElement = new XMLElement(OP_DEINSTALL);
        for (String[] rule : this.deinstallationRules) {
            XMLElement ruleElement = new XMLElement(rule[0]);
            ruleElement.setContent(rule[1]);
            xmlElement.addChild(ruleElement);
        }
        parent.addChild(xmlElement);
    }

    private boolean empty(String string) {
        return string == null || string.length() == 0;
    }

    public String toString() {
        return "AddOnProperties(addOnType=" + (Object)((Object)this.addOnType) + ", active=" + this.active + ", name=" + this.name + ", version=" + this.version + ")";
    }

    public boolean isTheme() {
        return this.name != null && this.name.toLowerCase().endsWith("theme");
    }

    public static enum AddOnType {
        SCRIPT,
        PLUGIN;

    }
}

