/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.MultipleImage;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.HideChildSubtree;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.HighlightedTransformedObject;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.FoldingMark;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeTooltip;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.freeplane.view.swing.map.ZoomableLabelUI;

public abstract class MainView
extends ZoomableLabel {
    private static final int FOLDING_CIRCLE_WIDTH = 16;
    private static final String USE_COMMON_OUT_POINT_FOR_ROOT_NODE_STRING = "use_common_out_point_for_root_node";
    public static boolean USE_COMMON_OUT_POINT_FOR_ROOT_NODE = ResourceController.getResourceController().getBooleanProperty("use_common_out_point_for_root_node");
    static Dimension maximumSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    static Dimension minimumSize = new Dimension(0, 0);
    private static final long serialVersionUID = 1L;
    protected int isDraggedOver = 0;
    private boolean isShortened;
    private TextModificationState textModified = TextModificationState.NONE;
    private MouseArea mouseArea = MouseArea.OUT;
    static final Stroke DEF_STROKE = new BasicStroke();
    private static final int DRAG_OVAL_WIDTH = 10;

    boolean isShortened() {
        return this.isShortened;
    }

    MainView() {
        this.setAlignmentX(0.5f);
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setHorizontalTextPosition(11);
        this.setVerticalTextPosition(1);
    }

    protected void convertPointFromMap(Point p) {
        UITools.convertPointFromAncestor(this.getMap(), p, this);
    }

    protected void convertPointToMap(Point p) {
        UITools.convertPointToAncestor((Component)this, p, this.getMap());
    }

    public boolean dropAsSibling(double xCoord) {
        if (this.getNodeView().isRoot()) {
            return false;
        }
        if (this.dropLeft(xCoord)) {
            return !this.isInVerticalRegion(xCoord, 0.6666666666666666);
        }
        return this.isInVerticalRegion(xCoord, 0.3333333333333333);
    }

    public boolean dropLeft(double xCoord) {
        NodeView nodeView = this.getNodeView();
        if (this.getNodeView().isRoot()) {
            return xCoord < (double)(this.getSize().width * 1 / 2);
        }
        return nodeView.isLeft();
    }

    public int getDeltaX() {
        NodeView nodeView = this.getNodeView();
        if (nodeView.isFolded() && nodeView.isLeft()) {
            return this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return 0;
    }

    public int getDeltaY() {
        return 0;
    }

    public int getDraggedOver() {
        return this.isDraggedOver;
    }

    public abstract Point getLeftPoint();

    protected int getMainViewHeightWithFoldingMark() {
        return this.getHeight();
    }

    protected int getMainViewWidthWithFoldingMark() {
        int width = this.getWidth();
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getModel();
        if (nodeView.isFolded()) {
            width += this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return width;
    }

    @Override
    public Dimension getMaximumSize() {
        return maximumSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return minimumSize;
    }

    public abstract Point getRightPoint();

    public abstract ShapeConfigurationModel getShapeConfiguration();

    int getZoomedFoldingSymbolHalfWidth() {
        return this.getNodeView().getZoomedFoldingSymbolHalfWidth();
    }

    public boolean isClickableLink(double xCoord) {
        NodeView nodeView = this.getNodeView();
        NodeModel model = nodeView.getModel();
        if (NodeLinks.getValidLink(model) == null) {
            return false;
        }
        return this.isInIconRegion(xCoord);
    }

    public boolean isInIconRegion(double xCoord) {
        Rectangle iconR = this.getIconRectangle();
        return xCoord >= (double)iconR.x && xCoord < (double)(iconR.x + iconR.width);
    }

    private Rectangle getIconRectangle() {
        ZoomableLabelUI zoomableLabelUI = (ZoomableLabelUI)this.getUI();
        Rectangle iconR = zoomableLabelUI.getIconR(this);
        return iconR;
    }

    public boolean isInVerticalRegion(double xCoord, double p) {
        return xCoord < (double)this.getSize().width * p;
    }

    @Override
    public final void paint(Graphics g) {
        PaintingMode paintingMode = this.getMap().getPaintingMode();
        if (!PaintingMode.SELECTED_NODES.equals((Object)paintingMode) && !PaintingMode.NODES.equals((Object)paintingMode)) {
            return;
        }
        NodeView nodeView = this.getNodeView();
        boolean selected = nodeView.isSelected();
        if (paintingMode.equals((Object)PaintingMode.SELECTED_NODES) == selected) {
            super.paint(g);
        }
    }

    public void paintDragOver(Graphics2D graphics) {
        if (this.isDraggedOver == 1 || this.isDraggedOver == 3) {
            this.paintDragOverSon(graphics);
        }
        if (this.isDraggedOver == 2) {
            this.paintDragOverSibling(graphics);
        }
    }

    private void paintDragOverSibling(Graphics2D graphics) {
        graphics.setPaint(new GradientPaint(0.0f, this.getHeight() * 3 / 5, this.getMap().getBackground(), 0.0f, this.getHeight() / 5, NodeView.dragColor));
        graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    private void paintDragOverSon(Graphics2D graphics) {
        if (this.getNodeView().isLeft() || this.isDraggedOver == 3) {
            graphics.setPaint(new GradientPaint(this.getWidth() * 3 / 4, 0.0f, this.getMap().getBackground(), this.getWidth() / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(0, 0, this.getWidth() * 3 / 4, this.getHeight() - 1);
        } else {
            graphics.setPaint(new GradientPaint(this.getWidth() / 4, 0.0f, this.getMap().getBackground(), this.getWidth() * 3 / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(this.getWidth() / 4, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    public FoldingMark foldingMarkType(MapController mapController, NodeView nodeView) {
        NodeModel node = nodeView.getModel();
        if (nodeView.isFolded()) {
            return FoldingMark.ITSELF_FOLDED;
        }
        for (NodeModel child : mapController.childrenUnfolded(node)) {
            if (!child.hasVisibleContent() || !child.containsExtension(HideChildSubtree.class)) continue;
            return FoldingMark.ITSELF_FOLDED;
        }
        for (NodeView childView : nodeView.getChildrenViews()) {
            if (childView.getModel().hasVisibleContent() || FoldingMark.UNFOLDED.equals(this.foldingMarkType(mapController, childView))) continue;
            return FoldingMark.UNVISIBLE_CHILDREN_FOLDED;
        }
        return FoldingMark.UNFOLDED;
    }

    void paintDecoration(NodeView nodeView, Graphics2D g) {
        this.drawModificationRect(g);
        this.paintDragRectangle(g);
        this.paintFoldingMark(nodeView, g);
        if (this.isShortened()) {
            FoldingMark.SHORTENED.draw(g, nodeView, this.decorationMarkBounds(nodeView, 2.3333333333333335, 1.6666666666666667));
        } else if (nodeView.getModel().isCloneTreeRoot()) {
            FoldingMark.CLONE.draw(g, nodeView, this.decorationMarkBounds(nodeView, 2.0, 2.5));
        } else if (nodeView.getModel().isCloneTreeNode()) {
            FoldingMark.CLONE.draw(g, nodeView, this.decorationMarkBounds(nodeView, 1.5, 2.5));
        }
    }

    private Rectangle decorationMarkBounds(NodeView nodeView, double widthFactor, double heightFactor) {
        int size = nodeView.getZoomedStateSymbolHalfWidth();
        int width = (int)((double)size * widthFactor);
        int x = nodeView.isLeft() ? this.getWidth() : 0 - width;
        int height = (int)((double)size * heightFactor);
        int y = (this.getHeight() - height) / 2;
        Rectangle decorationMarkBounds = new Rectangle(x, y, width, height);
        return decorationMarkBounds;
    }

    protected void paintFoldingMark(NodeView nodeView, Graphics2D g) {
        if (!this.hasChildren()) {
            return;
        }
        MapView map = this.getMap();
        MapController mapController = map.getModeController().getMapController();
        FoldingMark markType = this.foldingMarkType(mapController, nodeView);
        Point mousePosition = null;
        try {
            mousePosition = this.getMousePosition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mousePosition != null && !map.isPrinting()) {
            NodeModel node;
            Point p;
            int width = Math.max(16, this.getZoomedFoldingSymbolHalfWidth() * 2);
            Point point = p = this.getNodeView().isLeft() ? this.getLeftPoint() : this.getRightPoint();
            p.y = p.y + width / 2 > this.getHeight() ? this.getHeight() - width : (p.y -= width / 2);
            if (nodeView.isLeft()) {
                p.x -= width;
            }
            FoldingMark foldingCircle = markType.equals(FoldingMark.UNFOLDED) ? (mapController.hasHiddenChildren(node = nodeView.getModel()) ? FoldingMark.FOLDING_CIRCLE_HIDDEN_CHILD : FoldingMark.FOLDING_CIRCLE_UNFOLDED) : FoldingMark.FOLDING_CIRCLE_FOLDED;
            foldingCircle.draw(g, nodeView, new Rectangle(p.x, p.y, width, width));
        } else {
            Point p;
            int halfWidth = this.getZoomedFoldingSymbolHalfWidth();
            Point point = p = this.getNodeView().isLeft() ? this.getLeftPoint() : this.getRightPoint();
            p.x = p.x <= 0 ? (p.x -= halfWidth) : (p.x += halfWidth);
            markType.draw(g, nodeView, new Rectangle(p.x - halfWidth, p.y - halfWidth, halfWidth * 2, halfWidth * 2));
        }
    }

    private void paintDragRectangle(Graphics g) {
        if (!MouseArea.MOTION.equals((Object)this.mouseArea)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        MapView parent = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        parent.getModeController().getController().getMapViewManager().setEdgesRenderingHint(g2);
        Color color = g2.getColor();
        NodeView movedView = this.getNodeView();
        Rectangle r = this.getDragRectangle();
        if (movedView.isFree()) {
            g2.setColor(Color.BLUE);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        } else if (LocationModel.getModel((NodeModel)movedView.getModel()).getHGap().value <= 0.0) {
            g2.setColor(Color.RED);
            g.fillOval(r.x, r.y, r.width - 1, r.height - 1);
        }
        g2.setColor(Color.BLACK);
        g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
        g2.setColor(color);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
    }

    public Rectangle getDragRectangle() {
        int size = this.getDraggingWidth();
        Rectangle r = this.getNodeView().isLeft() ? new Rectangle(this.getWidth(), -size, size, this.getHeight() + size * 2) : new Rectangle(-size, -size, size, this.getHeight() + size * 2);
        return r;
    }

    private void drawModificationRect(Graphics g) {
        Color color = g.getColor();
        if (TextModificationState.HIGHLIGHT.equals((Object)this.textModified)) {
            boolean markTransformedText = TextController.isMarkTransformedTextSet();
            if (!markTransformedText) {
                return;
            }
            g.setColor(Color.GREEN);
        } else if (TextModificationState.FAILURE.equals((Object)this.textModified)) {
            g.setColor(Color.RED);
        } else {
            return;
        }
        g.drawRect(-1, -1, this.getWidth() + 2, this.getHeight() + 2);
        g.setColor(color);
    }

    protected void paintBackgound(Graphics2D g) {
        Color color = this.getPaintedBackground();
        this.paintBackground(g, color);
    }

    public Color getPaintedBackground() {
        Color color = this.getNodeView().useSelectionColors() ? this.getNodeView().getSelectedColor() : this.getNodeView().getTextBackground();
        return color;
    }

    protected abstract void paintBackground(Graphics2D var1, Color var2);

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (super.processKeyBinding(ks, e, condition, pressed)) {
            return true;
        }
        MapView mapView = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
        FreeplaneMenuBar freeplaneMenuBar = mapView.getModeController().getController().getViewController().getFreeplaneMenuBar();
        return !freeplaneMenuBar.isVisible() && freeplaneMenuBar.processKeyBinding(ks, e, 2, pressed);
    }

    public void setDraggedOver(int draggedOver) {
        this.isDraggedOver = draggedOver;
    }

    public void setDraggedOver(Point p) {
        int draggedOver = this.getNodeView().isRoot() ? (this.dropLeft(p.getX()) ? 3 : 1) : (this.dropAsSibling(p.getX()) ? 2 : 1);
        this.setDraggedOver(draggedOver);
    }

    public void updateFont(NodeView node) {
        Font font = NodeStyleController.getController(node.getMap().getModeController()).getFont(node.getModel());
        this.setFont(UITools.scale(font));
    }

    void updateIcons(NodeView node) {
        MultipleImage iconImages = new MultipleImage();
        NodeModel model = node.getModel();
        for (UIIcon icon : IconController.getController().getStateIcons(model)) {
            iconImages.addIcon(icon);
        }
        ModeController modeController = this.getNodeView().getMap().getModeController();
        Collection<MindIcon> icons = IconController.getController(modeController).getIcons(model);
        for (MindIcon myIcon : icons) {
            iconImages.addIcon(myIcon);
        }
        this.addOwnIcons(iconImages, model);
        this.setIcon(iconImages.getImageCount() > 0 ? iconImages : null);
    }

    private void addOwnIcons(MultipleImage iconImages, NodeModel model) {
        URI link = NodeLinks.getLink(model);
        Icon icon = this.getNodeView().getMap().getModeController().getExtension(LinkController.class).getLinkIcon(link, model);
        if (icon != null) {
            iconImages.addLinkIcon(icon);
        }
    }

    void updateTextColor(NodeView node) {
        Color color = NodeStyleController.getController(node.getMap().getModeController()).getColor(node.getModel());
        this.setForeground(color);
    }

    void updateTextAlign(NodeView node) {
        NodeStyleModel.TextAlign textAlign = NodeStyleController.getController(node.getMap().getModeController()).getTextAlign(node.getModel());
        boolean isCenteredByDefault = textAlign == NodeStyleModel.TextAlign.DEFAULT && node.isRoot();
        this.setHorizontalAlignment(isCenteredByDefault ? NodeStyleModel.TextAlign.CENTER.swingConstant : textAlign.swingConstant);
    }

    public boolean isEdited() {
        return this.getComponentCount() == 1 && this.getComponent(0) instanceof JTextComponent;
    }

    public void updateText(NodeModel nodeModel) {
        String text;
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return;
        }
        ModeController modeController = nodeView.getMap().getModeController();
        TextController textController = TextController.getController(modeController);
        this.isShortened = textController.isMinimized(nodeModel);
        Object userObject = nodeModel.getUserObject();
        try {
            Object transformedContent = textController.getTransformedObject(nodeModel);
            if (nodeView.isSelected()) {
                nodeView.getMap().getModeController().getController().getViewController().addObjectTypeInfo(transformedContent);
            }
            Icon icon = textController.getIcon(transformedContent, nodeModel, userObject);
            this.putClientProperty("TextRenderingIcon", icon);
            text = transformedContent.toString();
            this.textModified = transformedContent instanceof HighlightedTransformedObject ? TextModificationState.HIGHLIGHT : TextModificationState.NONE;
        }
        catch (Throwable e) {
            LogUtils.warn(e.getMessage(), e);
            text = TextUtils.format("MainView.errorUpdateText", String.valueOf(userObject), e.getLocalizedMessage());
            this.textModified = TextModificationState.FAILURE;
        }
        if (this.isShortened) {
            text = textController.getShortText(text);
        }
        text = this.convertTextToHtmlLink(text, nodeModel);
        this.updateText(text);
    }

    private String convertTextToHtmlLink(String text, NodeModel node) {
        URI link = NodeLinks.getLink(node);
        if (link == null || "menuitem".equals(link.getScheme()) || !LinkController.getController().formatNodeAsHyperlink(node)) {
            return text;
        }
        if (HtmlUtils.isHtmlNode(text)) {
            text = HtmlUtils.htmlToPlain(text);
        }
        StringBuilder sb = new StringBuilder("<html><body><a href=\"");
        sb.append(link.toString());
        sb.append("\">");
        String xmlEscapedText = HtmlUtils.toHTMLEscapedText(text);
        sb.append(xmlEscapedText);
        sb.append("</a></body></html>");
        return sb.toString();
    }

    @Override
    public JToolTip createToolTip() {
        NodeTooltip tip = new NodeTooltip(this.getGraphicsConfiguration());
        tip.setComponent(this);
        URL url = this.getMap().getModel().getURL();
        if (url != null) {
            tip.setBase(url);
        } else {
            try {
                tip.setBase(new URL("file: "));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return tip;
    }

    @Override
    public void setBorder(Border border) {
    }

    public ConnectorLocation getConnectorLocation(Point relativeLocation) {
        if (relativeLocation.x > this.getWidth()) {
            return ConnectorLocation.RIGHT;
        }
        if (relativeLocation.x < 0) {
            return ConnectorLocation.LEFT;
        }
        if (relativeLocation.y > this.getHeight()) {
            return ConnectorLocation.BOTTOM;
        }
        if (relativeLocation.y < 0) {
            return ConnectorLocation.TOP;
        }
        return ConnectorLocation.CENTER;
    }

    public Point getConnectorPoint(Point relativeLocation) {
        if (relativeLocation.x > this.getWidth()) {
            return this.getRightPoint();
        }
        if (relativeLocation.x < 0) {
            return this.getLeftPoint();
        }
        if (relativeLocation.y > this.getHeight()) {
            Point bottomPoint = this.getBottomPoint();
            bottomPoint.y = this.getNodeView().getContent().getHeight();
            return bottomPoint;
        }
        if (relativeLocation.y < 0) {
            return this.getTopPoint();
        }
        return this.getCenterPoint();
    }

    private Point getCenterPoint() {
        return new Point(this.getWidth() / 2, this.getHeight() / 2);
    }

    public Point getTopPoint() {
        return new Point(this.getWidth() / 2, 0);
    }

    public Point getBottomPoint() {
        return new Point(this.getWidth() / 2, this.getHeight());
    }

    @Override
    public String getToolTipText() {
        String toolTipText = super.getToolTipText();
        if (toolTipText != null) {
            return toolTipText;
        }
        return this.createToolTipText();
    }

    private String createToolTipText() {
        NodeView nodeView = this.getNodeView();
        if (nodeView == null) {
            return "";
        }
        ModeController modeController = nodeView.getMap().getModeController();
        NodeModel node = nodeView.getModel();
        return modeController.createToolTip(node, this);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String toolTipText = super.getToolTipText(event);
        if (toolTipText != null) {
            return toolTipText;
        }
        return this.createToolTipText();
    }

    @Override
    public boolean contains(int x, int y) {
        Point p = new Point(x, y);
        return this.isInFoldingRegion(p) || this.isInDragRegion(p) || super.contains(x, y);
    }

    public boolean isInDragRegion(Point p) {
        if (p.y >= 0 && p.y < this.getHeight()) {
            NodeView nodeView = this.getNodeView();
            if (nodeView.isRoot()) {
                return false;
            }
            if (MapViewLayout.OUTLINE.equals((Object)nodeView.getMap().getLayoutType())) {
                return false;
            }
            int draggingWidth = this.getDraggingWidth();
            if (nodeView.isLeft()) {
                int width = this.getWidth();
                return p.x >= width && p.x < width + draggingWidth;
            }
            return p.x >= -draggingWidth && p.x < 0;
        }
        return false;
    }

    public boolean isInFoldingRegion(Point p) {
        if (this.hasChildren() && p.y >= 0 && p.y < this.getHeight()) {
            boolean isLeft = this.getNodeView().isLeft();
            int width = Math.max(16, this.getZoomedFoldingSymbolHalfWidth() * 2);
            if (isLeft) {
                boolean maxX = false;
                return p.x >= -width && p.x < 0;
            }
            int minX = this.getWidth();
            return p.x >= minX && p.x < this.getWidth() + width;
        }
        return false;
    }

    private boolean hasChildren() {
        NodeView nodeView = this.getNodeView();
        NodeModel node = nodeView.getModel();
        return node.hasChildren();
    }

    public MouseArea getMouseArea() {
        return this.mouseArea;
    }

    public MouseArea whichMouseArea(Point point) {
        int x = point.x;
        if (this.isInDragRegion(point)) {
            return MouseArea.MOTION;
        }
        if (this.isInFoldingRegion(point)) {
            return MouseArea.FOLDING;
        }
        if (this.isClickableLink(x)) {
            return MouseArea.LINK;
        }
        return MouseArea.DEFAULT;
    }

    public void setMouseArea(MouseArea mouseArea) {
        if (mouseArea.equals((Object)this.mouseArea)) {
            return;
        }
        boolean repaintDraggingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.MOTION) || this.mouseArea.equals((Object)MouseArea.MOTION));
        boolean repaintFoldingRectangle = this.isVisible() && (mouseArea.equals((Object)MouseArea.OUT) || mouseArea.equals((Object)MouseArea.FOLDING) || this.mouseArea.equals((Object)MouseArea.OUT) || this.mouseArea.equals((Object)MouseArea.FOLDING));
        this.mouseArea = mouseArea;
        if (repaintDraggingRectangle) {
            this.paintDraggingRectangleImmediately();
        }
        if (repaintFoldingRectangle) {
            this.paintFoldingRectangleImmediately();
        }
    }

    private void paintFoldingRectangleImmediately() {
        int y;
        int height;
        int zoomedFoldingSymbolHalfWidth = this.getZoomedFoldingSymbolHalfWidth();
        int width = Math.max(16, zoomedFoldingSymbolHalfWidth * 2);
        NodeView nodeView = this.getNodeView();
        int x = nodeView.isLeft() ? -width : this.getWidth();
        if (16 >= this.getHeight()) {
            height = 16;
            y = this.getHeight() - 16;
        } else {
            height = this.getHeight();
            y = 0;
        }
        Rectangle foldingRectangle = new Rectangle(x - 4, y - 4, width + 8, (height += zoomedFoldingSymbolHalfWidth) + 8);
        MapView map = nodeView.getMap();
        UITools.convertRectangleToAncestor(this, foldingRectangle, map);
        map.paintImmediately(foldingRectangle);
    }

    private void paintDraggingRectangleImmediately() {
        Rectangle dragRectangle = this.getDragRectangle();
        this.paintDecorationImmediately(dragRectangle);
    }

    private void paintDecorationImmediately(Rectangle rectangle) {
        MapView map = this.getMap();
        UITools.convertRectangleToAncestor(this, rectangle, map);
        map.paintImmediately(rectangle);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setMouseArea(MouseArea.DEFAULT);
        }
    }

    private int getDraggingWidth() {
        return this.getNodeView().getZoomed(10);
    }

    public UIIcon getUIIconAt(Point coordinate) {
        Icon icon = this.getIcon();
        if (icon instanceof MultipleImage) {
            Rectangle iconRectangle = this.getIconRectangle();
            Point transformedToIconCoordinate = new Point(coordinate);
            transformedToIconCoordinate.translate(-iconRectangle.x, -iconRectangle.y);
            return ((MultipleImage)icon).getUIIconAt(transformedToIconCoordinate);
        }
        return null;
    }

    public int getSingleChildShift() {
        return 0;
    }

    public static enum ConnectorLocation {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER;

    }

    static enum TextModificationState {
        NONE,
        HIGHLIGHT,
        FAILURE;

    }
}

