/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.EventQueue;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.HashSet;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.view.swing.map.MapView;

class MapViewChangeObserverCompound {
    private final HashSet<IMapSelectionListener> mapListeners = new HashSet();
    private final HashSet<IMapViewChangeListener> viewListeners = new HashSet();

    MapViewChangeObserverCompound() {
    }

    void addListener(IMapSelectionListener listener) {
        this.mapListeners.add(listener);
    }

    void addListener(IMapViewChangeListener listener) {
        this.viewListeners.add(listener);
    }

    void afterMapViewChange(MapView oldMap, MapView newMap) {
        MapModel newModel;
        MapModel oldModel = this.getModel(oldMap);
        if (oldModel != (newModel = this.getModel(newMap))) {
            for (IMapSelectionListener iMapSelectionListener : this.mapListeners.toArray(new IMapSelectionListener[0])) {
                iMapSelectionListener.afterMapChange(oldModel, newModel);
            }
        }
        for (IMapViewChangeListener iMapViewChangeListener : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            iMapViewChangeListener.afterViewChange(oldMap, newMap);
        }
    }

    void afterMapViewClose(MapView pOldMap) {
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewClose(pOldMap);
        }
    }

    void beforeMapViewChange(MapView oldMap, MapView newMap) {
        MapModel newModel;
        MapModel oldModel = this.getModel(oldMap);
        if (oldModel != (newModel = this.getModel(newMap))) {
            for (IMapSelectionListener iMapSelectionListener : this.mapListeners.toArray(new IMapSelectionListener[0])) {
                iMapSelectionListener.beforeMapChange(this.getModel(oldMap), this.getModel(newMap));
            }
        }
        for (IMapViewChangeListener iMapViewChangeListener : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            iMapViewChangeListener.beforeViewChange(oldMap, newMap);
        }
    }

    private MapModel getModel(MapView view) {
        return view == null ? null : view.getModel();
    }

    void mapViewCreated(MapView mapView) {
        if (!mapView.isShowing()) {
            this.fireMapViewCreatedAfterItIsDisplayed(mapView);
        } else if (!mapView.isLayoutCompleted()) {
            this.fireMapViewCreatedLater(mapView);
        } else {
            this.fireMapViewCreated(mapView);
        }
    }

    private void fireMapViewCreatedLater(final MapView view) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapViewChangeObserverCompound.this.mapViewCreated(view);
            }
        });
    }

    private void fireMapViewCreatedAfterItIsDisplayed(final MapView view) {
        HierarchyListener retryEventListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (view.isShowing()) {
                    view.removeHierarchyListener(this);
                    MapViewChangeObserverCompound.this.mapViewCreated(view);
                }
            }
        };
        view.addHierarchyListener(retryEventListener);
    }

    private void fireMapViewCreated(MapView mapView) {
        for (IMapViewChangeListener observer : this.viewListeners.toArray(new IMapViewChangeListener[0])) {
            observer.afterViewCreated(mapView);
        }
    }

    void removeListener(IMapSelectionListener listener) {
        this.mapListeners.remove(listener);
    }

    void removeListener(IMapViewChangeListener listener) {
        this.viewListeners.remove(listener);
    }
}

