/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.MapView;

public class MapViewScrollPane
extends JScrollPane
implements IFreeplanePropertyListener {
    private static final long serialVersionUID = 1L;
    private final Border defaultBorder;

    public MapViewScrollPane() {
        this.setViewport(new MapViewPort());
        this.defaultBorder = this.getBorder();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setScrollbarsVisiblilty();
        UITools.setScrollbarIncrement(this);
        ResourceController.getResourceController().addPropertyChangeListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ResourceController.getResourceController().removePropertyChangeListener(this);
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if ("fullscreen_enabled".equals(propertyName) || propertyName.startsWith("scrollbarsVisible")) {
            this.setScrollbarsVisiblilty();
        } else if (propertyName.equals("scrollbar_increment")) {
            int scrollbarIncrement = Integer.valueOf(newValue);
            this.getHorizontalScrollBar().setUnitIncrement(scrollbarIncrement);
            this.getVerticalScrollBar().setUnitIncrement(scrollbarIncrement);
        }
    }

    private void setScrollbarsVisiblilty() {
        ViewController viewController = Controller.getCurrentController().getViewController();
        boolean areScrollbarsVisible = viewController.areScrollbarsVisible();
        this.setHorizontalScrollBarPolicy(areScrollbarsVisible ? 32 : 31);
        this.setVerticalScrollBarPolicy(areScrollbarsVisible ? 22 : 21);
        boolean isFullScreenEnabled = !UITools.getCurrentFrame().isResizable();
        this.setBorder((Border)(isFullScreenEnabled && !areScrollbarsVisible ? null : this.defaultBorder));
    }

    @Override
    public void doLayout() {
        Component view;
        if (this.viewport != null && (view = this.viewport.getView()) != null) {
            view.invalidate();
        }
        super.doLayout();
    }

    @Override
    protected void validateTree() {
        MapView view;
        super.validateTree();
        if (this.viewport != null && (view = (MapView)this.viewport.getView()) != null) {
            view.scrollView();
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.viewport != null) {
            MapView mapView = (MapView)this.viewport.getView();
            ActionAcceleratorManager acceleratorManager = ResourceController.getResourceController().getAcceleratorManager();
            if (acceleratorManager.canProcessKeyEvent(e)) {
                return false;
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    static class MapViewPort
    extends JViewport {
        private boolean layoutInProgress = false;
        private Timer timer;

        MapViewPort() {
        }

        @Override
        public void doLayout() {
            Component view = this.getView();
            this.layoutInProgress = view != null && !view.isValid();
            super.doLayout();
            this.layoutInProgress = false;
        }

        @Override
        public void setViewPosition(Point p) {
            if (!this.layoutInProgress) {
                Integer scrollingDelay = (Integer)this.getClientProperty("slowScrolling");
                if (scrollingDelay != null && scrollingDelay != 0) {
                    this.putClientProperty("slowScrolling", null);
                    this.slowSetViewPosition(p, scrollingDelay);
                } else {
                    super.setViewPosition(p);
                    MapView view = (MapView)this.getView();
                    if (view != null) {
                        view.setAnchorContentLocation();
                    }
                }
            }
        }

        @Override
        public void setViewSize(Dimension newSize) {
            Component view = this.getView();
            if (view != null) {
                Dimension oldSize = view.getSize();
                if (newSize.equals(oldSize)) {
                    view.setSize(newSize);
                } else {
                    super.setViewSize(newSize);
                }
            }
        }

        private void slowSetViewPosition(final Point p, final int delay) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
            Point viewPosition = this.getViewPosition();
            int dx = p.x - viewPosition.x;
            int dy = p.y - viewPosition.y;
            int slowDx = this.calcScrollIncrement(dx);
            int slowDy = this.calcScrollIncrement(dy);
            viewPosition.translate(slowDx, slowDy);
            super.setViewPosition(viewPosition);
            if (slowDx == dx && slowDy == dy) {
                return;
            }
            this.timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapViewPort.this.timer = null;
                    MapViewPort.this.slowSetViewPosition(p, delay);
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private int calcScrollIncrement(int dx) {
            int v = ResourceController.getResourceController().getIntProperty("scrolling_speed");
            int slowDX = (int)((double)v / 5.0 * Math.sqrt(Math.abs(dx)));
            if (Math.abs(dx) > 2 && slowDX < Math.abs(dx)) {
                dx = slowDX * Integer.signum(dx);
            }
            return dx;
        }
    }
}

