/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.view.swing.map.VariableInsetsMainView;

class NarrowHexagonMainView
extends VariableInsetsMainView {
    private static final double HORIZONTAL_MARGIN_FACTOR = 1.0;
    private static final double UNIFORM_HEIGHT_TO_WIDTH_RELATION = 2.0 / Math.sqrt(3.0);
    private static final double VERTICAL_MARGIN_FACTOR = 2.0;
    private static final long serialVersionUID = 1L;

    public NarrowHexagonMainView(ShapeConfigurationModel shapeConfigurationModel) {
        super(shapeConfigurationModel);
    }

    @Override
    protected double getVerticalMarginFactor() {
        return 2.0;
    }

    @Override
    protected double getHorizontalMarginFactor() {
        return 1.0;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getShapeConfiguration().isUniform()) {
            Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.getMaximumWidth());
            double width = (int)Math.ceil((float)prefSize.width + this.getZoom() * (float)this.getMinimumHorizontalInset());
            width = this.limitWidth(width);
            prefSize.width = (int)width;
            prefSize.height = (int)(width * UNIFORM_HEIGHT_TO_WIDTH_RELATION);
            return prefSize;
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintNodeShape(Graphics2D g) {
        Polygon polygon = this.getPaintedShape();
        g.draw(polygon);
    }

    protected Polygon getPaintedShape() {
        Polygon polygon;
        if (this.getShapeConfiguration().isUniform()) {
            int[] xCoords = new int[]{this.getWidth() / 2, 0, 0, this.getWidth() / 2, this.getWidth() - 1, this.getWidth() - 1};
            int[] yCoords = new int[]{0, this.getHeight() / 4, 3 * this.getHeight() / 4, this.getHeight() - 1, 3 * this.getHeight() / 4, this.getHeight() / 4};
            polygon = new Polygon(xCoords, yCoords, xCoords.length);
        } else {
            int zoomedVerticalInset = (int)((double)this.getHeight() * (1.0 - 1.0 / this.getVerticalMarginFactor()) / 2.0);
            int[] xCoords = new int[]{0, this.getWidth() / 2, this.getWidth() - 1, this.getWidth() - 1, this.getWidth() / 2, 0};
            int[] yCoords = new int[]{zoomedVerticalInset, 0, zoomedVerticalInset, this.getHeight() - zoomedVerticalInset - 1, this.getHeight() - 1, this.getHeight() - zoomedVerticalInset - 1};
            polygon = new Polygon(xCoords, yCoords, xCoords.length);
        }
        return polygon;
    }

    @Override
    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fill(this.getPaintedShape());
    }
}

