/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import java.awt.Insets;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.view.swing.map.ShapedMainView;

abstract class VariableInsetsMainView
extends ShapedMainView {
    private static final long serialVersionUID = 1L;
    private int zoomedVerticalInset;
    private int zoomedHorizontalInset;

    public VariableInsetsMainView(ShapeConfigurationModel shapeConfiguration) {
        super(shapeConfiguration);
        this.zoomedVerticalInset = this.zoomedHorizontalInset = this.getMinimumHorizontalInset();
    }

    @Override
    protected boolean areInsetsFixed() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.getMaximumWidth());
        double widthWithMargin = Math.max((double)prefSize.width * this.getHorizontalMarginFactor(), (double)((float)prefSize.width + this.getZoom() * (float)this.getMinimumHorizontalInset()));
        prefSize.width = this.limitWidth((int)Math.ceil(widthWithMargin));
        prefSize.height = (int)Math.ceil(Math.max((double)prefSize.height * this.getVerticalMarginFactor(), (double)((float)prefSize.height + this.getZoom() * (float)this.getMinimumVerticalInset())));
        return prefSize;
    }

    protected abstract double getVerticalMarginFactor();

    protected abstract double getHorizontalMarginFactor();

    protected int getMinimumHorizontalInset() {
        return this.getShapeConfiguration().getHorizontalMargin().toBaseUnitsRounded();
    }

    protected int getMinimumVerticalInset() {
        return this.getShapeConfiguration().getVerticalMargin().toBaseUnitsRounded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getPreferredRectangleSizeWithoutMargin(int maximumWidth) {
        Dimension prefSize;
        int scaledMaximumWidth = maximumWidth != Integer.MAX_VALUE ? (int)((double)maximumWidth / this.getHorizontalMarginFactor()) : maximumWidth;
        int zoomedHorizontalInsetBackup = this.zoomedHorizontalInset;
        int zoomedVerticalInsetBackup = this.zoomedVerticalInset;
        float zoom = this.getZoom();
        this.zoomedHorizontalInset = (int)(zoom * (float)this.getMinimumHorizontalInset());
        this.zoomedVerticalInset = (int)(zoom * (float)this.getMinimumVerticalInset());
        int oldMinimumWidth = this.getMinimumWidth();
        int oldMaximumWidth = this.getMaximumWidth();
        try {
            this.setMinimumWidth(0);
            this.setMaximumWidth(scaledMaximumWidth);
            prefSize = super.getPreferredSize();
            prefSize.width -= this.zoomedHorizontalInset;
            prefSize.height -= this.zoomedVerticalInset;
        }
        finally {
            this.zoomedHorizontalInset = zoomedHorizontalInsetBackup;
            this.zoomedVerticalInset = zoomedVerticalInsetBackup;
            this.setMaximumWidth(oldMaximumWidth);
            this.setMinimumWidth(oldMinimumWidth);
        }
        return prefSize;
    }

    @Override
    public Insets getZoomedInsets() {
        int topInset = this.getZoomedVerticalInset();
        int leftInset = this.getZoomedHorizontalInset();
        return new Insets(topInset, leftInset, topInset, leftInset);
    }

    protected int getZoomedVerticalInset() {
        return this.zoomedVerticalInset;
    }

    protected int getZoomedHorizontalInset() {
        return this.zoomedHorizontalInset;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int oldMinimumWidth = this.getMinimumWidth();
        this.setMinimumWidth(0);
        Dimension preferredRectangleSize = this.getPreferredRectangleSizeWithoutMargin(this.getMaximumWidth());
        Dimension preferredSize = this.getPreferredSize();
        this.setMinimumWidth(oldMinimumWidth);
        super.setBounds(x, y, width, height);
        this.zoomedHorizontalInset = (Math.min(preferredSize.width, width) - preferredRectangleSize.width) / 2;
        this.zoomedVerticalInset = (Math.min(preferredSize.height, height) - preferredRectangleSize.height) / 2;
    }

    @Override
    public Insets getInsets() {
        Insets insets = this.getZoomedInsets();
        float zoom = this.getZoom();
        if (zoom != 1.0f) {
            insets.left = (int)((float)insets.left / zoom);
            insets.right = (int)((float)insets.right / zoom);
            insets.top = (int)((float)insets.top / zoom);
            insets.bottom = (int)((float)insets.bottom / zoom);
        }
        return insets;
    }

    @Override
    public Insets getInsets(Insets insets) {
        return this.getInsets();
    }
}

