/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.freeplane.features.nodestyle.ShapeConfigurationModel;
import org.freeplane.view.swing.map.VariableInsetsMainView;

class WideHexagonMainView
extends VariableInsetsMainView {
    private static final double VERTICAL_MARGIN_FACTOR = Math.sqrt(2.0);
    private static final double UNIFORM_HEIGHT_TO_WIDTH_RELATION = Math.sqrt(3.0) / 2.0;
    private static final double HORIZONTAL_MARGIN_FACTOR = Math.sqrt(2.0) / UNIFORM_HEIGHT_TO_WIDTH_RELATION;
    private static final long serialVersionUID = 1L;

    public WideHexagonMainView(ShapeConfigurationModel shapeConfigurationModel) {
        super(shapeConfigurationModel);
    }

    @Override
    protected double getVerticalMarginFactor() {
        return VERTICAL_MARGIN_FACTOR;
    }

    @Override
    protected double getHorizontalMarginFactor() {
        return HORIZONTAL_MARGIN_FACTOR;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (this.getShapeConfiguration().isUniform()) {
            Dimension prefSize = this.getPreferredRectangleSizeWithoutMargin(this.getMaximumWidth());
            double w = (float)prefSize.width + this.getZoom() * (float)this.getMinimumHorizontalInset();
            double h = (float)prefSize.height + this.getZoom() * (float)this.getMinimumVerticalInset();
            double diameter = Math.sqrt(w * w + h * h);
            double width = this.limitWidth(diameter / UNIFORM_HEIGHT_TO_WIDTH_RELATION);
            prefSize.width = (int)Math.ceil(width);
            prefSize.height = (int)(width * UNIFORM_HEIGHT_TO_WIDTH_RELATION);
            return prefSize;
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintNodeShape(Graphics2D g) {
        Polygon polygon = this.getPaintedShape();
        g.draw(polygon);
    }

    protected Polygon getPaintedShape() {
        Polygon polygon;
        if (this.getShapeConfiguration().isUniform()) {
            int[] xCoords = new int[]{0, this.getWidth() / 4, 3 * this.getWidth() / 4, this.getWidth(), 3 * this.getWidth() / 4, this.getWidth() / 4};
            int[] yCoords = new int[]{this.getHeight() / 2, 0, 0, this.getHeight() / 2, this.getHeight() - 1, this.getHeight() - 1};
            polygon = new Polygon(xCoords, yCoords, xCoords.length);
        } else {
            int zoomedHorizontalInset = (int)((double)this.getWidth() * (1.0 - 1.0 / this.getHorizontalMarginFactor()) / 2.0);
            int[] xCoords = new int[]{0, zoomedHorizontalInset, this.getWidth() - zoomedHorizontalInset - 1, this.getWidth(), this.getWidth() - zoomedHorizontalInset - 1, zoomedHorizontalInset};
            int[] yCoords = new int[]{this.getHeight() / 2, 0, 0, this.getHeight() / 2, this.getHeight() - 1, this.getHeight() - 1};
            polygon = new Polygon(xCoords, yCoords, xCoords.length);
        }
        return polygon;
    }

    @Override
    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fill(this.getPaintedShape());
    }
}

